/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.xtext.vtk.importer;

import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.january.geometry.Geometry;
import org.eclipse.january.geometry.IGeometryImporter;
import org.eclipse.january.geometry.INode;
import org.eclipse.january.geometry.PolyShape;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.xtext.example.mydsl.MyDslStandaloneSetup;

public class VTKGeometryImporter
implements IGeometryImporter {
    public EList<String> getFileTypes() {
        BasicInternalEList list = new BasicInternalEList(String.class);
        list.add((Object)"vtk");
        return list;
    }

    public String getDescription() {
        return "Imports geometry files in Wavefront's OBJ file format for use in the ICE Geometry Editor";
    }

    public Geometry load(Path path) {
        Injector injector = new MyDslStandaloneSetup().createInjectorAndDoEMFRegistration();
        XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        Resource resource = resourceSet.getResource(URI.createFileURI((String)path.toFile().getAbsolutePath()), true);
        EList contents = resource.getContents();
        Geometry geometry = null;
        if (contents != null && !contents.isEmpty()) {
            geometry = (Geometry)contents.get(0);
        }
        if (geometry != null) {
            for (INode node : geometry.getNodes()) {
                node.setParent((INode)geometry);
                if (!(node instanceof PolyShape)) continue;
                geometry.getVertexSource().getMaterialFiles().addAll((Collection)((PolyShape)node).getMaterialFiles());
                ((PolyShape)node).calculatePolyTriangles();
            }
        }
        return geometry;
    }

    public EClass eClass() {
        return null;
    }

    public Resource eResource() {
        return null;
    }

    public EObject eContainer() {
        return null;
    }

    public EStructuralFeature eContainingFeature() {
        return null;
    }

    public EReference eContainmentFeature() {
        return null;
    }

    public EList<EObject> eContents() {
        return null;
    }

    public TreeIterator<EObject> eAllContents() {
        return null;
    }

    public boolean eIsProxy() {
        return false;
    }

    public EList<EObject> eCrossReferences() {
        return null;
    }

    public Object eGet(EStructuralFeature feature) {
        return null;
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return null;
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return false;
    }

    public void eUnset(EStructuralFeature feature) {
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return null;
    }

    public EList<Adapter> eAdapters() {
        return null;
    }

    public boolean eDeliver() {
        return false;
    }

    public void eSetDeliver(boolean deliver) {
    }

    public void eNotify(Notification notification) {
    }

    public void setDescription(String value) {
    }
}

