/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.Sphere;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.january.geometry.impl.ShapeImpl;
import org.eclipse.january.geometry.util.MeshUtils;

public class SphereImpl
extends ShapeImpl
implements Sphere {
    protected static final double RADIUS_EDEFAULT = 0.0;
    protected double radius = 0.0;
    protected double prevRadius = 0.0;
    protected static final int RESOLUTION = 25;

    protected SphereImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.SPHERE;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double newRadius) {
        if (newRadius != this.radius) {
            double oldRadius = this.radius;
            this.radius = newRadius;
            if (this.properties.get("radius") == null || (Double)this.properties.get("radius") != this.radius) {
                this.properties.put("radius", this.radius);
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldRadius, this.radius));
            }
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getRadius();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setRadius((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setRadius(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.radius != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (radius: ");
        result.append(this.radius);
        result.append(')');
        return result.toString();
    }

    @Override
    public EList<Triangle> getTriangles() {
        Triangle tri0;
        if (this.prevRadius == this.radius && this.triangles != null && !this.triangles.isEmpty()) {
            return this.triangles;
        }
        this.prevRadius = this.radius;
        if (this.triangles == null) {
            this.triangles = new BasicInternalEList(Triangle.class);
        } else {
            this.triangles.clear();
        }
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        double stepSize = 0.08333333333333333;
        int i = 0;
        while (i < 23) {
            double currRadius = i < 11 ? (double)((float)Math.sqrt(1.0 - Math.pow(1.0 - stepSize * (double)((float)i + 1.0f), 2.0))) : (i > 11 ? (double)((float)Math.sqrt(1.0 - Math.pow(1.0 - (double)((float)i + 1.0f) * stepSize, 2.0))) : 1.0);
            double height = -this.radius + (double)(i + 1) * stepSize * this.radius;
            float[] circle = MeshUtils.createCircle((float)(currRadius *= this.radius), 25);
            int j = 0;
            while (j < 25) {
                Vertex vertex = GeometryFactory.eINSTANCE.createVertex();
                vertex.setX(circle[j * 2]);
                vertex.setY(height);
                vertex.setZ(circle[j * 2 + 1]);
                vertices.add(vertex);
                ++j;
            }
            currRadius = i <= 12 ? (double)((float)Math.pow(stepSize, (i + 1) * 2)) : (double)((float)Math.pow(stepSize, (25 - i + 1) * 2));
            height += stepSize;
            ++i;
        }
        int nadir = 575;
        int apex = nadir + 1;
        Vertex nadirVertex = GeometryFactory.eINSTANCE.createVertex();
        nadirVertex.setX(0.0);
        nadirVertex.setY(-this.radius);
        nadirVertex.setZ(0.0);
        vertices.add(nadirVertex);
        Vertex apexVertex = GeometryFactory.eINSTANCE.createVertex();
        apexVertex.setX(0.0);
        apexVertex.setY(this.radius);
        apexVertex.setZ(0.0);
        vertices.add(apexVertex);
        int i2 = 0;
        while (i2 < 22) {
            int j = 0;
            while (j < 25) {
                tri0 = GeometryFactory.eINSTANCE.createTriangle();
                int vIndex0 = j != 24 ? i2 * 25 + j + 1 : i2 * 25;
                tri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(i2 * 25 + j)).clone()));
                tri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get((i2 + 1) * 25 + j)).clone()));
                tri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vIndex0)).clone()));
                this.triangles.add((Object)tri0);
                Triangle tri1 = GeometryFactory.eINSTANCE.createTriangle();
                int vIndex1 = j != 0 ? (i2 + 1) * 25 + j - 1 : (i2 + 2) * 25 - 1;
                tri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(i2 * 25 + j)).clone()));
                tri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vIndex1)).clone()));
                tri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get((i2 + 1) * 25 + j)).clone()));
                this.triangles.add((Object)tri1);
                ++j;
            }
            ++i2;
        }
        int indexTopPoints = 550;
        int i3 = 0;
        while (i3 < 25) {
            tri0 = GeometryFactory.eINSTANCE.createTriangle();
            tri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(i3)).clone()));
            tri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get((i3 + 1) % 25)).clone()));
            tri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(nadir)).clone()));
            this.triangles.add((Object)tri0);
            Triangle tri1 = GeometryFactory.eINSTANCE.createTriangle();
            tri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(indexTopPoints + (i3 + 1) % 25)).clone()));
            tri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(indexTopPoints + i3)).clone()));
            tri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(apex)).clone()));
            this.triangles.add((Object)tri1);
            ++i3;
        }
        for (Triangle tri : this.triangles) {
            Vertex normal = tri.getNormal();
            EList<Vertex> currVertices = tri.getVertices();
            Vertex v0 = (Vertex)currVertices.get(0);
            Vertex v1 = (Vertex)currVertices.get(1);
            Vertex v2 = (Vertex)currVertices.get(2);
            normal.setX((v0.getX() + v1.getX() + v2.getX()) / 3.0);
            normal.setY((v0.getY() + v1.getY() + v2.getY()) / 3.0);
            normal.setZ((v0.getZ() + v1.getZ() + v2.getZ()) / 3.0);
        }
        return this.triangles;
    }

    @Override
    public void setProperty(String property, double value) {
        if ("radius".equals(property)) {
            this.setRadius(value);
        }
        super.setProperty(property, value);
    }

    @Override
    public Object clone() {
        Sphere clone = GeometryFactory.eINSTANCE.createSphere();
        clone.copy(this);
        return clone;
    }
}

