/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.january.geometry.BoundingBox;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.Pipe;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.impl.TubeImpl;
import org.eclipse.january.geometry.util.MeshUtils;

public class PipeImpl
extends TubeImpl
implements Pipe {
    protected static final int NUM_RODS_EDEFAULT = 0;
    protected int numRods = 0;
    protected static final int PITCH_EDEFAULT = 0;
    protected int pitch = 0;
    protected static final int ROD_DIAMETER_EDEFAULT = 0;
    protected int rodDiameter = 0;
    protected static final double ROTATION_X_EDEFAULT = 0.0;
    protected double rotationX = 0.0;
    protected static final double ROTATION_Y_EDEFAULT = 0.0;
    protected double rotationY = 0.0;
    protected static final double ROTATION_Z_EDEFAULT = 0.0;
    protected double rotationZ = 0.0;

    protected PipeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.PIPE;
    }

    @Override
    public int getNumRods() {
        return this.numRods;
    }

    @Override
    public void setNumRods(int newNumRods) {
        if (newNumRods != this.numRods) {
            int oldNumRods = this.numRods;
            this.numRods = newNumRods;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldNumRods, this.numRods));
            }
        }
    }

    @Override
    public int getPitch() {
        return this.pitch;
    }

    @Override
    public void setPitch(int newPitch) {
        if (newPitch != this.pitch) {
            int oldPitch = this.pitch;
            this.pitch = newPitch;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldPitch, this.pitch));
            }
        }
    }

    @Override
    public int getRodDiameter() {
        return this.rodDiameter;
    }

    @Override
    public void setRodDiameter(int newRodDiameter) {
        if (newRodDiameter != this.rodDiameter) {
            int oldRodDiameter = this.rodDiameter;
            this.rodDiameter = newRodDiameter;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldRodDiameter, this.rodDiameter));
            }
        }
    }

    @Override
    public double getRotationX() {
        return this.rotationX;
    }

    @Override
    public void setRotationX(double newRotationX) {
        if (newRotationX != this.rotationX) {
            double oldRotationX = this.rotationX;
            this.rotationX = newRotationX;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldRotationX, this.rotationX));
            }
        }
    }

    @Override
    public double getRotationY() {
        return this.rotationY;
    }

    @Override
    public void setRotationY(double newRotationY) {
        if (newRotationY != this.rotationY) {
            double oldRotationY = this.rotationY;
            this.rotationY = newRotationY;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldRotationY, this.rotationY));
            }
        }
    }

    @Override
    public double getRotationZ() {
        return this.rotationZ;
    }

    @Override
    public void setRotationZ(double newRotationZ) {
        if (newRotationZ != this.rotationZ) {
            double oldRotationZ = this.rotationZ;
            this.rotationZ = newRotationZ;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldRotationZ, this.rotationZ));
            }
        }
    }

    @Override
    public double getInnerRadius() {
        return this.getRadius();
    }

    @Override
    public void setInnerRadius(double innerRadius) {
        this.setRadius(innerRadius);
    }

    @Override
    public BoundingBox getLowerEdge() {
        return this.createEdgeBounds(false);
    }

    @Override
    public BoundingBox getUpperEdge() {
        return this.createEdgeBounds(true);
    }

    private BoundingBox createEdgeBounds(boolean lower) {
        double[] pointsOrig = MeshUtils.createCircle(this.radius, 25);
        double[] points = new double[75];
        int i = 0;
        while (i < 25) {
            points[i * 3] = pointsOrig[i * 2];
            points[i * 3 + 1] = lower ? (float)(-this.height / 2.0) : (float)this.height / 2.0f;
            points[i * 3 + 2] = pointsOrig[i * 2 + 1];
            ++i;
        }
        points = MeshUtils.rotatePoints(points, this.rotationX, this.rotationY, this.rotationZ);
        i = 0;
        while (i < points.length / 3) {
            points[i * 3] = points[i * 3] + this.center.getX();
            points[i * 3 + 1] = points[i * 3 + 1] + this.center.getY();
            points[i * 3 + 2] = points[i * 3 + 2] + this.center.getZ();
            ++i;
        }
        double minX = points[0];
        double minY = points[1];
        double minZ = points[2];
        double maxX = points[0];
        double maxY = points[1];
        double maxZ = points[2];
        int i2 = 0;
        while (i2 < points.length / 3) {
            if (minX > points[i2 * 3]) {
                minX = points[i2 * 3];
            } else if (maxX < points[i2 * 3]) {
                maxX = points[i2 * 3];
            }
            if (minY > points[i2 * 3 + 1]) {
                minY = points[i2 * 3 + 1];
            } else if (maxY < points[i2 * 3 + 1]) {
                maxY = points[i2 * 3 + 1];
            }
            if (minZ > points[i2 * 3 + 2]) {
                minZ = points[i2 * 3 + 2];
            } else if (maxZ < points[i2 * 3 + 2]) {
                maxZ = points[i2 * 3 + 2];
            }
            ++i2;
        }
        BoundingBox box = GeometryFactory.eINSTANCE.createBoundingBox();
        box.setMaxX(maxX);
        box.setMaxY(maxY);
        box.setMaxZ(maxZ);
        box.setMinX(minX);
        box.setMinY(minY);
        box.setMinZ(minZ);
        return box;
    }

    @Override
    public EList<Triangle> getTriangles() {
        if (this.triangles == null) {
            this.triangles = new BasicEList();
        }
        if (this.prevHeight == this.height && this.prevInnerRadius == this.innerRadius && this.prevRadius == this.radius) {
            return this.triangles;
        }
        this.prevRadius = this.radius;
        this.prevHeight = this.height;
        double[] vertices = MeshUtils.createTube(this.height, this.radius, this.radius, 25, 15);
        vertices = MeshUtils.rotatePoints(vertices, this.rotationX, this.rotationY, this.rotationZ);
        this.triangles.clear();
        this.triangles = MeshUtils.createTubeMesh(vertices, 25, 15);
        return this.triangles;
    }

    @Override
    public Object clone() {
        Pipe clone = GeometryFactory.eINSTANCE.createPipe();
        clone.copy(this);
        return clone;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getNumRods();
            }
            case 12: {
                return this.getPitch();
            }
            case 13: {
                return this.getRodDiameter();
            }
            case 14: {
                return this.getRotationX();
            }
            case 15: {
                return this.getRotationY();
            }
            case 16: {
                return this.getRotationZ();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setNumRods((Integer)newValue);
                return;
            }
            case 12: {
                this.setPitch((Integer)newValue);
                return;
            }
            case 13: {
                this.setRodDiameter((Integer)newValue);
                return;
            }
            case 14: {
                this.setRotationX((Double)newValue);
                return;
            }
            case 15: {
                this.setRotationY((Double)newValue);
                return;
            }
            case 16: {
                this.setRotationZ((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setNumRods(0);
                return;
            }
            case 12: {
                this.setPitch(0);
                return;
            }
            case 13: {
                this.setRodDiameter(0);
                return;
            }
            case 14: {
                this.setRotationX(0.0);
                return;
            }
            case 15: {
                this.setRotationY(0.0);
                return;
            }
            case 16: {
                this.setRotationZ(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.numRods != 0;
            }
            case 12: {
                return this.pitch != 0;
            }
            case 13: {
                return this.rodDiameter != 0;
            }
            case 14: {
                return this.rotationX != 0.0;
            }
            case 15: {
                return this.rotationY != 0.0;
            }
            case 16: {
                return this.rotationZ != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 8: {
                return this.getLowerEdge();
            }
            case 9: {
                return this.getUpperEdge();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (numRods: ");
        result.append(this.numRods);
        result.append(", pitch: ");
        result.append(this.pitch);
        result.append(", rodDiameter: ");
        result.append(this.rodDiameter);
        result.append(", rotationX: ");
        result.append(this.rotationX);
        result.append(", rotationY: ");
        result.append(this.rotationY);
        result.append(", rotationZ: ");
        result.append(this.rotationZ);
        result.append(')');
        return result.toString();
    }
}

