/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.DataComponent;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.IEntry;

@XmlRootElement(name="TableComponent")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TableComponent
extends ICEObject
implements Component {
    private Hashtable<Integer, ArrayList<IEntry>> rowTable;
    @XmlElement(name="ColumnNames")
    private ArrayList<String> columnNames = new ArrayList();
    @XmlElement(name="Row")
    private ArrayList<DataComponent> rowComponents = new ArrayList();
    @XmlElement(name="SelectedRow")
    private ArrayList<Integer> selectedRows;

    public TableComponent() {
        this.listeners = new ArrayList();
        this.selectedRows = new ArrayList();
    }

    public int numberOfRows() {
        if (this.rowComponents.size() <= 1) {
            return 0;
        }
        return this.rowComponents.size() - 1;
    }

    public int numberOfColumns() {
        return this.columnNames.size();
    }

    public ArrayList<IEntry> getRow(int index) {
        if (!(!this.rowComponents.isEmpty() & index < this.rowComponents.size() - 1 & index >= 0)) {
            return null;
        }
        ArrayList<IEntry> rowArray = new ArrayList<IEntry>();
        int i = 0;
        while (i < this.rowComponents.get(index + 1).retrieveAllEntries().size()) {
            rowArray.add(this.rowComponents.get(index + 1).retrieveAllEntries().get(i));
            ++i;
        }
        return rowArray;
    }

    public int addRow() {
        if (this.rowComponents.isEmpty()) {
            return -1;
        }
        DataComponent dataComponent = new DataComponent();
        dataComponent.setId(this.rowComponents.size() - 1);
        dataComponent.setName("Row");
        dataComponent.setDescription("This is a row");
        int i = 0;
        while (i < this.rowComponents.get(0).retrieveAllEntries().size()) {
            dataComponent.addEntry((IEntry)this.rowComponents.get(0).retrieveAllEntries().get(i).clone());
            ++i;
        }
        this.rowComponents.add(dataComponent);
        this.notifyListeners();
        return this.rowComponents.size() - 2;
    }

    public boolean deleteRow(int index) {
        if (!(!this.rowComponents.isEmpty() & index < this.rowComponents.size() - 1 & index >= 0)) {
            return false;
        }
        this.rowComponents.remove(index + 1);
        int i = index + 1;
        while (i < this.rowComponents.size()) {
            this.rowComponents.get(i).setId(i);
            ++i;
        }
        this.notifyListeners();
        return true;
    }

    public void setRowTemplate(ArrayList<IEntry> template) {
        int i = 0;
        DataComponent dataComponent = new DataComponent();
        dataComponent.setName(".xRowTemplatex.");
        dataComponent.setId(0);
        dataComponent.setDescription("This is a row template");
        if (!(template != null & this.columnNames.isEmpty())) {
            return;
        }
        i = 0;
        while (i < template.size()) {
            this.columnNames.add(template.get(i).getName());
            ++i;
        }
        i = 0;
        while (i < template.size()) {
            dataComponent.addEntry(template.get(i));
            ++i;
        }
        this.rowComponents.add(dataComponent);
        this.notifyListeners();
    }

    public ArrayList<IEntry> getRowTemplate() {
        int i = 0;
        if (this.columnNames.isEmpty()) {
            return null;
        }
        ArrayList<IEntry> rowTemplate = new ArrayList<IEntry>();
        i = 0;
        while (i < this.rowComponents.get(0).retrieveAllEntries().size()) {
            rowTemplate.add(this.rowComponents.get(0).retrieveAllEntries().get(i));
            ++i;
        }
        return rowTemplate;
    }

    public ArrayList<Integer> getRowIds() {
        ArrayList<Integer> rowIds = new ArrayList<Integer>();
        int i = 1;
        while (i < this.rowComponents.size()) {
            rowIds.add(this.rowComponents.get(i).getId());
            ++i;
        }
        return rowIds;
    }

    public ArrayList<String> getColumnNames() {
        ArrayList<String> rowArray = new ArrayList<String>();
        int i = 0;
        while (i < this.columnNames.size()) {
            rowArray.add(this.columnNames.get(i));
            ++i;
        }
        return rowArray;
    }

    public void copy(TableComponent otherTableComponent) {
        if (otherTableComponent == null) {
            return;
        }
        super.copy(otherTableComponent);
        this.columnNames.clear();
        int i = 0;
        while (i < otherTableComponent.columnNames.size()) {
            this.columnNames.add(otherTableComponent.columnNames.get(i));
            ++i;
        }
        this.rowComponents.clear();
        i = 0;
        while (i < otherTableComponent.rowComponents.size()) {
            this.rowComponents.add((DataComponent)otherTableComponent.rowComponents.get(i).clone());
            ++i;
        }
        this.setSelectedRows(otherTableComponent.getSelectedRows());
        this.notifyListeners();
    }

    @Override
    public Object clone() {
        TableComponent tableComponent = new TableComponent();
        tableComponent.copy(this);
        return tableComponent;
    }

    @Override
    public boolean equals(Object otherTableComponent) {
        boolean retVal = true;
        if (this == otherTableComponent) {
            return true;
        }
        if (otherTableComponent == null || !(otherTableComponent instanceof TableComponent)) {
            return false;
        }
        if (!super.equals(otherTableComponent)) {
            return false;
        }
        TableComponent castedComponent = (TableComponent)otherTableComponent;
        retVal = this.columnNames.equals(castedComponent.columnNames) && this.rowComponents.equals(castedComponent.rowComponents) && this.selectedRows.equals(castedComponent.selectedRows);
        return retVal;
    }

    @Override
    public int hashCode() {
        int hash = 9;
        hash = 31 * hash + super.hashCode();
        int i = 0;
        while (i < this.rowComponents.size()) {
            hash += 31 * this.rowComponents.get(i).hashCode();
            ++i;
        }
        return hash *= this.selectedRows.hashCode();
    }

    public ArrayList<Integer> getSelectedRows() {
        return !this.selectedRows.isEmpty() ? (ArrayList)this.selectedRows.clone() : null;
    }

    public void setSelectedRows(ArrayList<Integer> rows) {
        if (rows != null) {
            ArrayList<Integer> rowsToStore = new ArrayList<Integer>();
            ArrayList<Integer> rowIds = this.getRowIds();
            for (int rowId : rows) {
                if (!rowIds.contains(rowId)) continue;
                rowsToStore.add(rowId);
            }
            if (!rowsToStore.isEmpty()) {
                this.selectedRows = rowsToStore;
            }
        }
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        visitor.visit(this);
    }
}

