/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.january.form.AbstractEntry;
import org.eclipse.january.form.IEntryVisitor;
import org.eclipse.january.form.IUpdateable;

@XmlRootElement(name="DiscreteEntry")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DiscreteEntry
extends AbstractEntry {
    @XmlTransient
    protected String discreteErrMsg = "'${incorrectValue}' is an unacceptable value. The value must be one of ${allowedValues}.";
    @XmlElement(name="AllowedValues")
    protected List<String> allowedValues;

    public DiscreteEntry() {
        this.allowedValues = new ArrayList<String>();
    }

    public DiscreteEntry(String ... allowed) {
        this.allowedValues = Arrays.asList(allowed);
    }

    @Override
    public Object clone() {
        DiscreteEntry entry = new DiscreteEntry();
        entry.copy(this);
        return entry;
    }

    @Override
    public boolean setValue(String ... values) {
        throw new UnsupportedOperationException("Discrete only supports the storage of one String value, not many, selected from a list of allowed values. Therefore, this operation is not supported.");
    }

    @Override
    public boolean setValue(String newValue) {
        if (this.allowedValues.contains(newValue)) {
            this.errorMessage = null;
            return super.setValue(newValue);
        }
        String error = this.discreteErrMsg;
        String tempValues = "";
        int i = 0;
        while (i < this.allowedValues.size()) {
            if (i == this.allowedValues.size() - 1 && this.allowedValues.size() > 1) {
                tempValues = String.valueOf(tempValues) + " or";
            }
            tempValues = String.valueOf(tempValues) + " " + this.allowedValues.get(i);
            if (i < this.allowedValues.size() - 1 && this.allowedValues.size() > 2) {
                tempValues = String.valueOf(tempValues) + ",";
            }
            ++i;
        }
        error = error.replace("${incorrectValue}", newValue != null ? newValue : "null");
        this.errorMessage = error = error.replace(" ${allowedValues}", tempValues);
        return false;
    }

    @Override
    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public void setAllowedValues(List<String> values) {
        this.allowedValues = values;
        if (this.allowedValues != null && !this.allowedValues.isEmpty()) {
            this.setValue(this.allowedValues.get(0));
        }
    }

    @Override
    public void update(IUpdateable component) {
    }

    @Override
    public String[] getValues() {
        throw new UnsupportedOperationException("Discrete only supports the storage of one String value, not many, selected from a list of allowed values. Therefore, this operation is not supported.");
    }

    @Override
    public boolean equals(Object otherObject) {
        if (otherObject != null && otherObject instanceof DiscreteEntry) {
            if (!super.equals(otherObject)) {
                return false;
            }
            DiscreteEntry otherEntry = (DiscreteEntry)otherObject;
            if (this.allowedValues.equals(otherEntry.allowedValues)) {
                return true;
            }
        }
        return false;
    }

    public void copy(DiscreteEntry entity) {
        if (entity == null) {
            return;
        }
        super.copy(entity);
        this.allowedValues = entity.allowedValues;
    }

    @Override
    public int hashCode() {
        int hash = 11;
        hash = 31 * hash + super.hashCode();
        if (this.allowedValues != null) {
            hash = 31 * hash + this.allowedValues.hashCode();
        }
        return hash;
    }

    @Override
    public void accept(IEntryVisitor visitor) {
        visitor.visit(this);
    }
}

