/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.platform.jakarta.websocket.server.handshakerequest.authenticatedssl;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.ClientConfigurator;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.ClientEndpointConfig;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -5851958128006729743L;
    @ArquillianResource
    @OperateOnDeployment(value="https")
    protected URL urlHttps;
    String user;
    String password;
    String port;

    @Deployment(testable=false, name="https")
    @TargetsContainer(value="https")
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_platform_jakarta_websocket_handshakeresponse_ssl_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.platform.jakarta.websocket.server.handshakerequest.authenticatedssl"});
        archive.addClasses(new Class[]{IOUtil.class});
        archive.addAsWebInfResource(WSCClientIT.class.getPackage(), "web.xml", "web.xml");
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_platform_jakarta_websocket_handshakeresponse_ssl_web");
        this.setRequestProtocol("wss");
    }

    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.user = WSCClientIT.assertProperty((Properties)new Properties(), (String)"user");
        this.password = WSCClientIT.assertProperty((Properties)new Properties(), (String)"password");
        String secPortNum = System.getProperty("securedWebServicePort");
        String portNum = WSCClientIT.isNullOrEmpty((String)secPortNum) ? Integer.toString(this.urlHttps.getPort()) : secPortNum;
        this._port = Integer.parseInt(portNum);
    }

    @Test
    public void getUserPrincipalTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetUserPrincipalConfigurator", new String[]{String.valueOf(this.user)});
        this.addClientConfigurator((ClientEndpointConfig.Configurator)configurator);
        this.addAuthorisation();
        this.invoke("ssl/getuserprincipal", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void isUserInRoleTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("IsUserInRoleConfigurator", new String[]{String.valueOf(false)});
        configurator.addToRequest("IsUserInRoleConfigurator", new String[]{"DIRECTOR"});
        this.addClientConfigurator((ClientEndpointConfig.Configurator)configurator);
        this.addAuthorisation();
        this.invoke("ssl/isuserinrole", "anything", new String[]{"anything"});
        configurator.assertBeforeRequestHasBeenCalled();
        configurator.assertAfterResponseHasBeenCalled();
        configurator = new ClientConfigurator();
        configurator.addToResponse("IsUserInRoleConfigurator", new String[]{String.valueOf(true)});
        configurator.addToRequest("IsUserInRoleConfigurator", new String[]{"staff"});
        this.addAuthorisation();
        this.addClientConfigurator((ClientEndpointConfig.Configurator)configurator);
        this.invoke("ssl/isuserinrole", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
        configurator.assertBeforeRequestHasBeenCalled();
    }

    void addAuthorisation() {
        this.setProperty(WebSocketCommonClient.Property.BASIC_AUTH_USER, this.user);
        this.setProperty(WebSocketCommonClient.Property.BASIC_AUTH_PASSWD, this.password);
    }
}

