/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.packaging.ejb.resource_local;

import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.ee.packaging.ejb.resource_local.Client;
import ee.jakarta.tck.persistence.ee.packaging.ejb.resource_local.Stateless3IF;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Properties;

public class Stateless3IFProxy
implements InvocationHandler {
    private Properties testProps;

    public static Stateless3IF newInstance(Properties testProps) {
        return (Stateless3IF)Proxy.newProxyInstance(Stateless3IF.class.getClassLoader(), new Class[]{Stateless3IF.class}, (InvocationHandler)new Stateless3IFProxy(testProps));
    }

    private Stateless3IFProxy(Properties testProps) {
        this.testProps = testProps;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        boolean ok = false;
        if (methodName.equals("init")) {
            ok = true;
        } else if (methodName.equals("removeTestData")) {
            RemoteStatus status = this.sendGet("removeTestData");
            ok = true;
        } else {
            if (methodName.equals("toString")) {
                return Client.class.getName() + "-proxy";
            }
            if (methodName.startsWith("test")) {
                RemoteStatus status = this.sendGet(methodName);
                ok = status.toStatus().isPassed();
            } else {
                throw new UnsupportedOperationException("Method not supported: " + methodName);
            }
        }
        return ok;
    }

    private RemoteStatus sendGet(String methodName) throws Exception {
        String host = TestUtil.getProperty((Properties)this.testProps, (String)"webServerHost", (String)"localhost");
        String port = TestUtil.getProperty((Properties)this.testProps, (String)"webServerPort", (String)"8080");
        URI uri = URI.create("http://" + host + ":" + port + "/appclientproxy/appclient_novehicle?test=" + methodName);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
        HttpResponse<byte[]> response = HttpClient.newBuilder().build().send(request, HttpResponse.BodyHandlers.ofByteArray());
        if (response.statusCode() != 200) {
            String msg = String.format("Failed to send %s(), status code %d", methodName, response.statusCode());
            throw new IOException(msg);
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(response.body()));){
            RemoteStatus status;
            RemoteStatus remoteStatus = status = (RemoteStatus)ois.readObject();
            return remoteStatus;
        }
    }
}

