/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.appclient.deploy.metadatacomplete.testapp;

import com.sun.ts.lib.harness.Fault;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.appclient.deploy.metadatacomplete.testapp.DataStoreRemote;
import com.sun.ts.tests.common.base.EETest;
import jakarta.annotation.Resource;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.ejb.EJB;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSConnectionFactoryDefinition;
import jakarta.jms.JMSDestinationDefinition;
import jakarta.jms.Queue;
import jakarta.mail.MailSessionDefinition;
import jakarta.mail.Session;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnit;
import java.util.Properties;
import javax.naming.InitialContext;

@MailSessionDefinition(name="java:comp/myMailSession", host="smtp.gmail.com", transportProtocol="smtps", properties={"mail.debug=true"})
@DataSourceDefinition(name="java:global/MyApp/MyDataSource", className="oracle.jdbc.pool.OracleDataSource", url="jdbc:oracle:thin:@localhost:1521:orcl", user="TESTU", password="TESTU")
@JMSConnectionFactoryDefinition(description="Define ConnectionFactory JSPMyTestConnectionFactory", interfaceName="jakarta.jms.ConnectionFactory", name="java:global/JSPMyTestConnectionFactory", user="j2ee", password="j2ee")
@JMSDestinationDefinition(name="java:app/jms/myappTopic", interfaceName="jakarta.jms.Topic", destinationName="MyPhysicalAppTopic")
public class TestAppClient
extends EETest {
    private InitialContext initialContext;
    private TSNamingContext nctx = null;
    private Properties props = null;
    @Resource(lookup="java:comp/myMailSession")
    private static Session session;
    @EJB
    static DataStoreRemote dataStore;
    @Resource(lookup="java:app/jms/TestConnectionFactory")
    private static ConnectionFactory testFac;
    @Resource(lookup="java:app/jms/TestQ")
    private static Queue testQueue;
    @PersistenceUnit(unitName="TEST-EM-APPCLIENT")
    static EntityManagerFactory emf;

    public void setup(String[] args, Properties props) throws Fault {
        this.props = props;
        try {
            this.nctx = new TSNamingContext();
            this.logMsg("[Client] Setup succeed (got naming context).");
        }
        catch (Exception e) {
            throw new Fault("Setup failed:", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        TestAppClient theTests = new TestAppClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void testMailSession() throws Fault {
        try {
            Object sess = this.nctx.lookup("mail/MailSession");
            this.logMsg("sess" + sess);
            if (null == sess) {
                throw new Fault("lookup failed!");
            }
        }
        catch (Exception e) {
            throw new Fault("MailSession test failed: " + e, (Throwable)e);
        }
    }

    public void testMailSessionDefinition() throws Fault {
        try {
            this.logMsg("session" + session);
            this.logMsg("mail.debug:" + session.getProperty("mail.debug"));
            if (null != session) {
                throw new Fault("MailSessionDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new Fault("MailSessionDefinition test failed: " + e, (Throwable)e);
        }
    }

    public void testEJBAnnotation() throws Fault {
        try {
            this.logMsg("datastore" + dataStore);
            if (null != dataStore) {
                throw new Fault("EJBAnnotation test failed!");
            }
        }
        catch (Exception e) {
            throw new Fault("EJBAnnotation test failed: " + e, (Throwable)e);
        }
    }

    public void testDataSourceDefinitionAnnotation() throws Fault {
        try {
            Object dataSource = this.nctx.lookup("java:global/MyApp/MyDataSource");
            if (dataSource != null) {
                throw new Fault("DataSourceDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new Fault("DataSourceDefinition test failed: " + e, (Throwable)e);
        }
    }

    public void testJMSConnectionFactoryDefinitionAnnotation() throws Fault {
        try {
            Object connFactory = this.nctx.lookup("java:global/JSPMyTestConnectionFactory");
            this.logMsg("connFactory" + connFactory);
            if (connFactory != null) {
                throw new Fault("JMSConnectionFactoryDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new Fault("JMSConnectionFactoryDefinition test failed: " + e, (Throwable)e);
        }
    }

    public void testJMSDestinationDefinitionAnnotation() throws Fault {
        try {
            Object destination = this.nctx.lookup("java:app/jms/myappTopic");
            this.logMsg("destination" + destination);
            if (destination != null) {
                throw new Fault("JMSDestinationDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new Fault("JMSDestinationDefinition test failed: " + e, (Throwable)e);
        }
    }

    public void testConnectionFactoryDefinitionAnnotation() throws Fault {
        try {
            this.logMsg("testFac" + testFac);
            if (testFac != null) {
                throw new Fault("ConnectionFactoryDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new Fault("ConnectionFactoryDefinition test failed: " + e, (Throwable)e);
        }
    }

    public void testAdministeredObjectDefinitionAnnotation() throws Fault {
        try {
            this.logMsg("testQueue" + testQueue);
            if (testFac != null) {
                throw new Fault("AdministeredObjectDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new Fault("AdministeredObjectDefinition test failed: " + e, (Throwable)e);
        }
    }

    public void testPersistenceUnitDefinitionAnnotation() throws Fault {
        try {
            this.logMsg("emf" + emf);
            if (emf != null) {
                throw new Fault("PersistenceUnitDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new Fault("PersistenceUnitDefinition test failed: " + e, (Throwable)e);
        }
    }

    public void cleanup() throws Fault {
        this.logMsg("[Client] cleanup()");
    }
}

