/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.core.rest.jsonb.cdi;

import ee.jakarta.tck.core.rest.JaxRsActivator;
import ee.jakarta.tck.core.rest.jsonb.cdi.ApplicationResource;
import ee.jakarta.tck.core.rest.jsonb.cdi.CustomJsonbResolver;
import ee.jakarta.tck.core.rest.jsonb.cdi.KeysProducer;
import ee.jakarta.tck.core.rest.jsonb.cdi.SomeMessage;
import ee.jakarta.tck.core.rest.jsonb.cdi.Utils;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.util.Base64;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestReporter;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class CustomJsonbSerializationIT {
    static PrivateKey privateKey;
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() throws Exception {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(CustomJsonbSerializationIT.class.getSimpleName() + ".war"));
        String pubKeyString = CustomJsonbSerializationIT.generateKeyPair();
        ((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)archive.addClass(ApplicationResource.class)).addClass(CustomJsonbResolver.class)).addClass(KeysProducer.class)).addClass(SomeMessage.class)).addClass(Utils.class)).addClass(JaxRsActivator.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsResource((Asset)new StringAsset(pubKeyString), "key.pub");
        System.out.printf("test archive: %s\n", archive.toString(true));
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(new File("/tmp/" + archive.getName()), true);
        return archive;
    }

    private static String generateKeyPair() throws Exception {
        ECGenParameterSpec ecSpec = new ECGenParameterSpec("secp256r1");
        KeyPairGenerator g = KeyPairGenerator.getInstance("EC");
        g.initialize(ecSpec, new SecureRandom());
        KeyPair keyPair = g.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        privateKey = keyPair.getPrivate();
        System.out.println("Public key format: " + publicKey.getFormat());
        System.out.println("Private key format: " + privateKey.getFormat());
        String pubKeyString = Base64.getEncoder().encodeToString(publicKey.getEncoded());
        System.out.println(pubKeyString);
        return pubKeyString;
    }

    @Test
    public void testCustomSerializationWithCDIProvider(TestReporter reporter) throws Exception {
        URI appIdURI = this.contextPath.toURI().resolve("rest/json-tests");
        reporter.publishEntry(String.format("appIdURI: %s", appIdURI.toASCIIString()));
        SomeMessage sentMsg = new SomeMessage();
        sentMsg.setMsg("Hello from testCustomSerializationWithCDIProvider");
        sentMsg.setSender("testCustomSerializationWithCDIProvider");
        sentMsg.setRecipient("ApplicationResource");
        Signature ecdsaSign = Signature.getInstance("SHA256withECDSA");
        ecdsaSign.initSign(privateKey);
        ecdsaSign.update(sentMsg.getMsg().getBytes(StandardCharsets.UTF_8));
        byte[] signature = ecdsaSign.sign();
        sentMsg.setSignature(Base64.getEncoder().encodeToString(signature));
        try (Client client = ((ClientBuilder)ClientBuilder.newBuilder().register((Object)new CustomJsonbResolver())).build();){
            SomeMessage responseMsg = (SomeMessage)client.target(appIdURI).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.entity((Object)sentMsg, (MediaType)MediaType.APPLICATION_JSON_TYPE)).invoke(SomeMessage.class);
            System.out.println(responseMsg);
            Assertions.assertNotNull((Object)responseMsg, (String)"Received non-null reponse");
            Assertions.assertTrue((boolean)responseMsg.isSecure(), (String)"Reponse message was flagged secure");
            Assertions.assertTrue((boolean)responseMsg.isVerified(), (String)"Reponse message was flagged verified");
        }
    }

    @Test
    public void testMissingClientSerializationWithCDIProvider(TestReporter reporter) throws Exception {
        URI appIdURI = this.contextPath.toURI().resolve("rest/json-tests");
        reporter.publishEntry(String.format("appIdURI: %s", appIdURI.toASCIIString()));
        SomeMessage sentMsg = new SomeMessage();
        sentMsg.setMsg("Hello from testMissingClientSerializationWithCDIProvider");
        sentMsg.setSender("testMissingClientSerializationWithCDIProvider");
        sentMsg.setRecipient("ApplicationResource");
        Signature ecdsaSign = Signature.getInstance("SHA256withECDSA");
        ecdsaSign.initSign(privateKey);
        ecdsaSign.update(sentMsg.getMsg().getBytes(StandardCharsets.UTF_8));
        byte[] signature = ecdsaSign.sign();
        sentMsg.setSignature(Base64.getEncoder().encodeToString(signature));
        try (Client client = ClientBuilder.newBuilder().build();){
            Response response = client.target(appIdURI).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.entity((Object)sentMsg, (MediaType)MediaType.APPLICATION_JSON_TYPE)).invoke();
            System.out.printf("Response(%d), reason=%s\n", response.getStatus(), response.getStatusInfo().getReasonPhrase());
            List<Integer> expected = List.of(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), Integer.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()));
            Assertions.assertTrue((boolean)expected.contains(response.getStatus()), () -> String.format("Expected one of %s got %d: %s", expected, response.getStatus(), response.readEntity(String.class)));
        }
    }

    @Test
    public void testCustomSerializationWithCDIProviderBadSignature(TestReporter reporter) throws Exception {
        URI appIdURI = this.contextPath.toURI().resolve("rest/json-tests");
        reporter.publishEntry(String.format("appIdURI: %s", appIdURI.toASCIIString()));
        SomeMessage sentMsg = new SomeMessage();
        sentMsg.setMsg("Hello from testCustomSerializationWithCDIProviderBadSignature");
        sentMsg.setSender("testCustomSerializationWithCDIProviderBadSignature");
        sentMsg.setRecipient("ApplicationResource");
        sentMsg.setSignature(Base64.getEncoder().encodeToString("bad signature".getBytes(StandardCharsets.UTF_8)));
        try (Client client = ((ClientBuilder)ClientBuilder.newBuilder().register((Object)new CustomJsonbResolver())).build();){
            Response response = client.target(appIdURI).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.entity((Object)sentMsg, (MediaType)MediaType.APPLICATION_JSON_TYPE)).invoke();
            System.out.printf("Response(%d), reason=%s\n", response.getStatus(), response.getStatusInfo().getReasonPhrase());
            Assertions.assertEquals((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatus());
        }
    }

    @Test
    public void testCustomSerializationWithCDIProviderWrongSignature(TestReporter reporter) throws Exception {
        URI appIdURI = this.contextPath.toURI().resolve("rest/json-tests");
        reporter.publishEntry(String.format("appIdURI: %s", appIdURI.toASCIIString()));
        SomeMessage sentMsg = new SomeMessage();
        sentMsg.setMsg("Hello from testCustomSerializationWithCDIProviderBadSignature");
        sentMsg.setSender("testCustomSerializationWithCDIProviderBadSignature");
        sentMsg.setRecipient("ApplicationResource");
        Signature ecdsaSign = Signature.getInstance("SHA256withECDSA");
        ecdsaSign.initSign(privateKey);
        ecdsaSign.update("The wrong message".getBytes(StandardCharsets.UTF_8));
        byte[] signature = ecdsaSign.sign();
        sentMsg.setSignature(Base64.getEncoder().encodeToString(signature));
        try (Client client = ((ClientBuilder)ClientBuilder.newBuilder().register((Object)new CustomJsonbResolver())).build();){
            Response response = client.target(appIdURI).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.entity((Object)sentMsg, (MediaType)MediaType.APPLICATION_JSON_TYPE)).invoke();
            System.out.printf("Response(%d), reason=%s\n", response.getStatus(), response.getStatusInfo().getReasonPhrase());
            Assertions.assertEquals((int)Response.Status.METHOD_NOT_ALLOWED.getStatusCode(), (int)response.getStatus());
        }
    }
}

