/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.artifacts.common.StatusConstants;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import java.util.logging.Logger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeciderTests
extends BaseJUnit5Test
implements StatusConstants {
    private static final Logger logger = Logger.getLogger(DeciderTests.class.getName());
    private static JobOperatorBridge jobOp = null;
    private static final String FORCE_STOP_EXITSTATUS = "STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS";
    private static final String FORCE_FAIL_EXITSTATUS = "STEP_COMPLETE_BUT_FORCE_JOB_FAILED_STATUS";

    @BeforeEach
    public void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @Test
    public void testDeciderEndNormal() throws Exception {
        String METHOD = "testDeciderEndNormal";
        try {
            Reporter.log((String)"Build job parameters for EndSpecial exit status<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"Set job parameters property action with value EndNormal<p>");
            jobParameters.setProperty("action", "EndNormal");
            Reporter.log((String)"Set job parameters property actualValue with value 21<p>");
            jobParameters.setProperty("actualValue", "21");
            Reporter.log((String)"Set job parameters property SpecialExitStatus with value EndSpecial<p>");
            jobParameters.setProperty("SpecialExitStatus", "EndSpecial");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            Reporter.log((String)"Expected JobExecution getExitStatus()=EndNormal<p>");
            Reporter.log((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"Expected JobExecution getStatus()=COMPLETED<p>");
            Reporter.log((String)("Actual JobExecution getStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("EndNormal", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderEndSpecial() throws Exception {
        String METHOD = "testDeciderEndSpecial";
        try {
            Reporter.log((String)"Build job parameters for EndSpecial exit status<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("action", "EndNormal");
            Reporter.log((String)"Set job parameters property action with value EndNormal<p>");
            Reporter.log((String)"Set job parameters property actualValue with value 25<p>");
            jobParameters.setProperty("actualValue", "25");
            Reporter.log((String)"Set job parameters property SpecialExitStatus with value EndSpecial<p>");
            jobParameters.setProperty("SpecialExitStatus", "EndSpecial");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            Reporter.log((String)"Expected JobExecution getExitStatus()=EndSpecial<p>");
            Reporter.log((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"Expected JobExecution getBatchStatus()=COMPLETED<p>");
            Reporter.log((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("EndSpecial", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderStopNormal() throws Exception {
        String METHOD = " testDeciderStopNormal";
        try {
            Reporter.log((String)"Build job parameters for StopSpecial exit status<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"Set job parameters property action with value StopNormal<p>");
            jobParameters.setProperty("action", "StopNormal");
            Reporter.log((String)"Set job parameters property actualValue with value 21<p>");
            jobParameters.setProperty("actualValue", "21");
            Reporter.log((String)"Set job parameters property SpecialExitStatus with value StopSpecial<p>");
            jobParameters.setProperty("SpecialExitStatus", "StopSpecial");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            Reporter.log((String)"Expected JobExecution getExitStatus()=StopNormal<p>");
            Reporter.log((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"Expected JobExecution getBatchStatus()=STOPPED<p>");
            Reporter.log((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("StopNormal", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderStopSpecial() throws Exception {
        String METHOD = "testDeciderStopSpecial";
        try {
            Reporter.log((String)"Build job parameters for StopSpecial exit status<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"Set job parameters property action with value StopNormal<p>");
            jobParameters.setProperty("action", "StopNormal");
            Reporter.log((String)"Set job parameters property actualValue with value 25<p>");
            jobParameters.setProperty("actualValue", "25");
            Reporter.log((String)"Set job parameters property SpecialExitStatus with value StopSpecial<p>");
            jobParameters.setProperty("SpecialExitStatus", "StopSpecial");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            Reporter.log((String)"Expected JobExecution getExitStatus()=StopSpecial<p>");
            Reporter.log((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"Expected JobExecution getBatchStatus()=STOPPED<p>");
            Reporter.log((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("StopSpecial", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderFailNormal() throws Exception {
        String METHOD = "testDeciderFailNormal";
        try {
            Reporter.log((String)"Build job parameters for FailSpecial exit status<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"Set job parameters property action with value FailNormal<p>");
            jobParameters.setProperty("action", "FailNormal");
            Reporter.log((String)"Set job parameters property actualValue with value 21<p>");
            jobParameters.setProperty("actualValue", "21");
            Reporter.log((String)"Set job parameters property SpecialExitStatus with value FailSpecial<p>");
            jobParameters.setProperty("SpecialExitStatus", "FailSpecial");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            Reporter.log((String)"Expected JobExecution getExitStatus()=FailNormal<p>");
            Reporter.log((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"Expected JobExecution getBatchStatus()=FAILED<p>");
            Reporter.log((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("FailNormal", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderFailSpecial() throws Exception {
        String METHOD = "testDeciderFailSpecial";
        try {
            Reporter.log((String)"Build job parameters for FailSpecial exit status<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"Set job parameters property action with value FailNormal<p>");
            jobParameters.setProperty("action", "FailNormal");
            Reporter.log((String)"Set job parameters property actualValue with value 25<p>");
            jobParameters.setProperty("actualValue", "25");
            Reporter.log((String)"Set job parameters property SpecialExitStatus with value FailSpecial<p>");
            jobParameters.setProperty("SpecialExitStatus", "FailSpecial");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_incompleterun", jobParameters);
            Reporter.log((String)"Expected JobExecution getExitStatus()=FailSpecial<p>");
            Reporter.log((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"Expected JobExecution getBatchStatus()=FAILED<p>");
            Reporter.log((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("FailSpecial", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderNextNormal() throws Exception {
        String METHOD = "testDeciderNextNormal";
        try {
            Reporter.log((String)"Build job parameters for NextSpecial exit status<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"Set job parameters property action with value NextNormal<p>");
            jobParameters.setProperty("action", "NextNormal");
            Reporter.log((String)"Set job parameters property actualValue with value 21<p>");
            jobParameters.setProperty("actualValue", "21");
            Reporter.log((String)"Set job parameters property SpecialExitStatus with value NextSpecial<p>");
            jobParameters.setProperty("SpecialExitStatus", "NextSpecial");
            Reporter.log((String)"Create single job listener deciderTestJobListener and get JSL<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_completerun", jobParameters);
            Reporter.log((String)"Expected JobExecution getExitStatus()=JOB:ES:Good<p>");
            Reporter.log((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"Expected JobExecution getBatchStatus()=COMPLETED<p>");
            Reporter.log((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("JOB:ES:Good", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderNextSpecial() throws Exception {
        String METHOD = "testDeciderNextSpecial";
        try {
            Reporter.log((String)"Build job parameters for NextSpecial exit status<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"Set job parameters property action with value NextNormal<p>");
            jobParameters.setProperty("action", "NextNormal");
            Reporter.log((String)"Set job parameters property actualValue with value 25<p>");
            jobParameters.setProperty("actualValue", "25");
            Reporter.log((String)"Set job parameters property SpecialExitStatus with value NextSpecial<p>");
            jobParameters.setProperty("SpecialExitStatus", "NextSpecial");
            Reporter.log((String)"Create single job listener deciderTestJobListener and get JSL<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_decider_completerun", jobParameters);
            Reporter.log((String)"Expected JobExecution getExitStatus()=JOB:ES:Good<p>");
            Reporter.log((String)("Actual JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"Expected JobExecution getBatchStatus()=COMPLETED<p>");
            Reporter.log((String)("Actual JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals("JOB:ES:Good", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderExitStatusIsSetOnJobContext() throws Exception {
        String METHOD = "testDeciderExitStatusIsSetOnJobContext";
        try {
            Reporter.log((String)"Build job parameters.<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "None");
            jobParameters.setProperty("fail.job.after.this.step", "step1");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("1:STEP_COMPLETE_BUT_FORCE_JOB_FAILED_STATUS", jobExec.getExitStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderCannotbeFirstElementOnStart() throws Exception {
        String METHOD = "testDeciderCannotbeFirstElementOnStart";
        try {
            boolean seenException = false;
            TCKJobExecutionWrapper jobExec = null;
            try {
                jobExec = jobOp.startJobAndWaitForResult("decider_as_first_job_element_fails");
            }
            catch (JobStartException e) {
                Reporter.log((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                Reporter.log((String)("Didn't catch JobStartException, Job Batch Status = " + jobExec.getBatchStatus()));
                AssertionUtils.assertWithMessage("Job should have failed because of decision as first execution element.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderTransitionFromStepAndAllowRestart() throws Exception {
        String METHOD = "testDeciderTransitionFromStepAndAllowRestart";
        try {
            Reporter.log((String)"Build job parameters.<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "step1");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("1:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderTransitionFromStepWithinFlowAndAllowRestart() throws Exception {
        String METHOD = "testDeciderTransitionFromStepWithinFlowAndAllowRestart";
        try {
            Reporter.log((String)"Build job parameters.<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "flow1step1");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("2:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderTransitionFromFlowAndAllowRestart() throws Exception {
        String METHOD = "testDeciderTransitionFromFlowAndAllowRestart";
        try {
            Reporter.log((String)"Build job parameters.<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "flow1step2");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("3:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderTransitionFromSplitAndAllowRestart() throws Exception {
        String METHOD = "testDeciderTransitionFromSplitAndAllowRestart";
        try {
            Reporter.log((String)"Build job parameters.<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "true");
            jobParameters.setProperty("stop.job.after.this.step", "split1flow1step2");
            jobParameters.setProperty("stop.job.after.this.step2", "split1flow2step2");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_from_split_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("4:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            jobParameters.setProperty("stop.job.after.this.step2", "None");
            Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("4:split1flow2step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderTransitionFromStepAndAllowRestartFalse() throws Exception {
        String METHOD = "testDeciderTransitionFromStepAndAllowRestartFalse";
        try {
            Reporter.log((String)"Build job parameters.<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "false");
            jobParameters.setProperty("stop.job.after.this.step", "step1");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("1:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            restartJobParameters.setProperty("is.restart", "true");
            Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderTransitionFromStepWithinFlowAndAllowRestartFalse() throws Exception {
        String METHOD = "testDeciderTransitionFromStepWithinFlowAndAllowRestartFalse";
        try {
            Reporter.log((String)"Build job parameters.<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "false");
            jobParameters.setProperty("stop.job.after.this.step", "flow1step1");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("2:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            restartJobParameters.setProperty("is.restart", "true");
            Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderTransitionFromFlowAndAllowRestartFalse() throws Exception {
        String METHOD = "testDeciderTransitionFromFlowAndAllowRestartFalse";
        try {
            Reporter.log((String)"Build job parameters.<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "false");
            jobParameters.setProperty("stop.job.after.this.step", "flow1step2");
            jobParameters.setProperty("fail.job.after.this.step", "None");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("3:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            restartJobParameters.setProperty("is.restart", "true");
            Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("3:flow1step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDeciderTransitionFromSplitAndAllowRestartFalse() throws Exception {
        String METHOD = "testDeciderTransitionFromSplitAndAllowRestartFalse";
        try {
            Reporter.log((String)"Build job parameters.<p>");
            Properties jobParameters = new Properties();
            jobParameters.setProperty("step.complete.but.force.job.stopped.status", FORCE_STOP_EXITSTATUS);
            jobParameters.setProperty("step.complete.but.force.job.failed.status", FORCE_FAIL_EXITSTATUS);
            jobParameters.setProperty("allow.start.if.complete", "false");
            jobParameters.setProperty("stop.job.after.this.step", "split1flow1step2");
            jobParameters.setProperty("stop.job.after.this.step2", "split1flow2step2");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("decider_transitions_from_split_on_restart", jobParameters);
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("4:STEP_COMPLETE_BUT_FORCE_JOB_STOPPED_STATUS", jobExec.getExitStatus());
            Properties restartJobParameters = new Properties(jobParameters);
            restartJobParameters.setProperty("stop.job.after.this.step", "None");
            restartJobParameters.setProperty("is.restart", "true");
            Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec2 = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartJobParameters);
            AssertionUtils.assertObjEquals("4:split1flow2step2_CONTINUE", jobExec2.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            DeciderTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

