/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.wrappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.wrappers.TypeNodeWrapper;
import org.eclipse.hawk.graph.MetamodelNode;
import org.eclipse.hawk.graph.TypeNode;

public class MetamodelNodeWrapper
implements IGraphNodeReference {
    private final MetamodelNode metamodelNode;
    private final EOLQueryEngine model;

    public MetamodelNodeWrapper(MetamodelNode pn, EOLQueryEngine eolQueryEngine) {
        this.metamodelNode = pn;
        this.model = eolQueryEngine;
    }

    public String getId() {
        return this.metamodelNode.getNode().getId().toString();
    }

    public IGraphNode getNode() {
        return this.metamodelNode.getNode();
    }

    public String getTypeName() {
        return "_hawkPackageNode";
    }

    public IQueryEngine getContainerModel() {
        return this.model;
    }

    public String getUri() {
        return this.metamodelNode.getUri();
    }

    public String getMetamodelType() {
        return this.metamodelNode.getType();
    }

    public String getResource() {
        return this.metamodelNode.getResource();
    }

    public List<TypeNodeWrapper> getTypes() {
        ArrayList<TypeNodeWrapper> types = new ArrayList<TypeNodeWrapper>();
        for (TypeNode tn : this.metamodelNode.getTypes()) {
            types.add(new TypeNodeWrapper(tn, this.model));
        }
        return types;
    }

    public List<MetamodelNodeWrapper> getDependencies() {
        ArrayList<MetamodelNodeWrapper> deps = new ArrayList<MetamodelNodeWrapper>();
        for (MetamodelNode mn : this.metamodelNode.getDependencies()) {
            deps.add(new MetamodelNodeWrapper(mn, this.model));
        }
        return deps;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metamodelNode, this.model});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetamodelNodeWrapper other = (MetamodelNodeWrapper)obj;
        return Objects.equals(this.metamodelNode, other.metamodelNode) && Objects.equals((Object)this.model, (Object)other.model);
    }
}

