/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.contextful;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.contextful.AllOf;
import org.eclipse.hawk.epsilon.emc.contextful.DerivedAllOf;
import org.eclipse.hawk.epsilon.emc.contextful.FileFirstAllOf;
import org.eclipse.hawk.epsilon.emc.contextful.GlobPatternFileSupplier;
import org.eclipse.hawk.epsilon.emc.contextful.MemoizedSupplier;
import org.eclipse.hawk.epsilon.emc.contextful.SubtreeFileSupplier;
import org.eclipse.hawk.epsilon.emc.contextful.TypeFirstAllOf;
import org.eclipse.hawk.epsilon.emc.pgetters.CGraphPropertyGetter;
import org.eclipse.hawk.epsilon.emc.wrappers.FileNodeWrapper;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.ModelElementNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CEOLQueryEngine
extends EOLQueryEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(CEOLQueryEngine.class);
    private Function<IGraphNode, Iterable<? extends IGraphNode>> allFiles;
    private AllOf allOf;
    private boolean isTraversalScopingEnabled;

    public void setContext(Map<String, Object> context) {
        if (context == null) {
            context = Collections.emptyMap();
        }
        String sFilePatterns = (String)context.get("FILE");
        String sRepoPatterns = (String)context.get("REPOSITORY");
        String[] filePatterns = sFilePatterns != null && sFilePatterns.trim().length() != 0 ? sFilePatterns.split(",") : null;
        String[] repoPatterns = sRepoPatterns != null && sRepoPatterns.trim().length() != 0 ? sRepoPatterns.split(",") : null;
        List<String> fplist = filePatterns != null ? Arrays.asList(filePatterns) : null;
        List<String> rplist = repoPatterns != null ? Arrays.asList(repoPatterns) : null;
        this.name = (String)context.getOrDefault("name", "Model");
        this.setDefaultNamespaces((String)context.get("DEFAULTNAMESPACES"));
        this.isTraversalScopingEnabled = Boolean.parseBoolean((String)context.getOrDefault("ENABLE_TRAVERSAL_SCOPING", "false"));
        if (this.isTraversalScopingEnabled) {
            LOGGER.debug("Full Traversal Scoping ENABLED");
        }
        boolean filterByFileFirst = Boolean.parseBoolean((String)context.getOrDefault("FILEFIRST", "false"));
        String sSubtreeRootFile = (String)context.get("SUBTREE");
        boolean allOfDerived = Boolean.parseBoolean((String)context.getOrDefault("SUBTREE_DERIVEDALLOF", "false"));
        if (sSubtreeRootFile == null) {
            MemoizedSupplier<Set<IGraphNode>> supplier = new MemoizedSupplier<Set<IGraphNode>>(new GlobPatternFileSupplier(this.graph, fplist, rplist));
            this.allFiles = dummy -> (Iterable)supplier.get();
        } else {
            MemoizedSupplier<Set<IGraphNode>> supplier = new MemoizedSupplier<Set<IGraphNode>>(new SubtreeFileSupplier(this.graph, sSubtreeRootFile, rplist));
            this.allFiles = dummy -> (Iterable)supplier.get();
        }
        this.allOf = sSubtreeRootFile != null && allOfDerived ? new DerivedAllOf(this.indexer, this, rplist, sSubtreeRootFile) : (filterByFileFirst ? new FileFirstAllOf(this.allFiles, this) : new TypeFirstAllOf(this.allFiles, this));
        this.propertyGetter = new CGraphPropertyGetter(this.graph, this);
    }

    @Override
    public Collection<?> allContents() {
        Iterable<? extends IGraphNode> files = this.allFiles.apply(null);
        if (!files.iterator().hasNext()) {
            return Collections.emptyList();
        }
        Iterator<? extends IGraphNode> itFiles = files.iterator();
        FileNode firstFile = new FileNode(itFiles.next());
        Iterable firstFileElements = firstFile.getModelElements();
        if (firstFileElements instanceof IGraphIterable) {
            ArrayList<IGraphIterable<ModelElementNode>> iterables = new ArrayList<IGraphIterable<ModelElementNode>>();
            iterables.add((IGraphIterable)firstFileElements);
            while (itFiles.hasNext()) {
                FileNode fn = new FileNode(itFiles.next());
                iterables.add((IGraphIterable<ModelElementNode>)((IGraphIterable)fn.getModelElements()));
            }
            return new IGraphIterablesCollection(iterables);
        }
        HashSet<IGraphNodeReference> allContents = new HashSet<IGraphNodeReference>();
        for (ModelElementNode elem : firstFileElements) {
            allContents.add(this.wrap(elem.getNode()));
        }
        while (itFiles.hasNext()) {
            FileNode fn = new FileNode(itFiles.next());
            for (ModelElementNode elem : fn.getModelElements()) {
                allContents.add(this.wrap(elem.getNode()));
            }
        }
        return allContents;
    }

    @Override
    public Collection<Object> getAllOf(IGraphNode typeNode, String typeorkind) {
        Collection<Object> nodes = this.createAllOfCollection(typeNode);
        this.allOf.addAllOf(typeNode, typeorkind, nodes);
        return nodes;
    }

    @Override
    public Set<FileNodeWrapper> getFiles() {
        HashSet<FileNodeWrapper> allFNW = new HashSet<FileNodeWrapper>();
        for (IGraphNode iGraphNode : this.allFiles.apply(null)) {
            allFNW.add(new FileNodeWrapper(new FileNode(iGraphNode), this));
        }
        return allFNW;
    }

    public Set<IGraphNode> getRawFileNodes() {
        HashSet<IGraphNode> nodes = new HashSet<IGraphNode>();
        for (IGraphNode iGraphNode : this.allFiles.apply(null)) {
            nodes.add(iGraphNode);
        }
        return nodes;
    }

    public boolean isTraversalScopingEnabled() {
        return this.isTraversalScopingEnabled;
    }

    @Override
    public String getHumanReadableName() {
        return "CEOL Query Engine";
    }

    protected class IGraphIterablesCollection
    implements Collection<IGraphNodeReference> {
        private final List<IGraphIterable<ModelElementNode>> iterables;
        private Set<IGraphNodeReference> elements;

        protected IGraphIterablesCollection(List<IGraphIterable<ModelElementNode>> iterables) {
            this.iterables = iterables;
        }

        @Override
        public int size() {
            int total = 0;
            for (IGraphIterable<ModelElementNode> graphIterable : this.iterables) {
                total += graphIterable.size();
            }
            return total;
        }

        @Override
        public boolean isEmpty() {
            for (IGraphIterable<ModelElementNode> graphIterable : this.iterables) {
                if (graphIterable.size() <= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return this.getElements().contains(o);
        }

        private Set<IGraphNodeReference> getElements() {
            if (this.elements == null) {
                this.elements = new HashSet<IGraphNodeReference>();
                for (IGraphIterable<ModelElementNode> iterable : this.iterables) {
                    for (ModelElementNode e : iterable) {
                        this.elements.add(CEOLQueryEngine.this.wrap(e.getNode()));
                    }
                }
            }
            return this.elements;
        }

        @Override
        public Iterator<IGraphNodeReference> iterator() {
            return this.getElements().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.getElements().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getElements().toArray(a);
        }

        @Override
        public boolean add(IGraphNodeReference e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.getElements().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends IGraphNodeReference> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

