/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.iteration;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;

public class EndNodeEdgeIterable
implements Iterable<IGraphEdge> {
    private final Iterable<IGraphNode> endNodes;
    private final Function<IGraphNode, IGraphEdge> endNodeToEdge;

    public EndNodeEdgeIterable(Iterable<IGraphNode> endNodes, Function<IGraphNode, IGraphEdge> endNodeToEdge) {
        this.endNodes = endNodes;
        this.endNodeToEdge = endNodeToEdge;
    }

    @Override
    public Iterator<IGraphEdge> iterator() {
        final Iterator<IGraphNode> itEndNodes = this.endNodes.iterator();
        return new Iterator<IGraphEdge>(){
            IGraphEdge next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    while (this.next == null && itEndNodes.hasNext()) {
                        IGraphNode endNode = (IGraphNode)itEndNodes.next();
                        this.next = (IGraphEdge)EndNodeEdgeIterable.this.endNodeToEdge.apply(endNode);
                    }
                }
                return this.next != null;
            }

            @Override
            public IGraphEdge next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IGraphEdge ret = this.next;
                this.next = null;
                return ret;
            }
        };
    }
}

