/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emfresource.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackHelper;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.hawk.emfresource.util.BridgeClassLoader;

public class LazyEObjectFactory {
    private EPackage.Registry packageRegistry;
    private MethodInterceptor methodInterceptor;
    private Map<Class<?>, Factory> factories = null;

    public LazyEObjectFactory(EPackage.Registry registry, MethodInterceptor interceptor) {
        this.packageRegistry = registry;
        this.methodInterceptor = interceptor;
    }

    public EObject createInstance(EClass eClass) {
        String nsURI = eClass.getEPackage().getNsURI();
        EFactory factory = this.packageRegistry.getEFactory(nsURI);
        if (factory == null) {
            throw new NoSuchElementException(String.format("Could not find the EFactory for nsURI '%s' in the resource set's package registry", nsURI));
        }
        EObject obj = factory.create(eClass);
        return this.createLazyLoadingInstance(eClass, obj.getClass());
    }

    private EObject createLazyLoadingInstance(final EClass eClass, Class<?> klass) {
        EObject o;
        Factory factory;
        if (this.factories == null) {
            this.factories = new HashMap();
        }
        if ((factory = this.factories.get(klass)) == null) {
            Enhancer enh = new Enhancer();
            CallbackHelper helper = new CallbackHelper(klass, new Class[0]){

                protected Object getCallback(Method m) {
                    if ("eGet".equals(m.getName()) && m.getParameterTypes().length > 0 && EStructuralFeature.class.isAssignableFrom(m.getParameterTypes()[0])) {
                        return LazyEObjectFactory.this.methodInterceptor;
                    }
                    if ("eContents".equals(m.getName()) && m.getParameterTypes().length == 0) {
                        return LazyEObjectFactory.this.methodInterceptor;
                    }
                    if ("eContainer".equals(m.getName()) && m.getParameterTypes().length == 0) {
                        return LazyEObjectFactory.this.methodInterceptor;
                    }
                    if ("eInternalContainer".equals(m.getName()) && m.getParameterTypes().length == 0) {
                        return LazyEObjectFactory.this.methodInterceptor;
                    }
                    if ("eContainerFeatureID".equals(m.getName()) && m.getParameterTypes().length == 0) {
                        return LazyEObjectFactory.this.methodInterceptor;
                    }
                    if ("eContainingFeature".equals(m.getName()) && m.getParameterTypes().length == 0) {
                        return LazyEObjectFactory.this.methodInterceptor;
                    }
                    if ("eContainmentFeature".equals(m.getName()) && m.getParameterTypes().length == 0) {
                        return LazyEObjectFactory.this.methodInterceptor;
                    }
                    if ("eResource".equals(m.getName()) && m.getParameterTypes().length == 0) {
                        return LazyEObjectFactory.this.methodInterceptor;
                    }
                    if ("eIsSet".equals(m.getName()) && m.getParameterTypes().length == 1 && EStructuralFeature.class.isAssignableFrom(m.getParameterTypes()[0])) {
                        return LazyEObjectFactory.this.methodInterceptor;
                    }
                    if (m.getName().startsWith("get") && m.getParameterTypes().length == 0) {
                        EReference eRef = LazyEObjectFactory.this.guessEReferenceFromGetter(eClass, m.getName());
                        if (eRef != null) {
                            return LazyEObjectFactory.this.methodInterceptor;
                        }
                        return NoOp.INSTANCE;
                    }
                    return NoOp.INSTANCE;
                }
            };
            enh.setSuperclass(klass);
            enh.setClassLoader((ClassLoader)new BridgeClassLoader(this.getClass().getClassLoader(), klass.getClassLoader()));
            enh.setCallbackFilter((CallbackFilter)helper);
            enh.setCallbacks(helper.getCallbacks());
            o = (EObject)enh.create();
            this.factories.put(klass, (Factory)o);
        } else {
            o = (EObject)factory.newInstance(factory.getCallbacks());
        }
        if (o instanceof DynamicEObjectImpl) {
            ((DynamicEObjectImpl)o).eSetClass(eClass);
        }
        return o;
    }

    public EReference guessEReferenceFromGetter(EClass eClass, String methodName) {
        assert (methodName.startsWith("get")) : "method name should start with get";
        String referenceName = methodName.substring("get".length());
        if (referenceName.length() == 0) {
            return null;
        }
        EStructuralFeature sf = eClass.getEStructuralFeature(referenceName);
        if (sf == null) {
            referenceName = String.valueOf(Character.toLowerCase(referenceName.charAt(0))) + referenceName.substring(1);
            sf = eClass.getEStructuralFeature(referenceName);
        }
        if (sf instanceof EReference) {
            return (EReference)sf;
        }
        return null;
    }
}

