/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.indexes;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hawk.orientdb.OrientDatabase;
import org.eclipse.hawk.orientdb.util.OrientNameCleaner;

public class AbstractOrientIndex {
    private static final String SEPARATOR_SBTREE = "_sbtree_";
    protected final String name;
    protected final String escapedName;
    protected final OrientDatabase graph;
    protected final IndexType type;

    protected static Object normalizeValue(Object valueExpr) {
        if (valueExpr instanceof Byte || valueExpr instanceof Short || valueExpr instanceof Long) {
            valueExpr = ((Number)valueExpr).intValue();
        } else if (valueExpr instanceof Float) {
            valueExpr = ((Float)valueExpr).doubleValue();
        } else if (valueExpr instanceof String || valueExpr instanceof Integer || valueExpr instanceof Double) {
            return valueExpr;
        }
        return valueExpr.toString();
    }

    public String getName() {
        return this.name;
    }

    public OrientDatabase getDatabase() {
        return this.graph;
    }

    public AbstractOrientIndex(String name, OrientDatabase graph, IndexType type) {
        this.name = name;
        this.graph = graph;
        this.type = type;
        this.escapedName = OrientNameCleaner.escapeToField(name);
    }

    protected OIndex<?> getOrCreateFieldIndex(String field, Class<?> valueClass) {
        String idxName = this.getSBTreeIndexName(valueClass);
        OIndexManager indexManager = this.getIndexManager();
        OIndex idx = indexManager.getIndex(idxName);
        if (idx == null) {
            this.createIndex(valueClass);
            idx = indexManager.getIndex(idxName);
            if (this.type == IndexType.NODE) {
                this.graph.getIndexStore().addNodeFieldIndex(this.name, field);
            } else {
                this.graph.getIndexStore().addEdgeFieldIndex(this.name, field);
            }
        }
        return idx;
    }

    protected void createIndex(Class<?> keyClass) {
        OIndexManager indexManager = this.getIndexManager();
        String idxName = this.getSBTreeIndexName(keyClass);
        boolean txWasOpen = this.graph.getGraph().getTransaction().isActive();
        if (txWasOpen) {
            this.graph.getConsole().println("Warning: prematurely committing a transaction so we can create index " + idxName);
            this.graph.saveDirty();
            this.graph.getGraph().commit();
        }
        OType keyType = OType.STRING;
        if (keyClass == Byte.class || keyClass == Short.class || keyClass == Integer.class || keyClass == Long.class) {
            keyType = OType.INTEGER;
        } else if (keyClass == Float.class || keyClass == Double.class) {
            keyType = OType.DOUBLE;
        }
        OIndexFactory factory = OIndexes.getFactory((String)OClass.INDEX_TYPE.NOTUNIQUE.toString(), null);
        OSimpleKeyIndexDefinition indexDef = new OSimpleKeyIndexDefinition(factory.getLastVersion(), new OType[]{OType.STRING, keyType});
        indexManager.createIndex(idxName, OClass.INDEX_TYPE.NOTUNIQUE.toString(), (OIndexDefinition)indexDef, null, null, null, null);
        if (txWasOpen) {
            this.graph.getGraph().begin();
        }
    }

    protected String getSBTreeIndexName(Class<?> keyClass) {
        OType keyType = OType.STRING;
        if (keyClass == Byte.class || keyClass == Short.class || keyClass == Integer.class || keyClass == Long.class) {
            keyType = OType.INTEGER;
        } else if (keyClass == Float.class || keyClass == Double.class) {
            keyType = OType.DOUBLE;
        }
        return String.valueOf(this.escapedName) + SEPARATOR_SBTREE + keyType.name();
    }

    protected OIndexManager getIndexManager() {
        ODatabaseDocumentTx rawGraph = this.graph.getGraph();
        OIndexManagerProxy indexManager = rawGraph.getMetadata().getIndexManager();
        return indexManager;
    }

    protected OIndex<?> getIndex(Class<? extends Object> valueClass) {
        return this.getIndexManager().getIndex(this.getSBTreeIndexName(valueClass));
    }

    public static Object getMaxValue(Class<?> klass) {
        if (klass == Double.class) {
            return Double.MAX_VALUE;
        }
        if (klass == Integer.class) {
            return Integer.MAX_VALUE;
        }
        return "\uffff";
    }

    public static Object getMinValue(Class<?> klass) {
        if (klass == Double.class) {
            return Double.MIN_VALUE;
        }
        if (klass == Integer.class) {
            return Integer.MIN_VALUE;
        }
        return "";
    }

    public static OIndexCursor iterateEntriesBetween(String key, Object from, Object to, boolean fromInclusive, boolean toInclusive, OIndex<?> idx, ODatabase<?> db) {
        return AbstractOrientIndex.iterateEntriesBetween(new OCompositeKey(new Object[]{key, from}), fromInclusive, new OCompositeKey(new Object[]{key, to}), toInclusive, idx, db);
    }

    public static OIndexCursor iterateEntriesBetween(OCompositeKey cmpFrom, boolean fromInclusive, OCompositeKey cmpTo, boolean toInclusive, OIndex<?> idx, ODatabase<?> db) {
        if (db.getURL().startsWith("remote:")) {
            StringBuilder query = new StringBuilder("select from index:%s where ");
            if (fromInclusive) {
                query.append("key >= ?");
            } else {
                query.append("key > ?");
            }
            query.append(" and ");
            if (toInclusive) {
                query.append("key <= ?");
            } else {
                query.append("key < ?");
            }
            String sql = String.format(query.toString(), idx.getName());
            OCommandSQL cmd = new OCommandSQL(sql);
            Collection result = (Collection)db.command((OCommandRequest)cmd).execute(new Object[]{cmpFrom, cmpTo});
            return new DocumentCollectionOIndexCursor(result);
        }
        return idx.iterateEntriesBetween((Object)cmpFrom, fromInclusive, (Object)cmpTo, toInclusive, true);
    }

    protected static final class DocumentCollectionOIndexCursor
    extends OIndexAbstractCursor {
        private final Iterator<ODocument> documentIterator;

        protected DocumentCollectionOIndexCursor(Collection<ODocument> result) {
            this.documentIterator = result.iterator();
        }

        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (!this.documentIterator.hasNext()) {
                return null;
            }
            final ODocument value = this.documentIterator.next();
            return new Map.Entry<Object, OIdentifiable>(){

                @Override
                public Object getKey() {
                    return value.field("key");
                }

                @Override
                public OIdentifiable getValue() {
                    return (OIdentifiable)value.field("rid");
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value2) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }
    }

    public static enum IndexType {
        NODE,
        EDGE;

    }
}

