/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.hawk.core.IFileImporter;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.model.IHawkModelResource;
import org.eclipse.hawk.modelio.exml.model.ModelioModelResource;
import org.eclipse.hawk.modelio.exml.model.parser.ExmlObject;
import org.eclipse.hawk.modelio.exml.model.parser.ExmlParser;

public class ModelioModelResourceFactory
implements IModelResourceFactory {
    Map<String, String> mmPackageVersions;
    private static final String EXML_EXT = ".exml";
    private static final Set<String> MODEL_EXTS = new HashSet<String>();

    static {
        MODEL_EXTS.add(EXML_EXT);
        MODEL_EXTS.add(".ramc");
        MODEL_EXTS.add(".modelio.zip");
    }

    public Map<String, String> getMmPackageVersions() {
        return this.mmPackageVersions;
    }

    public String getHumanReadableName() {
        return "Modelio Model Factory";
    }

    public IHawkModelResource parse(IFileImporter importer, File f) throws Exception {
        this.extractVersionsForModel(importer, f);
        if (f.getName().toLowerCase().endsWith(EXML_EXT)) {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileInputStream fIS = new FileInputStream(f);){
                ExmlParser parser = new ExmlParser();
                ExmlObject object = parser.getObject(f, fIS);
                return new ModelioModelResource(object, (IModelResourceFactory)this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Throwable throwable = null;
        Object var4_9 = null;
        try (ZipFile zf = new ZipFile(f);){
            ExmlParser parser = new ExmlParser();
            Iterable<ExmlObject> objects = parser.getObjects(f);
            return new ModelioModelResource(objects, (IModelResourceFactory)this);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void shutdown() {
    }

    public boolean canParse(File f) {
        for (String ext : MODEL_EXTS) {
            if (!f.getName().toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getModelExtensions() {
        return MODEL_EXTS;
    }

    public String getPackgeVersion(String pkgName) {
        if (this.mmPackageVersions == null) {
            return null;
        }
        return this.mmPackageVersions.get(pkgName);
    }

    private void extractVersionsForModel(IFileImporter importer, File f) throws IOException {
        int maxSearchDepth = 4;
        String parentName = "";
        Boolean lastTry = false;
        File parentFile = f.getParentFile();
        int i = 0;
        while (i < maxSearchDepth) {
            if (parentFile != null) {
                parentName = parentFile.getName();
                parentFile = parentFile.getParentFile();
            } else {
                parentName = "";
                lastTry = true;
            }
            String versionPath = String.valueOf(parentName) + "/admin/mmversion.dat";
            File versionFile = importer.importFile(versionPath);
            if (versionFile != null && versionFile.exists()) {
                this.readMMVersionDat(versionFile);
                break;
            }
            if (lastTry.booleanValue()) break;
            ++i;
        }
    }

    private void readMMVersionDat(File f) throws IOException {
        if (this.mmPackageVersions == null) {
            this.mmPackageVersions = new HashMap<String, String>();
        } else {
            this.mmPackageVersions.clear();
        }
        Scanner sc = new Scanner(f);
        System.out.println("Reading metamodel version supported in model,  from file: " + f.getAbsolutePath());
        while (sc.hasNextLine()) {
            String pkgName = sc.nextLine();
            String version = "";
            if (sc.hasNextLine()) {
                version = sc.nextLine();
            }
            if (version.matches("^\\d+(\\.\\d+){2}$")) {
                this.mmPackageVersions.put(pkgName, version);
            }
            System.out.println(String.valueOf(pkgName) + ": version " + version);
        }
        sc.close();
    }
}

