/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.util;

import org.eclipse.hawk.core.IConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JConsole
implements IConsole {
    private static final String FQCN = SLF4JConsole.class.getName();

    @Override
    public void println(String s) {
        Logger logger = SLF4JConsole.getCallerLogger();
        if (logger instanceof LocationAwareLogger) {
            ((LocationAwareLogger)logger).log(null, FQCN, 20, s, null, null);
        } else {
            logger.info(s);
        }
    }

    @Override
    public void printerrln(String s) {
        Logger logger = SLF4JConsole.getCallerLogger();
        if (logger instanceof LocationAwareLogger) {
            ((LocationAwareLogger)logger).log(null, FQCN, 40, s, null, null);
        } else {
            logger.error(s);
        }
    }

    @Override
    public void print(String s) {
        this.println(s);
    }

    private static String getCallerClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        int i = 1;
        while (i < stElements.length) {
            StackTraceElement ste = stElements[i];
            if (!ste.getClassName().equals(SLF4JConsole.class.getName()) && ste.getClassName().indexOf("java.lang.Thread") != 0) {
                return ste.getClassName();
            }
            ++i;
        }
        return null;
    }

    private static Logger getCallerLogger() {
        return LoggerFactory.getLogger((String)SLF4JConsole.getCallerClassName());
    }

    @Override
    public void printerrln(Throwable t) {
        Logger logger = SLF4JConsole.getCallerLogger();
        if (logger instanceof LocationAwareLogger) {
            ((LocationAwareLogger)logger).log(null, FQCN, 40, t.getMessage(), null, t);
        } else {
            logger.error(t.getMessage(), t);
        }
    }
}

