/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.graph.timeaware;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionRangeFilterIGraphEdgeIterable
implements Iterable<IGraphEdge> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionRangeFilterIGraphEdgeIterable.class);
    private final List<ITimeAwareGraphNode> versions;
    private final Function<IGraphNode, Iterable<IGraphEdge>> node2edges;
    private Function<IGraphEdge, Object> edge2id;

    public VersionRangeFilterIGraphEdgeIterable(List<ITimeAwareGraphNode> versions, Function<IGraphNode, Iterable<IGraphEdge>> node2edges, Function<IGraphEdge, Object> edge2id) {
        this.node2edges = node2edges;
        this.versions = versions;
        this.edge2id = edge2id;
    }

    @Override
    public Iterator<IGraphEdge> iterator() {
        try {
            final Iterator<ITimeAwareGraphNode> itVersion = this.versions.iterator();
            final HashSet seenEndIDs = new HashSet();
            return new Iterator<IGraphEdge>(){
                Iterator<IGraphEdge> itEdge = null;
                IGraphEdge next = null;

                @Override
                public boolean hasNext() {
                    while (this.next == null && (this.itEdge != null && this.itEdge.hasNext() || itVersion.hasNext())) {
                        if (this.itEdge == null) {
                            ITimeAwareGraphNode version = (ITimeAwareGraphNode)itVersion.next();
                            Iterable edges = (Iterable)VersionRangeFilterIGraphEdgeIterable.this.node2edges.apply(version);
                            this.itEdge = edges.iterator();
                        }
                        if (this.itEdge.hasNext()) {
                            IGraphEdge candidateEdge = this.itEdge.next();
                            if (!seenEndIDs.add(VersionRangeFilterIGraphEdgeIterable.this.edge2id.apply(candidateEdge))) continue;
                            this.next = candidateEdge;
                            continue;
                        }
                        this.itEdge = null;
                    }
                    return this.next != null;
                }

                @Override
                public IGraphEdge next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    IGraphEdge ret = this.next;
                    this.next = null;
                    return ret;
                }
            };
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyIterator();
        }
    }
}

