/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.editor;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.etrice.ui.common.base.UIBaseActivator;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class CustomPersistencyBehavior
extends DefaultPersistencyBehavior {
    @Deprecated
    @Inject
    private IResourceValidator resourceValidator;

    public CustomPersistencyBehavior(DiagramBehavior diagramBehavior) {
        super(diagramBehavior);
    }

    protected Map<Resource, Map<?, ?>> createSaveOptions() {
        SaveOptions xtextSaveOptions = SaveOptions.newBuilder().format().getOptions();
        Map saveOptions = super.createSaveOptions();
        for (Resource res : saveOptions.keySet()) {
            if (!(res instanceof XtextResource)) continue;
            Map optionMap = (Map)saveOptions.get(res);
            xtextSaveOptions.addTo(optionMap);
        }
        return saveOptions;
    }

    public void saveDiagram(IProgressMonitor monitor) {
        boolean valid = this.validateResourcesBeforeSave(monitor);
        if (valid) {
            super.saveDiagram(monitor);
        }
    }

    protected boolean shouldSave(Resource resource) {
        return resource.isTrackingModification() && super.shouldSave(resource);
    }

    protected boolean validateResourcesBeforeSave(final IProgressMonitor monitor) {
        RunnableWithResult.Impl<Boolean> runnable = new RunnableWithResult.Impl<Boolean>(){

            public void run() {
                this.setResult(false);
                boolean result = true;
                ArrayList resources = Lists.newArrayList((Iterable)CustomPersistencyBehavior.this.diagramBehavior.getEditingDomain().getResourceSet().getResources());
                for (Resource res : resources) {
                    result &= !CustomPersistencyBehavior.this.shouldSave(res) || CustomPersistencyBehavior.this.validateResource(res, monitor);
                }
                this.setResult(result);
            }
        };
        try {
            return (Boolean)TransactionUtil.runExclusive((TransactionalEditingDomain)this.diagramBehavior.getEditingDomain(), (RunnableWithResult)runnable);
        }
        catch (InterruptedException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)("Internal error: could not save model:\n\n" + e.getMessage()));
            UIBaseActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.etrice.ui.common.base", e.getMessage(), (Throwable)e));
            return false;
        }
    }

    protected boolean validateResource(Resource res, IProgressMonitor monitor) {
        IStatus resultStatus = null;
        resultStatus = res instanceof XtextResource ? this.validateSyntax((XtextResource)res) : Status.OK_STATUS;
        if (!resultStatus.isOK()) {
            ErrorDialog dialog = new ErrorDialog(this.diagramBehavior.getDiagramContainer().getSite().getShell(), "Save", "Cannot save diagram.", resultStatus, 7){

                public void create() {
                    super.create();
                    this.showDetailsArea();
                }
            };
            dialog.open();
        }
        return resultStatus.isOK();
    }

    protected IStatus validateSyntax(XtextResource resource) {
        MultiStatus status = new MultiStatus("org.eclipse.etrice.ui.common.base", 0, "Could not create textual representation of " + resource.getURI().lastSegment() + ".", null);
        for (Diagnostic diag : resource.validateConcreteSyntax()) {
            status.add((IStatus)new Status(4, "org.eclipse.etrice.ui.common.base", diag.toString()));
        }
        try {
            if (status.isOK()) {
                resource.getSerializer().serialize((EObject)resource.getContents().get(0));
            }
        }
        catch (RuntimeException e) {
            status.add((IStatus)new Status(4, "org.eclipse.etrice.ui.common.base", e.getMessage()));
        }
        return status;
    }

    @Deprecated
    private boolean validateResourceFully(Resource res, final IProgressMonitor monitor) {
        if (res instanceof XtextResource) {
            if (!res.isLoaded()) {
                try {
                    res.load(Collections.EMPTY_MAP);
                }
                catch (IOException iOException) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)("Internal error: couldn't load referenced resource " + String.valueOf(res.getURI())));
                    return false;
                }
            }
            if (res.isModified()) {
                XtextResource xres = (XtextResource)res;
                ISerializer serializer = xres.getSerializer();
                if (xres.getContents().isEmpty()) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)"Internal error: part of textual model is empty, can't save");
                    return false;
                }
                try {
                    serializer.serialize((EObject)xres.getContents().get(0));
                    List result = this.resourceValidator.validate(res, CheckMode.NORMAL_AND_FAST, new CancelIndicator(){

                        public boolean isCanceled() {
                            if (monitor == null) {
                                return false;
                            }
                            return monitor.isCanceled();
                        }
                    });
                    if (!result.isEmpty()) {
                        boolean error = false;
                        MultiStatus ms = new MultiStatus("org.eclipse.etrice.ui.common.base", 4, "validation errors during diagram save", null);
                        for (Issue issue : result) {
                            if (!issue.isSyntaxError() && issue.getSeverity() != Severity.ERROR) continue;
                            ms.add((IStatus)new Status(4, "org.eclipse.etrice.ui.common.base", issue.getMessage()));
                            error = true;
                        }
                        if (error) {
                            StringBuilder messges = new StringBuilder();
                            IStatus[] iStatusArray = ms.getChildren();
                            int n = iStatusArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IStatus status = iStatusArray[n2];
                                messges.append(status.getMessage() + "\n");
                                ++n2;
                            }
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)("Internal error: model is invalid, can't save:\n\n" + String.valueOf(messges)));
                            UIBaseActivator.getDefault().getLog().log((IStatus)ms);
                            return false;
                        }
                    }
                }
                catch (RuntimeException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)("Internal error: model is invalid, can't save:\n\n" + e.getMessage()));
                    UIBaseActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.etrice.ui.common.base", e.getMessage(), (Throwable)e));
                    return false;
                }
            }
        }
        return true;
    }
}

