/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.generic;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.EntryPoint;
import org.eclipse.etrice.core.fsm.fSM.ExitPoint;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.fsm.base.CodegenHelpers;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.fsm.generic.ITransitionChainVisitor;
import org.eclipse.etrice.generator.fsm.generic.TransitionChainVisitor;

public class TransitionChainGenerator {
    @Inject
    private ILanguageExtensionBase languageExt;
    @Inject
    private CodegenHelpers codegenHelpers;
    @Inject
    private IDetailCodeTranslator translator;
    @Inject
    private FSMNameProvider fsmNameProvider;
    @Inject
    private FSMHelpers fsmHelpers;

    public String generateExecuteChain(GraphContainer gc, Link l) {
        TransitionChainVisitor tcv = new TransitionChainVisitor(gc, this.languageExt, this.codegenHelpers, this.translator);
        tcv.init(l.getTransition());
        return this.genExecuteChain(l, tcv);
    }

    public String generateArgumentList(GraphContainer gc, Link l) {
        if (l.getTransition() instanceof InitialTransition) {
            return "";
        }
        if (!l.isIfitemTriggered()) {
            return "";
        }
        return this.languageExt.generateArglistAndTypedData(l.getCommonData())[ILanguageExtensionBase.TypedDataKind.COMMA_SEPARATED_PARAM_IN_DECLARATION.ordinal()];
    }

    public String genExecuteChain(Link l, ITransitionChainVisitor tcv) {
        StringBuilder result = new StringBuilder();
        result.append(tcv.genTypedData(l.getTransition()));
        this.genChainCode(l, tcv, result);
        return result.toString();
    }

    private void genChainCode(Link l, ITransitionChainVisitor tcv, StringBuilder result) {
        result.append(tcv.genActionOperationCall(l.getTransition()));
        Node target = l.getTarget();
        StateGraphNode stateGraphNode = target.getStateGraphNode();
        ArrayList outgoing = new ArrayList(target.getOutgoing());
        final CodegenHelpers cgh = new CodegenHelpers();
        Collections.sort(outgoing, new Comparator<Link>(){

            @Override
            public int compare(Link o1, Link o2) {
                String id1 = cgh.getGenChainId(o1.getTransition());
                String id2 = cgh.getGenChainId(o2.getTransition());
                return id1.compareTo(id2);
            }
        });
        if (stateGraphNode instanceof ChoicePoint) {
            Link dflt = FsmGenExtensions.getChoicepointDefaultBranch((Node)target);
            assert (dflt != null) : "ChoicePoint " + this.fsmNameProvider.getFullPath((StateGraphItem)stateGraphNode) + " has no default branch!";
            boolean isFirst = true;
            for (Link cond : outgoing) {
                if (cond == dflt) continue;
                assert (cond.getTransition() instanceof CPBranchTransition) : "The non default ChoicePoint branch " + this.fsmNameProvider.getFullPath((StateGraphItem)cond.getTransition()) + " must be of type CPBranchTransition!";
                result.append(tcv.genElseIfBranch((CPBranchTransition)cond.getTransition(), isFirst));
                isFirst = false;
                this.genChainCode(cond, tcv, result);
            }
            result.append(tcv.genElseBranch((ContinuationTransition)dflt.getTransition()));
            this.genChainCode(dflt, tcv, result);
            result.append(tcv.genEndIf());
        } else if (stateGraphNode instanceof TrPoint) {
            if (stateGraphNode instanceof TransitionPoint) {
                result.append(tcv.genReturnState(this.fsmHelpers.getParentState(stateGraphNode), false));
                return;
            }
            assert (outgoing.size() <= 1) : "TrPoint " + this.fsmNameProvider.getFullPath((StateGraphItem)stateGraphNode) + " is expected to have at most one outgoing transition!";
            if (outgoing.size() == 1) {
                State state = this.fsmHelpers.getParentState(stateGraphNode);
                if (stateGraphNode instanceof EntryPoint) {
                    if (state != null && !target.isInherited() && this.fsmHelpers.hasEntryCode(state, true)) {
                        result.append(tcv.genEntryOperationCall(state));
                    }
                } else if (stateGraphNode instanceof ExitPoint) {
                    if (state != null && !target.isInherited() && this.fsmHelpers.hasExitCode(state, true)) {
                        result.append(tcv.genExitOperationCall(state));
                    }
                } else assert (false) : "unexpected sub type";
            }
            if (!outgoing.isEmpty()) {
                this.genChainCode((Link)outgoing.get(0), tcv, result);
            }
        } else {
            assert (stateGraphNode instanceof State) : "A transition target can be a ChoicePoint, a TrPoint or a State!";
            result.append(tcv.genReturnState((State)stateGraphNode, true));
        }
    }
}

