/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.EnumCodeGenerator;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.types.StateLessObjectTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.metamodel.chi.EnumDeclaration;
import org.eclipse.escet.chi.metamodel.chi.EnumValue;
import org.eclipse.escet.chi.metamodel.chi.EnumValueReference;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EnumTypeID
extends StateLessObjectTypeID {
    private final EnumDeclaration decl;
    private final String enumName;

    public EnumTypeID(EnumDeclaration decl, CodeGeneratorContext ctxt) {
        super(false, TypeID.TypeKind.ENUM);
        this.decl = decl;
        if (!ctxt.hasTypeName(this)) {
            EnumCodeGenerator.transEnumDeclaration(this, decl, ctxt);
        }
        this.enumName = ctxt.getTypeName(this);
    }

    @Override
    public String getTypeText() {
        return this.decl.getName();
    }

    @Override
    public String getJavaClassType() {
        return this.enumName;
    }

    @Override
    public String getReadName(String stream, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        return Strings.fmt((String)"%s.read(chiCoordinator, %s)", (Object[])new Object[]{this.getJavaClassType(), stream});
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        String classPath = this.getJavaClassType();
        String val = "EV_" + ((EnumValue)this.decl.getValues().get(0)).getName();
        return classPath + "." + val;
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        if (expr instanceof EnumValueReference) {
            EnumValueReference eval = (EnumValueReference)expr;
            String txt = this.getJavaClassType() + ".EV_" + eval.getValue().getName();
            return new SimpleExpression(txt, (PositionObject)expr);
        }
        Assert.fail((Object)("Unknown expression node for enumeration type: " + expr.toString()));
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EnumTypeID)) {
            return false;
        }
        return this.decl.equals(((EnumTypeID)obj).decl);
    }

    @Override
    public int hashCode() {
        return this.decl.hashCode();
    }
}

