/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.ExprStructuralEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Maps;

public class UniqueStateInvariantsPostChecker {
    private final Map<ExprStructuralEqHashWrap, Invariant> stateInvariants = Maps.map();

    public void check(ComplexComponent comp, CifPostCheckEnv env) {
        block3: {
            block2: {
                this.check((List<Invariant>)comp.getInvariants(), this.stateInvariants, env);
                if (!(comp instanceof Group)) break block2;
                Group group = (Group)comp;
                for (Component child : group.getComponents()) {
                    this.check((ComplexComponent)child, env);
                }
                break block3;
            }
            if (!(comp instanceof Automaton)) break block3;
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                if (loc.getInvariants().isEmpty()) continue;
                this.check((List<Invariant>)loc.getInvariants(), Maps.map(), env);
            }
        }
    }

    private void check(List<Invariant> invariants, Map<ExprStructuralEqHashWrap, Invariant> previousEncounteredInvariants, CifPostCheckEnv env) {
        block5: for (Invariant invariant : invariants) {
            switch (invariant.getInvKind()) {
                case EVENT_DISABLES: {
                    continue block5;
                }
                case EVENT_NEEDS: {
                    continue block5;
                }
                case STATE: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown invariant kind: " + String.valueOf(invariant.getInvKind()));
                }
            }
            ExprStructuralEqHashWrap wrappedExpr = new ExprStructuralEqHashWrap(invariant.getPredicate());
            Invariant duplicate = previousEncounteredInvariants.get(wrappedExpr);
            if (duplicate != null) {
                env.addProblem(ErrMsg.INV_DUPL_STATE, invariant.getPosition(), new String[0]);
                env.addProblem(ErrMsg.INV_DUPL_STATE, duplicate.getPosition(), new String[0]);
                continue;
            }
            previousEncounteredInvariants.put(wrappedExpr, invariant);
        }
    }
}

