/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.transitions;

import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeExecutionModeInfo;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.ode.Trajectories;
import org.eclipse.escet.cif.simulator.runtime.transitions.ActualTargetTime;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;

public class TimeTransition<S extends RuntimeState>
extends Transition<S> {
    public final RuntimeSpec<S> spec;
    private final Trajectories trajectories;
    public RuntimeExecutionModeInfo executionModeInfo;

    public TimeTransition(RuntimeSpec<S> spec, S source, Trajectories trajectories) {
        super(source);
        this.spec = spec;
        this.trajectories = trajectories;
    }

    public double getLastTime() {
        double endTime = this.trajectories.getLastTime();
        Assert.check((endTime != -1.0 ? 1 : 0) != 0);
        return endTime;
    }

    @Override
    public S getTargetState(Double targetTime, Boolean strict) {
        Pair<Double, double[]> rslt = this.trajectories.getValuesForTime(targetTime, strict, this.spec.maxTimePointTol);
        if (rslt == null) {
            return null;
        }
        targetTime = (Double)rslt.left;
        double[] values = (double[])rslt.right;
        RuntimeState target = this.spec.getOdeSolver().makeState(this.source, targetTime, values, true);
        if (this.spec.executionMode) {
            Assert.notNull((Object)this.executionModeInfo);
            target.executionModeInfo = this.executionModeInfo;
        }
        return (S)target;
    }

    public S getTargetStateForIndex(int idx) {
        double time = this.trajectories.getTimes().get(idx);
        double[] values = this.trajectories.getValuesForIndex(idx);
        RuntimeState target = this.spec.getOdeSolver().makeState(this.source, time, values, true);
        if (this.spec.executionMode) {
            Assert.notNull((Object)this.executionModeInfo);
            target.executionModeInfo = this.executionModeInfo;
        }
        return (S)target;
    }

    public Trajectories getTrajectories() {
        return this.trajectories;
    }

    public ActualTargetTime takeTimeTransition(ChosenTargetTime chosenTargetTime) {
        return this.spec.takeTimeTransition(this, chosenTargetTime);
    }

    @Override
    public String toString() {
        double maxDelay = this.trajectories.getMaxDelay();
        return Strings.fmt((String)"delay for (0 .. %s]", (Object[])new Object[]{CifSimulatorMath.realToStr(maxDelay)});
    }
}

