/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.BreakFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ContinueFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.WhileFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FuncNoSpecificIntUserDefFuncStatsCheck
extends CifCheck {
    private final EnumSet<NoSpecificStatement> disAlloweds;

    public FuncNoSpecificIntUserDefFuncStatsCheck(EnumSet<NoSpecificStatement> disAlloweds) {
        this.disAlloweds = disAlloweds;
    }

    public FuncNoSpecificIntUserDefFuncStatsCheck(NoSpecificStatement ... disAlloweds) {
        this(Arrays.stream(disAlloweds).collect(Collectors.toCollection(() -> EnumSet.noneOf(NoSpecificStatement.class))));
    }

    protected void preprocessAssignmentFuncStatement(AssignmentFuncStatement asgStat, CifCheckViolations violations) {
        CifType valueType;
        CifType addrType;
        if (this.disAlloweds.contains((Object)NoSpecificStatement.ASSIGN_MULTI_PARTS_SAME_VAR)) {
            Expression addr = asgStat.getAddressable();
            try {
                CifAddressableUtils.getRefs((Expression)addr);
            }
            catch (CifAddressableUtils.DuplVarAsgnException ex) {
                violations.add((PositionObject)asgStat, "Internal user-defined function has a multi-assignment that assigns multiple (non-overlapping) parts of a single variable", new Object[0]);
            }
        }
        if (this.disAlloweds.contains((Object)NoSpecificStatement.ASSIGN_OUT_OF_RANGE) && !CifTypeUtils.checkTypeCompat((CifType)(addrType = asgStat.getAddressable().getType()), (CifType)(valueType = asgStat.getValue().getType()), (RangeCompat)RangeCompat.CONTAINED)) {
            violations.add((PositionObject)asgStat, "Assignment in a function may fail with an out-of-range error, as the value of the computed expression does not always fit in the assigned variable", new Object[0]);
        }
    }

    protected void preprocessBreakFuncStatement(BreakFuncStatement breakStat, CifCheckViolations violations) {
        if (this.disAlloweds.contains((Object)NoSpecificStatement.BREAK)) {
            violations.add((PositionObject)breakStat, "Internal user-defined function has a 'break' statement", new Object[0]);
        }
    }

    protected void preprocessContinueFuncStatement(ContinueFuncStatement continueStat, CifCheckViolations violations) {
        if (this.disAlloweds.contains((Object)NoSpecificStatement.CONTINUE)) {
            violations.add((PositionObject)continueStat, "Internal user-defined function has a 'continue' statement", new Object[0]);
        }
    }

    protected void preprocessWhileFuncStatement(WhileFuncStatement whileStat, CifCheckViolations violations) {
        if (this.disAlloweds.contains((Object)NoSpecificStatement.WHILE)) {
            violations.add((PositionObject)whileStat, "Internal user-defined function has a 'while' statement", new Object[0]);
        }
    }

    public static enum NoSpecificStatement {
        ASSIGN_MULTI_PARTS_SAME_VAR,
        ASSIGN_OUT_OF_RANGE,
        BREAK,
        CONTINUE,
        WHILE;

    }
}

