/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ThreadUtil;
import org.apache.commons.exec.launcher.CommandLauncher;
import org.apache.commons.exec.launcher.CommandLauncherFactory;

public class DefaultExecutor
implements Executor {
    private ExecuteStreamHandler executeStreamHandler;
    private File workingDirectory;
    private ExecuteWatchdog watchdog;
    private int[] exitValues;
    private final CommandLauncher launcher;
    private ProcessDestroyer processDestroyer;
    private Thread executorThread;
    private IOException exceptionCaught;
    private final ThreadFactory threadFactory;

    public static Builder<?> builder() {
        return new Builder();
    }

    @Deprecated
    public DefaultExecutor() {
        this(Executors.defaultThreadFactory(), new PumpStreamHandler(), new File("."));
    }

    DefaultExecutor(ThreadFactory threadFactory, ExecuteStreamHandler executeStreamHandler, File workingDirectory) {
        this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
        this.executeStreamHandler = executeStreamHandler != null ? executeStreamHandler : new PumpStreamHandler();
        this.workingDirectory = workingDirectory != null ? workingDirectory : new File(".");
        this.launcher = CommandLauncherFactory.createVMLauncher();
        this.exitValues = new int[0];
    }

    private void checkWorkingDirectory() throws IOException {
        this.checkWorkingDirectory(this.workingDirectory);
    }

    private void checkWorkingDirectory(File directory) throws IOException {
        if (directory != null && !directory.exists()) {
            throw new IOException(directory + " doesn't exist.");
        }
    }

    private void closeCatch(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            this.setExceptionCaught(e);
        }
    }

    private void closeProcessStreams(Process process) {
        this.closeCatch(process.getInputStream());
        this.closeCatch(process.getOutputStream());
        this.closeCatch(process.getErrorStream());
    }

    protected Thread createThread(Runnable runnable, String name) {
        return ThreadUtil.newThread(this.threadFactory, runnable, name, false);
    }

    @Override
    public int execute(CommandLine command) throws ExecuteException, IOException {
        return this.execute(command, (Map<String, String>)null);
    }

    @Override
    public void execute(CommandLine command, ExecuteResultHandler handler) throws ExecuteException, IOException {
        this.execute(command, null, handler);
    }

    @Override
    public int execute(CommandLine command, Map<String, String> environment) throws ExecuteException, IOException {
        this.checkWorkingDirectory();
        return this.executeInternal(command, environment, this.workingDirectory, this.executeStreamHandler);
    }

    @Override
    public void execute(CommandLine command, Map<String, String> environment, ExecuteResultHandler handler) throws ExecuteException, IOException {
        this.checkWorkingDirectory();
        if (this.watchdog != null) {
            this.watchdog.setProcessNotStarted();
        }
        this.executorThread = this.createThread(() -> {
            int exitValue = -559038737;
            try {
                exitValue = this.executeInternal(command, environment, this.workingDirectory, this.executeStreamHandler);
                handler.onProcessComplete(exitValue);
            }
            catch (ExecuteException e) {
                handler.onProcessFailed(e);
            }
            catch (Exception e) {
                handler.onProcessFailed(new ExecuteException("Execution failed", exitValue, e));
            }
        }, "CommonsExecDefaultExecutor");
        this.getExecutorThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInternal(CommandLine command, Map<String, String> environment, File workingDirectory, ExecuteStreamHandler streams) throws IOException {
        Process process;
        this.exceptionCaught = null;
        try {
            process = this.launch(command, environment, workingDirectory);
        }
        catch (IOException e) {
            if (this.watchdog != null) {
                this.watchdog.failedToStart(e);
            }
            throw e;
        }
        try {
            this.setStreams(streams, process);
        }
        catch (IOException e) {
            process.destroy();
            if (this.watchdog != null) {
                this.watchdog.failedToStart(e);
            }
            throw e;
        }
        streams.start();
        try {
            if (this.getProcessDestroyer() != null) {
                this.getProcessDestroyer().add(process);
            }
            if (this.watchdog != null) {
                this.watchdog.start(process);
            }
            int exitValue = -559038737;
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                process.destroy();
            }
            finally {
                Thread.interrupted();
            }
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            try {
                streams.stop();
            }
            catch (IOException e) {
                this.setExceptionCaught(e);
            }
            this.closeProcessStreams(process);
            if (this.getExceptionCaught() != null) {
                throw this.getExceptionCaught();
            }
            if (this.watchdog != null) {
                try {
                    this.watchdog.checkException();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            if (this.isFailure(exitValue)) {
                throw new ExecuteException("Process exited with an error: " + exitValue, exitValue);
            }
            int n = exitValue;
            return n;
        }
        finally {
            if (this.getProcessDestroyer() != null) {
                this.getProcessDestroyer().remove(process);
            }
        }
    }

    private IOException getExceptionCaught() {
        return this.exceptionCaught;
    }

    protected Thread getExecutorThread() {
        return this.executorThread;
    }

    @Override
    public ProcessDestroyer getProcessDestroyer() {
        return this.processDestroyer;
    }

    @Override
    public ExecuteStreamHandler getStreamHandler() {
        return this.executeStreamHandler;
    }

    ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public ExecuteWatchdog getWatchdog() {
        return this.watchdog;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public boolean isFailure(int exitValue) {
        if (this.exitValues == null) {
            return false;
        }
        if (this.exitValues.length == 0) {
            return this.launcher.isFailure(exitValue);
        }
        for (int exitValue2 : this.exitValues) {
            if (exitValue2 != exitValue) continue;
            return false;
        }
        return true;
    }

    protected Process launch(CommandLine command, Map<String, String> env, File workingDirectory) throws IOException {
        if (this.launcher == null) {
            throw new IllegalStateException("CommandLauncher can not be null");
        }
        this.checkWorkingDirectory(workingDirectory);
        return this.launcher.exec(command, env, workingDirectory);
    }

    private void setExceptionCaught(IOException e) {
        if (this.exceptionCaught == null) {
            this.exceptionCaught = e;
        }
    }

    @Override
    public void setExitValue(int value) {
        this.setExitValues(new int[]{value});
    }

    @Override
    public void setExitValues(int[] values) {
        this.exitValues = values == null ? null : (int[])values.clone();
    }

    @Override
    public void setProcessDestroyer(ProcessDestroyer processDestroyer) {
        this.processDestroyer = processDestroyer;
    }

    @Override
    public void setStreamHandler(ExecuteStreamHandler streamHandler) {
        this.executeStreamHandler = streamHandler;
    }

    private void setStreams(ExecuteStreamHandler streams, Process process) throws IOException {
        streams.setProcessInputStream(process.getOutputStream());
        streams.setProcessOutputStream(process.getInputStream());
        streams.setProcessErrorStream(process.getErrorStream());
    }

    @Override
    public void setWatchdog(ExecuteWatchdog watchdog) {
        this.watchdog = watchdog;
    }

    @Override
    @Deprecated
    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public static class Builder<T extends Builder<T>>
    implements Supplier<DefaultExecutor> {
        private ThreadFactory threadFactory;
        private ExecuteStreamHandler executeStreamHandler;
        private File workingDirectory;

        T asThis() {
            return (T)this;
        }

        @Override
        public DefaultExecutor get() {
            return new DefaultExecutor(this.threadFactory, this.executeStreamHandler, this.workingDirectory);
        }

        ExecuteStreamHandler getExecuteStreamHandler() {
            return this.executeStreamHandler;
        }

        ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        File getWorkingDirectory() {
            return this.workingDirectory;
        }

        public T setExecuteStreamHandler(ExecuteStreamHandler executeStreamHandler) {
            this.executeStreamHandler = executeStreamHandler;
            return this.asThis();
        }

        public T setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this.asThis();
        }

        public T setWorkingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this.asThis();
        }
    }
}

