/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EnumCodeGenerator {
    private EnumCodeGenerator() {
    }

    public static void gencodeEnums(CifCompilerContext ctxt) {
        List names;
        Map<EnumDecl, EnumDecl> reprsMap = ctxt.getEnumDeclReprs();
        Map namesMap = Maps.map();
        for (Map.Entry<EnumDecl, EnumDecl> entry : reprsMap.entrySet()) {
            EnumDecl equalEnum = entry.getKey();
            EnumDecl repr = entry.getValue();
            names = (List)namesMap.get(repr);
            if (names == null) {
                names = Lists.list();
                namesMap.put(repr, names);
            }
            names.add(CifTextUtils.getAbsName((PositionObject)equalEnum));
        }
        for (Map.Entry<Object, Object> entry : namesMap.entrySet()) {
            EnumDecl enumDecl = (EnumDecl)entry.getKey();
            EList lits = enumDecl.getLiterals();
            names = (List)entry.getValue();
            String className = ctxt.getEnumClassName(enumDecl);
            JavaCodeFile file = ctxt.addCodeFile(className);
            CodeBox h = file.header;
            String absName = CifTextUtils.getAbsName((PositionObject)enumDecl);
            h.add("/** Enumeration representative \"%s\", for enumerations:", new Object[]{absName});
            h.add(" * <ul>");
            for (String name : names) {
                h.add(" *  <li>%s</li>", new Object[]{name});
            }
            h.add(" * </ul>");
            h.add(" */");
            h.add("public enum %s implements RuntimeToStringable {", new Object[]{className});
            CodeBox c = file.body;
            int i = 0;
            while (i < lits.size() - 1) {
                EnumLiteral lit = (EnumLiteral)lits.get(i);
                c.add("%s(\"%s\"),", new Object[]{ctxt.getEnumConstName(lit), lit.getName()});
                ++i;
            }
            c.add("%s(\"%s\");", new Object[]{ctxt.getEnumConstName((EnumLiteral)Lists.last((List)lits)), ((EnumLiteral)Lists.last((List)lits)).getName()});
            c.add();
            c.add("public static String getEnumCifName() {");
            c.indent();
            c.add("return %s;", new Object[]{Strings.stringToJava((String)absName)});
            c.dedent();
            c.add("}");
            c.add();
            c.add("private final String cifLiteralName;");
            c.add();
            c.add("%s(String cifLiteralName) {", new Object[]{className});
            c.indent();
            c.add("this.cifLiteralName = cifLiteralName;");
            c.dedent();
            c.add("}");
            c.add();
            c.add("@Override");
            c.add("public String toString() {");
            c.indent();
            c.add("return cifLiteralName;");
            c.dedent();
            c.add("}");
        }
    }
}

