/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.exception;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class MatlabException
extends Exception {
    private static final long serialVersionUID = -2998670342449368598L;
    private static final String MATLAB_ENGINE_EXCEPTION_CLASS = "com.mathworks.engine.EngineException";
    private static final String MATLAB_EXECUTION_EXCEPTION_CLASS = "com.mathworks.engine.MatlabExecutionException";
    private static final String MATLAB_SYNTAX_EXCEPTION_CLASS = "com.mathworks.engine.MatlabSyntaxException";
    private static final String MATLAB_UNSUPORTED_TYPE_EXCEPTION_CLASS = "com.mathworks.engine.UnsupportedTypeException";
    private static final String MATLAB_RUNTIME_EXCEPTION_CLASS = "com.mathworks.mvm.exec.MvmRuntimeException";
    protected static Class<?> engineClass;
    protected static Class<?> executionClass;
    protected static Class<?> syntaxClass;
    protected static Class<?> typeClass;
    protected static Class<?> runtimeClass;
    protected Boolean isEngine;
    protected Boolean isExecution;
    protected Boolean isSyntax;
    protected Boolean isType;
    protected Boolean isRuntime;
    private static final String TOO_MANY_OUTPUT = "Too many output arguments";

    public MatlabException(InvocationTargetException e) {
        super(e.getTargetException());
        this.isEngine = MatlabException.isEngineException(e.getTargetException());
        this.isExecution = MatlabException.isExecutionException(e.getTargetException());
        this.isSyntax = MatlabException.isSyntaxException(e.getTargetException());
        this.isType = MatlabException.isUnsupportedTypeException(e.getTargetException());
        this.isRuntime = MatlabException.isRuntimeException(e.getTargetException());
    }

    public boolean isTooManyOutput() {
        return this.getMessage().contains(TOO_MANY_OUTPUT) || this.getCause() != null ? this.getCause().getMessage().contains(TOO_MANY_OUTPUT) : false;
    }

    private static Class<?> load(String className) throws ClassNotFoundException {
        return ClassLoader.getSystemClassLoader().loadClass(className);
    }

    public static Boolean isEngineException(Throwable e) {
        return MATLAB_ENGINE_EXCEPTION_CLASS.equals(e.getClass().getName());
    }

    public static Boolean isExecutionException(Throwable e) {
        return MATLAB_EXECUTION_EXCEPTION_CLASS.equals(e.getClass().getName());
    }

    public static Boolean isSyntaxException(Throwable e) {
        return MATLAB_SYNTAX_EXCEPTION_CLASS.equals(e.getClass().getName());
    }

    public static Boolean isUnsupportedTypeException(Throwable e) {
        return MATLAB_UNSUPORTED_TYPE_EXCEPTION_CLASS.equals(e.getClass().getName());
    }

    public static Boolean isRuntimeException(Throwable e) {
        return MATLAB_RUNTIME_EXCEPTION_CLASS.equals(e.getClass().getName());
    }

    public Boolean isEngineException() {
        return this.isEngine;
    }

    public Boolean isExecutionException() {
        return this.isExecution;
    }

    public Boolean isSyntaxException() {
        return this.isSyntax;
    }

    public Boolean isUnsupportedTypeException() {
        return this.isType;
    }

    public Boolean isRuntimeException() {
        return this.isRuntime;
    }

    public EolRuntimeException toEolRuntimeException() {
        EolRuntimeException eol = new EolRuntimeException((Throwable)this);
        eol.setReason(this.getMessage());
        eol.setMessage(this.getMessage());
        return eol;
    }

    public EolRuntimeException toEolRuntimeException(ModuleElement ast) {
        EolRuntimeException eol = this.toEolRuntimeException();
        eol.setAst(ast);
        return eol;
    }

    @Override
    public String getMessage() {
        return this.getCause() != null ? (this.getCause().getCause() != null ? this.getCause().getCause().getMessage() : this.getCause().getMessage()) : super.getMessage();
    }
}

