/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.FeatureMapEntryConfig;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntries;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntry;
import org.eclipse.emfcloud.jackson.databind.type.EcoreTypeFactory;
import org.eclipse.emfcloud.jackson.errors.JSONException;

public class FeatureMapEntryDeserializer
extends JsonDeserializer<FeatureMap.Entry> {
    private final FeatureMapEntryConfig config;

    public FeatureMapEntryDeserializer(FeatureMapEntryConfig config) {
        this.config = config;
    }

    public FeatureMap.Entry deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        EObject parent = EMFContext.getParent((DatabindContext)ctxt);
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            return null;
        }
        DeserializedContent content = new DeserializedContent();
        try (TokenBuffer buffer = new TokenBuffer(jp);){
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                this.readNextToken(jp, ctxt, parent, content, buffer);
            }
            if (!buffer.isEmpty() && content.isFeatureSet() && content.getValue() == null) {
                Object value = this.readValue(buffer.asParser(), ctxt, parent, content.getFeature());
                content.setValue(value);
            }
        }
        FeatureMap.Entry result = this.createResult(ctxt, parent, content.getFeature(), content.getValue());
        if (result == null) {
            this.handleUnknownProperty(parent, content.getFeatureName(), jp, EMFContext.getResource((DatabindContext)ctxt), ctxt);
        }
        return result;
    }

    public void readNextToken(JsonParser jp, DeserializationContext ctxt, EObject parent, DeserializedContent content, TokenBuffer buffer) throws IOException {
        String key = jp.getCurrentName();
        jp.nextToken();
        boolean readingValue = false;
        if (this.config.shouldUseKeyAndValueProperties()) {
            if ("featureName".equals(key)) {
                content.setFeature(jp.getValueAsString(), parent);
            } else if ("value".equals(key)) {
                readingValue = true;
            }
        } else {
            content.setFeature(key, parent);
            readingValue = true;
        }
        if (readingValue) {
            if (content.isFeatureSet()) {
                Object value = this.readValue(jp, ctxt, parent, content.getFeature());
                content.setValue(value);
            } else {
                buffer.copyCurrentStructure(jp);
            }
        }
    }

    private void handleUnknownProperty(EObject parent, String featureName, JsonParser jp, Resource resource, DeserializationContext ctxt) throws IOException {
        if (resource != null && ctxt.getConfig().hasDeserializationFeatures(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES.getMask())) {
            resource.getErrors().add((Object)new JSONException(String.format("Unknown feature '%s' for %s", featureName, EcoreUtil.getURI((EObject)parent.eClass())), jp.getCurrentLocation()));
        }
    }

    public Object readValue(JsonParser jp, DeserializationContext ctxt, EObject parent, EStructuralFeature feature) throws IOException {
        Object value;
        EcoreTypeFactory factory = EMFContext.getTypeFactory((DatabindContext)ctxt);
        JavaType type = factory.typeOf((DatabindContext)ctxt, parent.eClass(), feature);
        if (feature.isMany() && type instanceof CollectionType) {
            type = type.getContentType();
        }
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            EMFContext.setFeature((DatabindContext)ctxt, feature);
            value = ctxt.readValue(jp, type);
        } else {
            value = ctxt.readValue(jp, type);
        }
        return value;
    }

    public FeatureMap.Entry createResult(DeserializationContext ctxt, EObject parent, EStructuralFeature feature, Object value) {
        if (feature != null) {
            if (value instanceof ReferenceEntry.ForMapEntry) {
                ReferenceEntries entries = EMFContext.getEntries((DatabindContext)ctxt);
                entries.entries().add((ReferenceEntry)value);
                return ((ReferenceEntry.ForMapEntry)value).createFeatureMapEntry((DatabindContext)ctxt);
            }
            FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)feature, (Object)value);
            return entry;
        }
        return null;
    }

    private class DeserializedContent {
        private String featureName;
        private EStructuralFeature feature;
        private Object value;

        private DeserializedContent() {
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public void setFeature(String featureName, EObject parent) {
            this.featureName = featureName;
            this.feature = this.doGetFeature(parent, featureName);
        }

        public boolean isFeatureSet() {
            return this.feature != null;
        }

        private EStructuralFeature doGetFeature(EObject parent, String featureName) {
            if (featureName != null) {
                Optional<EStructuralFeature> matchingFeature = parent.eClass().getEAllStructuralFeatures().stream().filter(ref -> featureName.equals(FeatureMapEntryDeserializer.this.config.getPropertyName((EStructuralFeature)ref))).findFirst();
                EStructuralFeature feature = matchingFeature.orElseGet(() -> parent.eClass().getEStructuralFeature(featureName));
                return feature;
            }
            return null;
        }
    }
}

