/**
 */
package org.eclipse.emfcloud.jackson.junit.caravan.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.emfcloud.jackson.junit.caravan.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class CaravanFactoryImpl extends EFactoryImpl implements CaravanFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static CaravanFactory init() {
		try {
			CaravanFactory theCaravanFactory = (CaravanFactory)EPackage.Registry.INSTANCE.getEFactory(CaravanPackage.eNS_URI);
			if (theCaravanFactory != null) {
				return theCaravanFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new CaravanFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaravanFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case CaravanPackage.DOCUMENT_ROOT: return createDocumentRoot();
			case CaravanPackage.CARAVAN_TYPE: return createCaravanType();
			case CaravanPackage.PERSON: return createPerson();
			case CaravanPackage.BACTRIAN_CAMEL: return createBactrianCamel();
			case CaravanPackage.DROMADERY_CAMEL: return createDromaderyCamel();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentRoot createDocumentRoot() {
		DocumentRootImpl documentRoot = new DocumentRootImpl();
		return documentRoot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CaravanType createCaravanType() {
		CaravanTypeImpl caravanType = new CaravanTypeImpl();
		return caravanType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Person createPerson() {
		PersonImpl person = new PersonImpl();
		return person;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BactrianCamel createBactrianCamel() {
		BactrianCamelImpl bactrianCamel = new BactrianCamelImpl();
		return bactrianCamel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DromaderyCamel createDromaderyCamel() {
		DromaderyCamelImpl dromaderyCamel = new DromaderyCamelImpl();
		return dromaderyCamel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CaravanPackage getCaravanPackage() {
		return (CaravanPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static CaravanPackage getPackage() {
		return CaravanPackage.eINSTANCE;
	}

} //CaravanFactoryImpl
