/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter;

import java.util.EnumSet;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizLayoutProvider;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizMetaDataProvider;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class DotOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.graphviz.dot";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(10.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final Direction DIRECTION_DEFAULT = Direction.DOWN;
    public static final IProperty<Direction> DIRECTION = new Property(CoreOptions.DIRECTION, (Object)DIRECTION_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 20.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)20.0);
    public static final IProperty<Double> SPACING_EDGE_LABEL = CoreOptions.SPACING_EDGE_LABEL;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<EnumSet<SizeOptions>> NODE_SIZE_OPTIONS = CoreOptions.NODE_SIZE_OPTIONS;
    private static final EdgeRouting EDGE_ROUTING_DEFAULT = EdgeRouting.SPLINES;
    public static final IProperty<EdgeRouting> EDGE_ROUTING = new Property(CoreOptions.EDGE_ROUTING, (Object)EDGE_ROUTING_DEFAULT);
    public static final IProperty<Boolean> DEBUG_MODE = CoreOptions.DEBUG_MODE;
    public static final IProperty<HierarchyHandling> HIERARCHY_HANDLING = CoreOptions.HIERARCHY_HANDLING;
    private static final double ITERATIONS_FACTOR_DEFAULT = 1.0;
    public static final IProperty<Double> ITERATIONS_FACTOR = new Property(GraphvizMetaDataProvider.ITERATIONS_FACTOR, (Object)1.0);
    public static final IProperty<Boolean> CONCENTRATE = GraphvizMetaDataProvider.CONCENTRATE;
    public static final IProperty<Double> LABEL_DISTANCE = GraphvizMetaDataProvider.LABEL_DISTANCE;
    public static final IProperty<Double> LABEL_ANGLE = GraphvizMetaDataProvider.LABEL_ANGLE;
    public static final IProperty<Double> LAYER_SPACING_FACTOR = GraphvizMetaDataProvider.LAYER_SPACING_FACTOR;
    public static final IProperty<Boolean> ADAPT_PORT_POSITIONS = GraphvizMetaDataProvider.ADAPT_PORT_POSITIONS;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("Graphviz Dot").description("Layered drawings of directed graphs. The algorithm aims edges in the same direction (top to bottom, or left to right) and then attempts to avoid edge crossings and reduce edge length. Edges are routed as spline curves and are thus drawn very smoothly. This algorithm is very suitable for state machine and activity diagrams, where the direction of edges has an important role.").providerFactory((IFactory)new DotFactory()).category("org.eclipse.elk.layered").melkBundleName("Graphviz").definingBundleId("org.eclipse.elk.alg.graphviz.layouter").imagePath("images/dot_layout.png").supportedFeatures(EnumSet.of(GraphFeature.SELF_LOOPS, GraphFeature.MULTI_EDGES, GraphFeature.EDGE_LABELS, GraphFeature.COMPOUND, GraphFeature.CLUSTERS)).create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.direction", (Object)DIRECTION_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)20.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.edgeLabel", SPACING_EDGE_LABEL.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.options", NODE_SIZE_OPTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.edgeRouting", (Object)EDGE_ROUTING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.debugMode", DEBUG_MODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.hierarchyHandling", HIERARCHY_HANDLING.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.iterationsFactor", (Object)1.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.concentrate", CONCENTRATE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.labelDistance", LABEL_DISTANCE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.labelAngle", LABEL_ANGLE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.layerSpacingFactor", LAYER_SPACING_FACTOR.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.adaptPortPositions", ADAPT_PORT_POSITIONS.getDefault());
    }

    public static class DotFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            GraphvizLayoutProvider provider = new GraphvizLayoutProvider();
            provider.initialize("DOT");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

