/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sshd.common.io;

import java.io.IOException;

import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.DefaultCancellableSshFuture;

/**
 * A default implementation of an {@link IoConnectFuture}.
 *
 * @author <a href="mailto:dev@mina.apache.org">Apache MINA SSHD Project</a>
 */
public class DefaultIoConnectFuture extends DefaultCancellableSshFuture<IoConnectFuture> implements IoConnectFuture {
    public DefaultIoConnectFuture(Object id, Object lock) {
        super(id, lock);
    }

    @Override
    public IoSession getSession() {
        Object v = getValue();
        return (v instanceof IoSession) ? (IoSession) v : null;
    }

    @Override
    public boolean isConnected() {
        Object v = getValue();
        return v instanceof IoSession;
    }

    @Override
    public void setSession(IoSession session) {
        setValue(session);
    }

    @Override
    public IoConnectFuture verify(long timeoutMillis, CancelOption... options) throws IOException {
        IoSession session = verifyResult(IoSession.class, timeoutMillis, options);
        if (session == null) {
            throw formatExceptionMessage(SshException::new, "No connection established within %d msec.", timeoutMillis);
        }
        return this;
    }
}
