/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lfs.errors.CorruptLongObjectException;
import org.eclipse.jgit.lfs.internal.LfsText;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.Constants;
import org.eclipse.jgit.lfs.lib.LongObjectId;

public class AtomicObjectOutputStream
extends OutputStream {
    private LockFile locked;
    private DigestOutputStream out;
    private boolean aborted;
    private AnyLongObjectId id;

    public AtomicObjectOutputStream(Path path, AnyLongObjectId id) throws IOException {
        this.locked = new LockFile(path.toFile());
        this.locked.lock();
        this.id = id;
        this.out = new DigestOutputStream(this.locked.getOutputStream(), Constants.newMessageDigest());
    }

    public AtomicObjectOutputStream(Path path) throws IOException {
        this(path, null);
    }

    @Nullable
    public AnyLongObjectId getId() {
        return this.id;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (!this.aborted) {
            if (this.id != null) {
                this.verifyHash();
            } else {
                this.id = LongObjectId.fromRaw(this.out.getMessageDigest().digest());
            }
            this.locked.commit();
        }
    }

    private void verifyHash() {
        LongObjectId contentHash = LongObjectId.fromRaw(this.out.getMessageDigest().digest());
        if (!contentHash.equals(this.id)) {
            this.abort();
            throw new CorruptLongObjectException(this.id, contentHash, MessageFormat.format(LfsText.get().corruptLongObject, contentHash, this.id));
        }
    }

    public void abort() {
        this.locked.unlock();
        this.aborted = true;
    }
}

