/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.BranchRebaseModeCombo;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class UpstreamConfigComponent {
    private final Composite container;
    private Button configureUpstreamCheck;
    private BranchRebaseModeCombo rebase;
    private List<UpstreamConfigSelectionListener> listeners = new ArrayList<UpstreamConfigSelectionListener>();
    private Group upstreamConfigGroup;

    public UpstreamConfigComponent(Composite parent, int style) {
        this.container = new Composite(parent, style);
        this.container.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 10).create());
        this.configureUpstreamCheck = new Button(this.container, 32);
        this.configureUpstreamCheck.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.configureUpstreamCheck.setText(UIText.UpstreamConfigComponent_ConfigureUpstreamCheck);
        this.configureUpstreamCheck.setToolTipText(UIText.UpstreamConfigComponent_ConfigureUpstreamToolTip);
        this.configureUpstreamCheck.setSelection(true);
        this.upstreamConfigGroup = new Group(this.container, 16);
        this.upstreamConfigGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(UIUtils.getControlIndent(), 0).create());
        this.upstreamConfigGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.rebase = new BranchRebaseModeCombo((Composite)this.upstreamConfigGroup);
        this.rebase.getViewer().addSelectionChangedListener(event -> this.upstreamConfigSelected());
        this.configureUpstreamCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpstreamConfigComponent.this.updateEnabled();
                UpstreamConfigComponent.this.upstreamConfigSelected();
            }
        });
    }

    public Composite getContainer() {
        return this.container;
    }

    public void addUpstreamConfigSelectionListener(UpstreamConfigSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void setUpstreamConfig(BranchConfig.BranchRebaseMode upstreamConfig) {
        if (upstreamConfig == null) {
            this.configureUpstreamCheck.setSelection(false);
        } else {
            this.configureUpstreamCheck.setSelection(true);
            this.rebase.setRebaseMode(upstreamConfig);
        }
        this.updateEnabled();
    }

    private void upstreamConfigSelected() {
        BranchConfig.BranchRebaseMode config = this.getSelectedRebaseMode();
        for (UpstreamConfigSelectionListener listener : this.listeners) {
            listener.upstreamConfigSelected(config);
        }
    }

    public BranchConfig.BranchRebaseMode getSelectedRebaseMode() {
        if (!this.configureUpstreamCheck.getSelection()) {
            return null;
        }
        return this.rebase.getRebaseMode();
    }

    private void updateEnabled() {
        boolean enabled = this.configureUpstreamCheck.getSelection();
        this.upstreamConfigGroup.setEnabled(enabled);
        this.rebase.setEnabled(enabled);
    }

    public static interface UpstreamConfigSelectionListener {
        public void upstreamConfigSelected(BranchConfig.BranchRebaseMode var1);
    }
}

