/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.net.URISyntaxException;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.internal.KnownHosts;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;

public final class GitUrlChecker {
    private static final String GIT_CLONE_COMMAND_PREFIX = "git clone ";
    private static final String QUOTE = "\"";

    private GitUrlChecker() {
    }

    public static boolean isValidGitUrl(String url) {
        try {
            URIish u;
            if (url != null && GitUrlChecker.canHandleProtocol(u = new URIish(url)) && (RepositorySelectionPage.Protocol.GIT.handles(u) || RepositorySelectionPage.Protocol.SSH.handles(u) || (RepositorySelectionPage.Protocol.HTTP.handles(u) || RepositorySelectionPage.Protocol.HTTPS.handles(u)) && KnownHosts.isKnownHost(u.getHost()) || url.endsWith(".git"))) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }

    public static String sanitizeAsGitUrl(String input) {
        String sanitized = Utils.firstLine((String)input).strip();
        if (sanitized.startsWith(GIT_CLONE_COMMAND_PREFIX) && (sanitized = sanitized.substring(GIT_CLONE_COMMAND_PREFIX.length()).strip()).startsWith(QUOTE) && sanitized.endsWith(QUOTE)) {
            sanitized = sanitized.substring(1, sanitized.length() - 1).strip();
        }
        try {
            URIish uri = new URIish(sanitized);
            if (RepositorySelectionPage.Protocol.FILE.handles(uri)) {
                return sanitized;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return sanitized.split("\\h", 2)[0];
    }

    private static boolean canHandleProtocol(URIish u) {
        for (TransportProtocol proto : Transport.getTransportProtocols()) {
            if (!proto.canHandle(u)) continue;
            return true;
        }
        return false;
    }
}

