/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PushConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class SimplePushActionHandler
extends RepositoryActionHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        try {
            PushOperationUI.pushToUpstream(this.getShell(event), repository);
        }
        catch (IOException e) {
            throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        Repository repository = this.getRepository();
        RemoteConfig config = SimpleConfigurePushDialog.getConfiguredRemoteCached(repository);
        if (config == null) {
            return false;
        }
        List refSpecs = config.getPushRefSpecs();
        if (!refSpecs.isEmpty()) {
            return true;
        }
        PushConfig.PushDefault pushDefault = ((PushConfig)SelectionRepositoryStateCache.INSTANCE.getConfig(repository).get(PushConfig::new)).getPushDefault();
        return !PushConfig.PushDefault.NOTHING.equals((Object)pushDefault);
    }

    public void updateElement(UIElement element, Map parameters) {
        RemoteConfig config = SimpleConfigurePushDialog.getConfiguredRemoteCached(this.getRepository());
        if (config != null) {
            element.setText(SimpleConfigurePushDialog.getSimplePushCommandLabel(config));
        }
    }
}

