/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class WorkingTreeChangeCache {
    public static Map<String, GitCommitsModelCache.Change> build(Repository repo) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (TreeWalk tw = new TreeWalk(repo);){
                int fileNth = tw.addTree((AbstractTreeIterator)new FileTreeIterator(repo));
                int cacheNth = tw.addTree((AbstractTreeIterator)new DirCacheIterator(repo.readDirCache()));
                tw.setFilter((TreeFilter)new IndexDiffFilter(cacheNth, fileNth));
                tw.setRecursive(true);
                HashMap<String, GitCommitsModelCache.Change> result = new HashMap<String, GitCommitsModelCache.Change>();
                MutableObjectId idBuf = new MutableObjectId();
                while (tw.next()) {
                    GitCommitsModelCache.Change change = new GitCommitsModelCache.Change();
                    change.name = tw.getNameString();
                    tw.getObjectId(idBuf, 0);
                    change.objectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
                    tw.getObjectId(idBuf, 1);
                    change.remoteObjectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
                    GitCommitsModelCache.calculateAndSetChangeKind(8, change);
                    result.put(tw.getPathString(), change);
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            return new HashMap<String, GitCommitsModelCache.Change>(0);
        }
    }
}

