/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import org.eclipse.core.resources.IResource;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;

public class OpenWorkspaceFile
extends Action {
    private SourceViewer sourceViewer;
    private GerritClient gerritClient;
    private GerritDiffNode node;

    public OpenWorkspaceFile(SourceViewer sourceViewer, GerritDiffNode node, GerritClient gerritClient) {
        super(Messages.Compare_OpenFile);
        this.sourceViewer = sourceViewer;
        this.gerritClient = gerritClient;
        this.node = node;
    }

    public void run() {
        boolean openSucceeded = false;
        Object editorInput = this.sourceViewer.getInput();
        int selectedLine = 0;
        if (this.sourceViewer.getSelection() instanceof ITextSelection) {
            ITextSelection selection = (ITextSelection)this.sourceViewer.getSelection();
            selectedLine = selection.getStartLine();
        }
        String requestedPath = null;
        if (editorInput instanceof CommentableCompareItem) {
            FileInfo fileShown = ((CommentableCompareItem)((Object)editorInput)).getFileInfo();
            requestedPath = fileShown.getPath();
            openSucceeded = UIUtils.openSingleFile(fileShown, this.gerritClient, fileShown.getRevision(), selectedLine);
        } else if (editorInput instanceof IDocument && this.getWorkspaceNode() != null) {
            IResource file = this.getWorkspaceNode().getResource();
            requestedPath = file.getFullPath().toOSString();
            openSucceeded = UIUtils.openSingleFile(file, selectedLine);
        } else {
            requestedPath = this.getPotentialFileName();
        }
        if (!openSucceeded) {
            UIUtils.displayInformation(Messages.UIFilesTable_3, String.valueOf(Messages.UIFilesTable_2) + '\n' + requestedPath);
        }
    }

    private LocalResourceTypedElement getWorkspaceNode() {
        if (this.node.getLeft() instanceof LocalResourceTypedElement) {
            return (LocalResourceTypedElement)this.node.getLeft();
        }
        if (this.node.getRight() instanceof LocalResourceTypedElement) {
            return (LocalResourceTypedElement)this.node.getRight();
        }
        return null;
    }

    private String getPotentialFileName() {
        if (this.node.getLeft() instanceof CommentableCompareItem) {
            return ((CommentableCompareItem)this.node.getLeft()).getFileInfo().getPath();
        }
        if (this.node.getRight() instanceof CommentableCompareItem) {
            return ((CommentableCompareItem)this.node.getLeft()).getFileInfo().getPath();
        }
        return null;
    }
}

