/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.page;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.core.observable.FXObservableUtil;
import org.eclipse.fx.ui.controls.form.NodeDecorator;
import org.eclipse.fx.ui.preferences.page.FieldEditor;

public class IntegerFieldEditor
extends FieldEditor<Integer> {
    private static final Logger LOGGER = LoggerCreator.createLogger(IntegerFieldEditor.class);
    private final TextField textField;
    private SimpleIntegerProperty value = new SimpleIntegerProperty((Object)this, "value");

    public IntegerFieldEditor(String name, String label) {
        super(name, label);
        this.textField = new TextField();
        this.getChildren().add((Object)this.textField);
        NodeDecorator.apply((Node)this.textField, this.statusProperty());
        FXObservableUtil.onChange((ObservableValue)this.textField.textProperty(), newValue -> {
            try {
                this.value.set(Integer.parseInt(newValue));
            }
            catch (NumberFormatException ex) {
                return;
            }
        });
    }

    public IntegerFieldEditor(String name) {
        this(name, null);
    }

    @Override
    protected ObjectExpression<Status> createStatusBinding() {
        ObjectExpression<Status> parentStatus = super.createStatusBinding();
        return Bindings.createObjectBinding(() -> {
            try {
                Integer.parseInt(this.textField.getText());
                return (Status)parentStatus.get();
            }
            catch (NumberFormatException ex) {
                return Status.status((Status.State)Status.State.ERROR, (int)-1, (String)"The value must be a valid integer", (Throwable)ex);
            }
        }, (Observable[])new Observable[]{parentStatus, this.textField.textProperty()});
    }

    @Override
    protected void doLoad() {
        this.textField.setText(Integer.toString(this.getMemento().get(this.getName(), 0)));
    }

    @Override
    protected void doRestoreDefaults() {
        this.textField.setText(Integer.toString(this.getMemento().getDefaultInteger(this.getName())));
    }

    @Override
    protected void doPersist() {
        try {
            this.getMemento().put(this.getName(), this.getIntValue());
        }
        catch (NumberFormatException ex) {
            LOGGER.error("An error occurred when trying to persist the integer value for " + this.getName(), (Throwable)ex);
        }
    }

    protected final TextField geTextField() {
        return this.textField;
    }

    protected int getIntValue() throws NumberFormatException {
        return Integer.parseInt(this.textField.getText());
    }

    @Override
    public ObservableValue<Integer> getValue() {
        return this.value.asObject();
    }
}

