/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CopyModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateCopyOfCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveCuUpdateCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.OverwriteHelper;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.jdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtilsCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.Changes;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;

public final class ReorgPolicyFactory {
    private static final String ATTRIBUTE_FILES = "files";
    private static final String ATTRIBUTE_FOLDERS = "folders";
    private static final String ATTRIBUTE_FRAGMENTS = "fragments";
    private static final String ATTRIBUTE_LOG = "log";
    private static final String ATTRIBUTE_MEMBERS = "members";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_POLICY = "policy";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_ROOTS = "roots";
    private static final String ATTRIBUTE_UNITS = "units";
    private static final String DELIMITER_ELEMENT = "\t";
    private static final String DELIMITER_RECORD = "\n";
    private static final String NO_ID = "no_id";
    private static final String NO_POLICY = "no_policy";
    private static final String UNUSED_STRING = "unused";

    private static boolean containsNull(Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return (IReorgPolicy.ICopyPolicy)ReorgPolicyFactory.createReorgPolicy(true, resources, javaElements);
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(RefactoringStatus status, JavaRefactoringArguments arguments) {
        block18: {
            block16: {
                String policy = arguments.getAttribute(ATTRIBUTE_POLICY);
                if (policy == null || "".equals(policy)) break block16;
                switch (policy) {
                    case "org.eclipse.jdt.ui.copyResources": {
                        return new CopyFilesFoldersAndCusPolicy(null, null, null);
                    }
                    case "org.eclipse.jdt.ui.copyRoots": {
                        return new CopyPackageFragmentRootsPolicy(null);
                    }
                    case "org.eclipse.jdt.ui.copyPackages": {
                        return new CopyPackagesPolicy(null);
                    }
                    case "org.eclipse.jdt.ui.copyMembers": {
                        return new CopySubCuElementsPolicy(null);
                    }
                }
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{policy, ATTRIBUTE_POLICY})));
                break block18;
            }
            status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POLICY)));
        }
        return null;
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return (IReorgPolicy.IMovePolicy)ReorgPolicyFactory.createReorgPolicy(false, resources, javaElements);
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(RefactoringStatus status, JavaRefactoringArguments arguments) {
        block21: {
            block19: {
                String policy = arguments.getAttribute(ATTRIBUTE_POLICY);
                if (policy == null || "".equals(policy)) break block19;
                switch (policy) {
                    case "org.eclipse.jdt.ui.moveResources": {
                        return new MoveFilesFoldersAndCusPolicy(null, null, null);
                    }
                    case "org.eclipse.jdt.ui.moveRoots": {
                        return new MovePackageFragmentRootsPolicy(null);
                    }
                    case "org.eclipse.jdt.ui.movePackages": {
                        return new MovePackagesPolicy(null);
                    }
                    case "org.eclipse.jdt.ui.moveMembers": {
                        return new MoveMembersPolicy(null);
                    }
                    case "org.eclipse.jdt.ui.moveImportDeclarations": {
                        return new MoveImportDeclarationsPolicy(null);
                    }
                }
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{policy, ATTRIBUTE_POLICY})));
                break block21;
            }
            status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POLICY)));
        }
        return null;
    }

    private static IReorgPolicy createReorgPolicy(boolean copy, IResource[] selectedResources, IJavaElement[] selectedJavaElements) throws JavaModelException {
        ReorgPolicy NO = copy ? new NoCopyPolicy() : new NoMovePolicy();
        ActualSelectionComputer selectionComputer = new ActualSelectionComputer(selectedJavaElements, selectedResources);
        Object[] resources = selectionComputer.getActualResourcesToReorg();
        Object[] javaElements = selectionComputer.getActualJavaElementsToReorg();
        if (resources.length == 0 && javaElements.length == 0) {
            return NO;
        }
        if (ReorgPolicyFactory.containsNull(resources)) {
            return NO;
        }
        if (ReorgPolicyFactory.containsNull(javaElements)) {
            return NO;
        }
        if (ReorgUtilsCore.isArchiveOrExternalMember((IJavaElement[])javaElements) && ReorgUtilsCore.getElementsOfType((IJavaElement[])javaElements, 3).size() != javaElements.length) {
            return NO;
        }
        if (ReorgUtilsCore.hasElementsOfType((IJavaElement[])javaElements, 2)) {
            return NO;
        }
        if (ReorgUtilsCore.hasElementsOfType((IJavaElement[])javaElements, 1)) {
            return NO;
        }
        if (ReorgUtilsCore.hasElementsOfType((IResource[])resources, 12)) {
            return NO;
        }
        if (!new ParentChecker((IResource[])resources, (IJavaElement[])javaElements).haveCommonParent()) {
            return NO;
        }
        if (ReorgUtilsCore.hasElementsOfType((IJavaElement[])javaElements, 4)) {
            if (resources.length != 0 || ReorgUtilsCore.hasElementsNotOfType((IJavaElement[])javaElements, 4)) {
                return NO;
            }
            if (copy) {
                return new CopyPackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
            }
            return new MovePackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
        }
        if (ReorgUtilsCore.hasElementsOfType((IJavaElement[])javaElements, 3)) {
            if (resources.length != 0 || ReorgUtilsCore.hasElementsNotOfType((IJavaElement[])javaElements, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyPackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
            }
            return new MovePackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
        }
        if (ReorgUtilsCore.hasElementsOfType((IResource[])resources, 3) || ReorgUtilsCore.hasElementsOfType((IJavaElement[])javaElements, 5)) {
            if (ReorgUtilsCore.hasElementsNotOfType((IJavaElement[])javaElements, 5)) {
                return NO;
            }
            if (ReorgUtilsCore.hasElementsNotOfType((IResource[])resources, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyFilesFoldersAndCusPolicy(ReorgUtilsCore.getFiles((IResource[])resources), ReorgUtilsCore.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements));
            }
            return new MoveFilesFoldersAndCusPolicy(ReorgUtilsCore.getFiles((IResource[])resources), ReorgUtilsCore.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements));
        }
        if (ReorgPolicyFactory.hasOnlyMembers((IJavaElement[])javaElements)) {
            if (ReorgPolicyFactory.hasAnonymousClassDeclarations((IJavaElement[])javaElements)) {
                return NO;
            }
            if (copy) {
                return new CopySubCuElementsPolicy((IJavaElement[])javaElements);
            }
            List<Object> members = Arrays.asList(javaElements);
            return new MoveMembersPolicy(members.toArray(new IMember[members.size()]));
        }
        if (ReorgPolicyFactory.hasOnlyImportDeclarations((IJavaElement[])javaElements)) {
            if (copy) {
                return new CopySubCuElementsPolicy((IJavaElement[])javaElements);
            }
            List<?> declarations = ReorgUtilsCore.getElementsOfType((IJavaElement[])javaElements, 13);
            return new MoveImportDeclarationsPolicy(declarations.toArray(new IImportDeclaration[declarations.size()]));
        }
        if (copy && ReorgPolicyFactory.hasElementsSmallerThanCuOrClassFile((IJavaElement[])javaElements)) {
            if (ReorgUtilsCore.hasElementsOfType((IJavaElement[])javaElements, 11)) {
                return NO;
            }
            if (ReorgPolicyFactory.hasAnonymousClassDeclarations((IJavaElement[])javaElements)) {
                return NO;
            }
            Assert.isTrue((resources.length == 0 ? 1 : 0) != 0);
            return new CopySubCuElementsPolicy((IJavaElement[])javaElements);
        }
        return NO;
    }

    private static boolean hasAnonymousClassDeclarations(IJavaElement[] javaElements) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IType type;
            IJavaElement javaElement = iJavaElementArray[n2];
            if (javaElement instanceof IType && (type = (IType)javaElement).isAnonymous()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasElementsSmallerThanCuOrClassFile(IJavaElement[] javaElements) {
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            if (ReorgUtilsCore.isInsideCompilationUnit(javaElement)) {
                return true;
            }
            if (ReorgUtilsCore.isInsideClassFile(javaElement)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasOnlyImportDeclarations(IJavaElement[] javaElements) {
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            if (javaElement.getElementType() != 13) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean hasOnlyMembers(IJavaElement[] javaElements) {
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            if (!(javaElement instanceof IMember)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static CreateTargetExecutionLog loadCreateTargetExecutionLog(JavaRefactoringArguments arguments) {
        CreateTargetExecutionLog log = new CreateTargetExecutionLog();
        String value = arguments.getAttribute(ATTRIBUTE_LOG);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, DELIMITER_RECORD, false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                ReorgPolicyFactory.processCreateTargetExecutionRecord(log, arguments, token);
            }
        }
        return log;
    }

    public static ReorgExecutionLog loadReorgExecutionLog(JavaRefactoringArguments arguments) {
        ReorgExecutionLog log = new ReorgExecutionLog();
        String value = arguments.getAttribute(ATTRIBUTE_LOG);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, DELIMITER_RECORD, false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                ReorgPolicyFactory.processReorgExecutionRecord(log, arguments, token);
            }
        }
        return log;
    }

    private static void processCreateTargetExecutionRecord(CreateTargetExecutionLog log, JavaRefactoringArguments arguments, String token) {
        StringTokenizer tokenizer = new StringTokenizer(token, DELIMITER_ELEMENT, false);
        String value = null;
        if (tokenizer.hasMoreTokens()) {
            value = tokenizer.nextToken();
            IJavaElement selection = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), value, false);
            if (selection == null) {
                selection = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), value);
            }
            if (selection != null && tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
                IJavaElement created = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), value, false);
                if (created == null) {
                    created = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), value);
                }
                if (created != null) {
                    log.markAsCreated(selection, created);
                }
            }
        }
    }

    private static void processReorgExecutionRecord(ReorgExecutionLog log, JavaRefactoringArguments arguments, String token) {
        StringTokenizer tokenizer = new StringTokenizer(token, DELIMITER_ELEMENT, false);
        String value = null;
        if (tokenizer.hasMoreTokens()) {
            value = tokenizer.nextToken();
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), value);
            if (element == null) {
                element = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), value);
            }
            if (tokenizer.hasMoreTokens()) {
                boolean renamed;
                boolean processed = Boolean.parseBoolean(tokenizer.nextToken());
                if (processed) {
                    log.markAsProcessed((Object)element);
                    if (element instanceof IJavaElement) {
                        log.markAsProcessed((Object)JavaElementResourceMapping.create(element));
                    }
                }
                if (tokenizer.hasMoreTokens() && (renamed = Boolean.parseBoolean(tokenizer.nextToken())) && tokenizer.hasMoreTokens()) {
                    String name = tokenizer.nextToken();
                    log.setNewName((Object)element, name);
                    if (element instanceof IJavaElement) {
                        log.setNewName((Object)JavaElementResourceMapping.create(element), name);
                    }
                }
            }
        }
    }

    public static void storeCreateTargetExecutionLog(String project, Map<String, String> arguments, CreateTargetExecutionLog log) {
        if (log != null) {
            StringBuilder buffer = new StringBuilder(64);
            Object[] objectArray = log.getSelectedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object created;
                Object selection = objectArray[n2];
                if (selection != null && (created = log.getCreatedElement(selection)) != null) {
                    ReorgPolicyFactory.storeLogElement(buffer, project, selection);
                    buffer.append(DELIMITER_ELEMENT);
                    ReorgPolicyFactory.storeLogElement(buffer, project, created);
                    buffer.append(DELIMITER_RECORD);
                }
                ++n2;
            }
            String value = buffer.toString().trim();
            if (!"".equals(value)) {
                arguments.put(ATTRIBUTE_LOG, value);
            }
        }
    }

    private static boolean storeLogElement(StringBuilder buffer, String project, Object object) {
        if (object instanceof IJavaElement) {
            IJavaElement element = (IJavaElement)object;
            buffer.append(JavaRefactoringDescriptorUtil.elementToHandle(project, element));
            return true;
        }
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            buffer.append(JavaRefactoringDescriptorUtil.resourceToHandle(project, resource));
            return true;
        }
        return false;
    }

    public static void storeReorgExecutionLog(String project, Map<String, String> arguments, ReorgExecutionLog log) {
        if (log != null) {
            HashSet<Object> set = new HashSet<Object>(Arrays.asList(log.getProcessedElements()));
            set.addAll(Arrays.asList(log.getRenamedElements()));
            StringBuilder buffer = new StringBuilder(64);
            for (Object e : set) {
                if (!ReorgPolicyFactory.storeLogElement(buffer, project, e)) continue;
                buffer.append(DELIMITER_ELEMENT);
                buffer.append(log.isProcessed(e));
                buffer.append(DELIMITER_ELEMENT);
                boolean renamed = log.isRenamed(e);
                buffer.append(renamed);
                if (renamed) {
                    buffer.append(DELIMITER_ELEMENT);
                    buffer.append(log.getNewName(e));
                }
                buffer.append(DELIMITER_RECORD);
            }
            String string = buffer.toString().trim();
            if (!"".equals(string)) {
                arguments.put(ATTRIBUTE_LOG, string);
            }
        }
    }

    private ReorgPolicyFactory() {
    }

    private static final class ActualSelectionComputer {
        private final IJavaElement[] fJavaElements;
        private final IResource[] fResources;

        public ActualSelectionComputer(IJavaElement[] javaElements, IResource[] resources) {
            this.fJavaElements = javaElements;
            this.fResources = resources;
        }

        public IJavaElement[] getActualJavaElementsToReorg() throws JavaModelException {
            ArrayList<Object> result = new ArrayList<Object>();
            IJavaElement[] iJavaElementArray = this.fJavaElements;
            int n = this.fJavaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (element != null) {
                    if (element instanceof IType) {
                        IType type = (IType)element;
                        ICompilationUnit cu = type.getCompilationUnit();
                        if (cu != null && type.getDeclaringType() == null && cu.exists() && cu.getTypes().length == 1 && !result.contains(cu)) {
                            result.add(cu);
                        } else if (!result.contains(type)) {
                            result.add(type);
                        }
                    } else if (!result.contains(element)) {
                        result.add(element);
                    }
                }
                ++n2;
            }
            return result.toArray(new IJavaElement[result.size()]);
        }

        public IResource[] getActualResourcesToReorg() {
            HashSet<IJavaElement> javaElementSet = new HashSet<IJavaElement>(Arrays.asList(this.fJavaElements));
            ArrayList<IResource> result = new ArrayList<IResource>();
            IResource[] iResourceArray = this.fResources;
            int n = this.fResources.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element;
                IResource resource = iResourceArray[n2];
                if (!(resource == null || (element = JavaCore.create((IResource)resource)) != null && element.exists() && javaElementSet.contains(element) || result.contains(resource))) {
                    result.add(resource);
                }
                ++n2;
            }
            return result.toArray(new IResource[result.size()]);
        }
    }

    private static final class CopyFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_RESOURCE = "org.eclipse.jdt.ui.copyResources";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        private static Change copyCuToPackage(ICompilationUnit cu, IPackageFragment dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource res = ReorgUtilsCore.getResource((IJavaElement)cu);
            if (res != null && res.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return CopyFilesFoldersAndCusPolicy.copyFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest), nameProposer, copyQueries);
            }
            String newName = nameProposer.createNewName(cu, dest);
            CopyCompilationUnitChange simpleCopy = new CopyCompilationUnitChange(cu, dest, copyQueries.createStaticQuery(newName));
            if (newName == null || newName.equals(cu.getElementName())) {
                return simpleCopy;
            }
            try {
                IPath newPath = cu.getResource().getParent().getFullPath().append(JavaModelUtil.getRenamedCUName(cu, newName));
                INewNameQuery nameQuery = copyQueries.createNewCompilationUnitNameQuery(cu, newName);
                return new CreateCopyOfCompilationUnitChange(newPath, cu.getSource(), cu, nameQuery);
            }
            catch (CoreException coreException) {
                return simpleCopy;
            }
        }

        private static Change copyFileToContainer(ICompilationUnit cu, IContainer dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource resource = ReorgUtilsCore.getResource((IJavaElement)cu);
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private static Change createCopyResourceChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries, IContainer destination) {
            if (resource == null || destination == null) {
                return new NullChange();
            }
            String name = nameProposer.createNewName(resource, destination);
            INewNameQuery nameQuery = name == null ? copyQueries.createNullQuery() : copyQueries.createNewResourceNameQuery(resource, name);
            return new CopyResourceChange(resource, destination, nameQuery);
        }

        CopyFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            super(files, folders, cus);
        }

        private Change createChange(ICompilationUnit unit, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return CopyFilesFoldersAndCusPolicy.copyCuToPackage(unit, pack, nameProposer, copyQueries);
            }
            IContainer container = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.copyFileToContainer(unit, container, nameProposer, copyQueries);
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            IFile[] file = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", cus.length + file.length + folders.length);
            NewNameProposer nameProposer = new NewNameProposer();
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy);
            composite.markAsSynthetic();
            ICompilationUnit[] iCompilationUnitArray = cus;
            int n = cus.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit cu = iCompilationUnitArray[n2];
                composite.add(this.createChange(cu, nameProposer, copyQueries));
                pm.worked(1);
                ++n2;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            iCompilationUnitArray = file;
            n = file.length;
            n2 = 0;
            while (n2 < n) {
                ICompilationUnit f = iCompilationUnitArray[n2];
                composite.add(this.createChange((IResource)f, nameProposer, copyQueries));
                pm.worked(1);
                ++n2;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            iCompilationUnitArray = folders;
            n = folders.length;
            n2 = 0;
            while (n2 < n) {
                ICompilationUnit folder = iCompilationUnitArray[n2];
                composite.add(this.createChange((IResource)folder, nameProposer, copyQueries));
                pm.worked(1);
                ++n2;
            }
            pm.done();
            return composite;
        }

        private Change createChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IContainer dest = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            ReorgExecutionLog log = this.getReorgExecutionLog();
            ReorgPolicyFactory.storeReorgExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createCopyDescriptor(project, description, comment.asString(), arguments, flags);
        }

        @Override
        protected String getDescriptionPlural() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_folders;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_files;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_compilation_units;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_description_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_folder;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_file;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_compilation_unit;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_description_singular;
        }

        private Object getDestination() {
            IPackageFragment result = this.getDestinationAsPackageFragment();
            if (result != null) {
                return result;
            }
            return this.getDestinationAsContainer();
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments jArgs = new CopyArguments(this.getDestination(), this.fReorgExecutionLog);
            CopyArguments rArgs = new CopyArguments((Object)this.getDestinationAsContainer(), this.fReorgExecutionLog);
            ICompilationUnit[] iCompilationUnitArray = this.getCus();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit cu = iCompilationUnitArray[n2];
                this.fModifications.copy(cu, jArgs, rArgs);
                ++n2;
            }
            iCompilationUnitArray = ReorgUtilsCore.union((IResource[])this.getFiles(), (IResource[])this.getFolders());
            n = iCompilationUnitArray.length;
            n2 = 0;
            while (n2 < n) {
                ICompilationUnit resource = iCompilationUnitArray[n2];
                this.fModifications.copy((IResource)resource, rArgs);
                ++n2;
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_COPY_RESOURCE;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopyPackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_ROOTS = "org.eclipse.jdt.ui.copyRoots";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        private Change createChange(IPackageFragmentRoot root, IJavaProject destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IProject destinationProject;
            IResource res = root.getResource();
            String newName = nameProposer.createNewName(res, (IContainer)(destinationProject = destination.getProject()));
            INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageFragmentRootNameQuery(root, newName);
            return new CopyPackageFragmentRootChange(root, destinationProject, nameQuery, null);
        }

        private Change createChange(IPackageFragmentRoot root, IContainer destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource res = root.getResource();
            String newName = nameProposer.createNewName(res, destination);
            INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewResourceNameQuery(res, newName);
            return new CopyResourceChange(res, destination, nameQuery);
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_source_folder);
            composite.markAsSynthetic();
            IJavaProject destination = this.getDestinationJavaProject();
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (destination == null) {
                    composite.add(this.createChange(root, (IContainer)this.getResourceDestination(), nameProposer, copyQueries));
                } else {
                    composite.add(this.createChange(root, destination, nameProposer, copyQueries));
                }
                pm.worked(1);
                ++n2;
            }
            pm.done();
            return composite;
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            ReorgExecutionLog log = this.getReorgExecutionLog();
            ReorgPolicyFactory.storeReorgExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createCopyDescriptor(project, description, comment.asString(), arguments, flags);
        }

        @Override
        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            IJavaProject destination = this.getDestinationJavaProject();
            if (destination == null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = this.getRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    this.fModifications.copy(root.getResource(), new CopyArguments((Object)this.getResourceDestination(), this.fReorgExecutionLog));
                    ++n2;
                }
            } else {
                CopyArguments javaArgs = new CopyArguments((Object)destination, this.fReorgExecutionLog);
                CopyArguments resourceArgs = new CopyArguments((Object)destination.getProject(), this.fReorgExecutionLog);
                IPackageFragmentRoot[] iPackageFragmentRootArray = this.getRoots();
                int n = iPackageFragmentRootArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n3];
                    this.fModifications.copy(root, javaArgs, resourceArgs);
                    ++n3;
                }
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_COPY_ROOTS;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopyPackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_PACKAGES = "org.eclipse.jdt.ui.copyPackages";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        private Change createChange(IPackageFragment pack, IPackageFragmentRoot destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            String newName = nameProposer.createNewName(pack, destination);
            if (newName == null || JavaConventionsUtil.validatePackageName(newName, (IJavaElement)destination).getSeverity() < 4) {
                INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageNameQuery(pack, newName);
                return new CopyPackageChange(pack, destination, nameQuery);
            }
            if (destination.getResource() instanceof IContainer) {
                IContainer dest = (IContainer)destination.getResource();
                IResource res = pack.getResource();
                INewNameQuery nameQuery = copyQueries.createNewResourceNameQuery(res, newName);
                return new CopyResourceChange(res, dest, nameQuery);
            }
            return new NullChange();
        }

        private Change createChange(IPackageFragment pack, IContainer container, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            String newName = nameProposer.createNewName(pack.getResource(), container);
            if (newName == null) {
                return new CopyResourceChange(pack.getResource(), container, copyQueries.createNullQuery());
            }
            IResource res = pack.getResource();
            INewNameQuery nameQuery = copyQueries.createNewResourceNameQuery(res, newName);
            return new CopyResourceChange(res, container, nameQuery);
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries newNameQueries) throws JavaModelException {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_package);
            composite.markAsSynthetic();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            IPackageFragment[] iPackageFragmentArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment fragment = iPackageFragmentArray[n2];
                if (root == null) {
                    composite.add(this.createChange(fragment, (IContainer)this.getResourceDestination(), nameProposer, newNameQueries));
                } else {
                    composite.add(this.createChange(fragment, root, nameProposer, newNameQueries));
                }
                pm.worked(1);
                ++n2;
            }
            pm.done();
            return composite;
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            ReorgExecutionLog log = this.getReorgExecutionLog();
            ReorgPolicyFactory.storeReorgExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createCopyDescriptor(project, description, comment.asString(), arguments, flags);
        }

        @Override
        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_package_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            IPackageFragmentRoot destination = this.getDestinationAsPackageFragmentRoot();
            if (destination == null) {
                IPackageFragment[] iPackageFragmentArray = this.getPackages();
                int n = iPackageFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment p = iPackageFragmentArray[n2];
                    this.fModifications.copy(p.getResource(), new CopyArguments((Object)this.getResourceDestination(), this.fReorgExecutionLog));
                    ++n2;
                }
            } else {
                CopyArguments javaArgs = new CopyArguments((Object)destination, this.fReorgExecutionLog);
                CopyArguments resourceArgs = new CopyArguments((Object)destination.getResource(), this.fReorgExecutionLog);
                IPackageFragment[] iPackageFragmentArray = this.getPackages();
                int n = iPackageFragmentArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IPackageFragment p = iPackageFragmentArray[n3];
                    this.fModifications.copy(p, javaArgs, resourceArgs);
                    ++n3;
                }
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_COPY_PACKAGES;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopySubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_MEMBERS = "org.eclipse.jdt.ui.copyMembers";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        CopySubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && (this.getSourceCu() != null || this.getSourceClassFile() != null);
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) throws JavaModelException {
            try {
                CompilationUnit sourceCuNode = this.createSourceCuNode();
                ICompilationUnit targetCu = CopySubCuElementsPolicy.getEnclosingCompilationUnit(this.getJavaElementDestination());
                CompilationUnitRewrite targetRewriter = new CompilationUnitRewrite(targetCu);
                IJavaElement[] iJavaElementArray = this.getJavaElements();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement javaElement = iJavaElementArray[n2];
                    this.copyToDestination(javaElement, targetRewriter, sourceCuNode, targetRewriter.getRoot());
                    ++n2;
                }
                return CopySubCuElementsPolicy.createCompilationUnitChange(targetRewriter);
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            ReorgExecutionLog log = this.getReorgExecutionLog();
            ReorgPolicyFactory.storeReorgExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createCopyDescriptor(project, description, comment.asString(), arguments, flags);
        }

        private CompilationUnit createSourceCuNode() {
            Assert.isTrue((this.getSourceCu() != null || this.getSourceClassFile() != null ? 1 : 0) != 0);
            Assert.isTrue((this.getSourceCu() == null || this.getSourceClassFile() == null ? 1 : 0) != 0);
            ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            parser.setBindingsRecovery(true);
            parser.setResolveBindings(true);
            if (this.getSourceCu() != null) {
                parser.setSource(this.getSourceCu());
            } else {
                parser.setSource(this.getSourceClassFile());
            }
            return (CompilationUnit)parser.createAST(null);
        }

        @Override
        public IFile[] getAllModifiedFiles() {
            return ReorgUtilsCore.getFiles(new IResource[]{ReorgUtilsCore.getResource((IJavaElement)CopySubCuElementsPolicy.getEnclosingCompilationUnit(this.getJavaElementDestination()))});
        }

        @Override
        protected String getDescriptionPlural() {
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 7)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_types;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 8)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_fields;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 9)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_methods;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 10)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_initializers;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 11)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_package_declarations;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 12)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_import_containers;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 13)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_imports;
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 7)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_type;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 8)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_field;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 9)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_method;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 10)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_initializer;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 11)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_package;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 12)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_import_section;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 13)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_import;
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments args = new CopyArguments((Object)this.getJavaElementDestination(), this.fReorgExecutionLog);
            IJavaElement[] iJavaElementArray = this.getJavaElements();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement javaElement = iJavaElementArray[n2];
                this.fModifications.copy(javaElement, args, null);
                ++n2;
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_COPY_MEMBERS;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        private IClassFile getSourceClassFile() {
            return (IClassFile)this.getJavaElements()[0].getAncestor(6);
        }
    }

    private static abstract class FilesFoldersAndCusReorgPolicy
    extends ReorgPolicy {
        protected static final int ONLY_CUS = 2;
        protected static final int ONLY_FILES = 1;
        protected static final int ONLY_FOLDERS = 0;
        private ICompilationUnit[] fCus;
        private IFile[] fFiles;
        private IFolder[] fFolders;

        private static IContainer getAsContainer(IResource resDest) {
            if (resDest instanceof IContainer) {
                return (IContainer)resDest;
            }
            if (resDest instanceof IFile) {
                return ((IFile)resDest).getParent();
            }
            return null;
        }

        public FilesFoldersAndCusReorgPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            this.fFiles = files;
            this.fFolders = folders;
            this.fCus = cus;
        }

        @Override
        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: {
                    return true;
                }
                case 3: {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                    return !root.isArchive() && !root.isExternal();
                }
            }
            return false;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canElementBeDestination(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 4: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IProject || resource instanceof IFolder;
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            this.confirmOverwriting(reorgQueries);
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            return status;
        }

        private void confirmOverwriting(IReorgQueries reorgQueries) {
            OverwriteHelper helper = new OverwriteHelper();
            helper.setFiles(this.fFiles);
            helper.setFolders(this.fFolders);
            helper.setCus(this.fCus);
            IPackageFragment destPack = this.getDestinationAsPackageFragment();
            if (destPack != null) {
                helper.confirmOverwriting(reorgQueries, destPack);
            } else {
                IContainer destinationAsContainer = this.getDestinationAsContainer();
                if (destinationAsContainer != null) {
                    helper.confirmOverwriting(reorgQueries, destinationAsContainer);
                }
            }
            this.fFiles = helper.getFilesWithoutUnconfirmedOnes();
            this.fFolders = helper.getFoldersWithoutUnconfirmedOnes();
            this.fCus = helper.getCusWithoutUnconfirmedOnes();
        }

        protected boolean containsLinkedResources() {
            return ReorgUtilsCore.containsLinkedResources((IResource[])this.fFiles) || ReorgUtilsCore.containsLinkedResources((IResource[])this.fFolders) || ReorgUtilsCore.containsLinkedResources((IJavaElement[])this.fCus);
        }

        protected abstract JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment var1, Map<String, String> var2, String var3, String var4, int var5);

        protected final int getContentKind() {
            int length = this.fCus.length + this.fFiles.length + this.fFolders.length;
            if (length == this.fCus.length) {
                return 2;
            }
            if (length == this.fFiles.length) {
                return 1;
            }
            if (length == this.fFolders.length) {
                return 0;
            }
            return -1;
        }

        protected final ICompilationUnit[] getCus() {
            return this.fCus;
        }

        private final String getSingleElementName() {
            switch (this.getContentKind()) {
                case 0: {
                    return this.fFolders[0].getName();
                }
                case 1: {
                    return this.fFiles[0].getName();
                }
                case 2: {
                    return this.fCus[0].getElementName();
                }
            }
            return null;
        }

        @Override
        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fFiles.length + this.fFolders.length + this.fCus.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = length == 1 ? Messages.format(this.getHeaderPatternSingular(), new String[]{this.getSingleElementName(), this.getDestinationLabel()}) : Messages.format(this.getHeaderPatternPlural(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_FILES, Integer.toString(this.fFiles.length));
            int offset = 0;
            while (offset < this.fFiles.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.resourceToHandle(project, (IResource)this.fFiles[offset]));
                ++offset;
            }
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_FOLDERS, Integer.toString(this.fFolders.length));
            offset = 0;
            while (offset < this.fFolders.length) {
                arguments.put("element" + (offset + this.fFiles.length + 1), JavaRefactoringDescriptorUtil.resourceToHandle(project, (IResource)this.fFolders[offset]));
                ++offset;
            }
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_UNITS, Integer.toString(this.fCus.length));
            offset = 0;
            while (offset < this.fCus.length) {
                arguments.put("element" + (offset + this.fFolders.length + this.fFiles.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCus[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            JavaRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        protected final IContainer getDestinationAsContainer() {
            IResource resDest = this.getResourceDestination();
            if (resDest != null) {
                return FilesFoldersAndCusReorgPolicy.getAsContainer(resDest);
            }
            IJavaElement jelDest = this.getJavaElementDestination();
            Assert.isNotNull((Object)jelDest);
            return FilesFoldersAndCusReorgPolicy.getAsContainer(ReorgUtilsCore.getResource(jelDest));
        }

        protected IPackageFragment getDestinationAsPackageFragment() {
            IPackageFragment javaAsPackage = this.getJavaDestinationAsPackageFragment(this.getJavaElementDestination());
            boolean copyFilesToDefaultPackage = true;
            if (javaAsPackage != null) {
                IJavaProject jProject = javaAsPackage.getJavaProject();
                if (jProject != null && JavaModelUtil.is9OrHigher(jProject) && javaAsPackage.isDefaultPackage()) {
                    try {
                        IModuleDescription desc = jProject.getModuleDescription();
                        if (desc != null && desc.exists()) {
                            copyFilesToDefaultPackage = false;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
                if (copyFilesToDefaultPackage) {
                    return javaAsPackage;
                }
            }
            return this.getResourceDestinationAsPackageFragment(this.getResourceDestination());
        }

        protected final IJavaElement getDestinationContainerAsJavaElement() {
            if (this.getJavaElementDestination() != null) {
                return this.getJavaElementDestination();
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return null;
            }
            IJavaElement je = JavaCore.create((IResource)destinationAsContainer);
            if (je != null && je.exists()) {
                return je;
            }
            return null;
        }

        protected final IFile[] getFiles() {
            return this.fFiles;
        }

        protected final IFolder[] getFolders() {
            return this.fFolders;
        }

        private IPackageFragment getJavaDestinationAsPackageFragment(IJavaElement javaDest) {
            if (javaDest == null || this.fCheckDestination && !javaDest.exists()) {
                return null;
            }
            if (javaDest instanceof IPackageFragment) {
                return (IPackageFragment)javaDest;
            }
            if (javaDest instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)javaDest).getPackageFragment("");
            }
            if (javaDest instanceof IJavaProject) {
                try {
                    IPackageFragmentRoot root = ReorgUtilsCore.getCorrespondingPackageFragmentRoot((IJavaProject)javaDest);
                    if (root != null) {
                        return root.getPackageFragment("");
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return (IPackageFragment)javaDest.getAncestor(4);
        }

        @Override
        public final IJavaElement[] getJavaElements() {
            return this.fCus;
        }

        private IPackageFragment getResourceDestinationAsPackageFragment(IResource resource) {
            if (resource instanceof IFile) {
                return this.getJavaDestinationAsPackageFragment(JavaCore.create((IResource)resource.getParent()));
            }
            return null;
        }

        @Override
        public final IResource[] getResources() {
            return ReorgUtilsCore.union((IResource[])this.fFiles, (IResource[])this.fFolders);
        }

        private IProject getSingleProject() {
            IProject result = null;
            IFile[] iFileArray = this.fFiles;
            int n = this.fFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (result == null) {
                    result = file.getProject();
                } else if (!result.equals((Object)file.getProject())) {
                    return null;
                }
                ++n2;
            }
            iFileArray = this.fFolders;
            n = this.fFolders.length;
            n2 = 0;
            while (n2 < n) {
                IFile folder = iFileArray[n2];
                if (result == null) {
                    result = folder.getProject();
                } else if (!result.equals((Object)folder.getProject())) {
                    return null;
                }
                ++n2;
            }
            iFileArray = this.fCus;
            n = this.fCus.length;
            n2 = 0;
            while (n2 < n) {
                IFile cu = iFileArray[n2];
                if (result == null) {
                    result = cu.getJavaProject().getProject();
                } else if (!result.equals((Object)cu.getJavaProject().getProject())) {
                    return null;
                }
                ++n2;
            }
            return result;
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            IResource resource;
            String attribute;
            RefactoringStatus status = new RefactoringStatus();
            int fileCount = 0;
            int folderCount = 0;
            int unitCount = 0;
            String value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FILES);
            if (value != null && !"".equals(value)) {
                try {
                    fileCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FILES));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FILES));
            }
            value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FOLDERS);
            if (value != null && !"".equals(value)) {
                try {
                    folderCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FOLDERS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FOLDERS));
            }
            value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_UNITS);
            if (value != null && !"".equals(value)) {
                try {
                    unitCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_UNITS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_UNITS));
            }
            String handle = null;
            ArrayList<Object> elements = new ArrayList<Object>();
            int index = 0;
            while (index < fileCount) {
                attribute = "element" + (index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    resource = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), handle);
                    if (resource == null || !resource.exists()) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(resource, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(resource);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fFiles = elements.toArray(new IFile[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < folderCount) {
                attribute = "element" + (fileCount + index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    resource = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), handle);
                    if (resource == null || !resource.exists()) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(resource, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(resource);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fFolders = elements.toArray(new IFolder[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < unitCount) {
                attribute = "element" + (folderCount + fileCount + index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                    if (element == null || !element.exists() || element.getElementType() != 5) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fCus = elements.toArray(new ICompilationUnit[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            IFolder[] iFolderArray = this.fFolders;
            int n = this.fFolders.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder folder = iFolderArray[n2];
                if (folder.equals((Object)resource) || ParentChecker.isDescendantOf(resource, (IResource)folder)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            IOpenable openable;
            Assert.isNotNull((Object)javaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist0);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_readonly);
            }
            if (!javaElement.isStructureKnown()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_structure);
            }
            if (javaElement instanceof IOpenable && !(openable = (IOpenable)javaElement).isConsistent()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inconsistent);
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                if (root.isArchive()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_archive);
                }
                if (root.isExternal()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_external);
                }
            }
            if (ReorgUtilsCore.isInsideCompilationUnit(javaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null || this.isChildOfOrEqualToAnyFolder((IResource)destinationAsContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtilsCore.canBeDestinationForLinkedResources(javaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            if (resource.getType() == 8) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtilsCore.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }
    }

    private static final class MoveFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_RESOURCES = "org.eclipse.jdt.ui.moveResources";
        private TextChangeManager fChangeManager;
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private String fFilePatterns;
        private MoveModifications fModifications;
        private QualifiedNameSearchResult fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        private boolean fUpdateQualifiedNames = false;
        private boolean fUpdateReferences = true;

        private static Change moveCuToPackage(ICompilationUnit cu, IPackageFragment dest) {
            IResource resource = cu.getResource();
            if (resource != null && resource.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest));
            }
            return new MoveCompilationUnitChange(cu, dest);
        }

        private static Change moveFileToContainer(ICompilationUnit cu, IContainer dest) {
            return new MoveResourceChange(cu.getResource(), dest);
        }

        MoveFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            super(files, folders, cus);
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return this.getCus().length > 0 && !JavaElementUtil.isDefaultPackage(this.getCommonParent());
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return true;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            if (!this.canEnableQualifiedNameUpdating()) {
                return false;
            }
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack == null) {
                return false;
            }
            if (pack.isDefaultPackage()) {
                return false;
            }
            IJavaElement destination = this.getJavaElementDestination();
            return !(destination instanceof IPackageFragmentRoot) || this.getCus().length <= 0;
        }

        private boolean cannotUpdateReferencesForDestination() {
            if (this.getCus().length == 0) {
                return false;
            }
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack == null || pack.isDefaultPackage()) {
                return true;
            }
            IJavaElement destination = this.getJavaElementDestination();
            if (destination instanceof IPackageFragmentRoot && this.getCus().length > 0) {
                return false;
            }
            Object commonParent = this.getCommonParent();
            return JavaElementUtil.isDefaultPackage(commonParent);
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                pm.beginTask("", this.fUpdateQualifiedNames ? 7 : 3);
                RefactoringStatus result = new RefactoringStatus();
                this.confirmMovingReadOnly(reorgQueries);
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 2), result);
                if (this.fUpdateQualifiedNames) {
                    this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 4));
                }
                result.merge(super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, reorgQueries));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            finally {
                pm.done();
            }
        }

        @Override
        protected IPackageFragment getDestinationAsPackageFragment() {
            IJavaElement destination = this.getJavaElementDestination();
            if (destination instanceof IPackageFragmentRoot && this.getCus().length > 0) {
                String packageName = ((IPackageFragment)this.getCus()[0].getParent()).getElementName();
                return ((IPackageFragmentRoot)destination).getPackageFragment(packageName);
            }
            return super.getDestinationAsPackageFragment();
        }

        private void computeQualifiedNameMatches(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateQualifiedNames) {
                return;
            }
            IPackageFragment destination = this.getDestinationAsPackageFragment();
            if (destination != null) {
                ICompilationUnit[] cus = this.getCus();
                pm.beginTask("", cus.length);
                pm.subTask(RefactoringCoreMessages.MoveRefactoring_scanning_qualified_names);
                ICompilationUnit[] iCompilationUnitArray = cus;
                int n = cus.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit cu = iCompilationUnitArray[n2];
                    IType[] types = cu.getTypes();
                    SubProgressMonitor typesMonitor = new SubProgressMonitor(pm, 1);
                    typesMonitor.beginTask("", types.length);
                    IType[] iTypeArray = types;
                    int n3 = types.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType type = iTypeArray[n4];
                        this.handleType(type, destination, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)typesMonitor, 1));
                        if (typesMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++n4;
                    }
                    typesMonitor.done();
                    ++n2;
                }
            }
            pm.done();
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(ICompilationUnit cu) {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return MoveFilesFoldersAndCusPolicy.moveCuToPackage(cu, pack);
            }
            IContainer container = this.getDestinationAsContainer();
            if (container == null) {
                return new NullChange();
            }
            return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, container);
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateReferences) {
                return this.createSimpleMoveChange(pm);
            }
            return this.createReferenceUpdatingMoveChange(pm);
        }

        private Change createChange(IResource res) {
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return new NullChange();
            }
            return new MoveResourceChange(res, destinationAsContainer);
        }

        private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
            pm.beginTask("", 1);
            try {
                if (!this.fUpdateReferences) {
                    TextChangeManager textChangeManager = new TextChangeManager();
                    return textChangeManager;
                }
                IPackageFragment packageDest = this.getDestinationAsPackageFragment();
                if (packageDest != null) {
                    MoveCuUpdateCreator creator = new MoveCuUpdateCreator(this.getCus(), packageDest);
                    TextChangeManager textChangeManager = creator.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), status);
                    return textChangeManager;
                }
                TextChangeManager textChangeManager = new TextChangeManager();
                return textChangeManager;
            }
            finally {
                pm.done();
            }
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            CreateTargetExecutionLog log = this.getCreateTargetExecutionLog();
            ReorgPolicyFactory.storeCreateTargetExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createMoveDescriptor(project, description, comment.asString(), arguments, flags);
        }

        private Change createReferenceUpdatingMoveChange(IProgressMonitor pm) throws JavaModelException {
            pm.beginTask("", 2 + (this.fUpdateQualifiedNames ? 1 : 0));
            try {
                DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
                composite.markAsSynthetic();
                if (this.fChangeManager == null) {
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), new RefactoringStatus());
                    try {
                        RefactoringStatus status = Checks.validateModifiesFiles(this.getAllModifiedFiles(), null, pm);
                        if (status.hasFatalError()) {
                            this.fChangeManager = new TextChangeManager();
                        }
                    }
                    catch (CoreException coreException) {
                        this.fChangeManager = new TextChangeManager();
                    }
                }
                composite.merge(new CompositeChange(RefactoringCoreMessages.MoveRefactoring_reorganize_elements, (Change[])this.fChangeManager.getAllChanges()));
                Change fileMove = this.createSimpleMoveChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (fileMove instanceof CompositeChange) {
                    composite.merge((CompositeChange)fileMove);
                } else {
                    composite.add(fileMove);
                }
                DynamicValidationStateChange dynamicValidationStateChange = composite;
                return dynamicValidationStateChange;
            }
            finally {
                pm.done();
            }
        }

        private Change createSimpleMoveChange(IProgressMonitor pm) {
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
            result.markAsSynthetic();
            IFile[] files = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", files.length + folders.length + cus.length);
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                result.add(this.createChange((IResource)file));
                pm.worked(1);
                ++n2;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            iFileArray = folders;
            n = folders.length;
            n2 = 0;
            while (n2 < n) {
                IFile folder = iFileArray[n2];
                result.add(this.createChange((IResource)folder));
                pm.worked(1);
                ++n2;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            iFileArray = cus;
            n = cus.length;
            n2 = 0;
            while (n2 < n) {
                IFile cu = iFileArray[n2];
                result.add(this.createChange((ICompilationUnit)cu));
                pm.worked(1);
                ++n2;
            }
            pm.done();
            return result;
        }

        @Override
        public IFile[] getAllModifiedFiles() {
            HashSet<IFile> result = new HashSet<IFile>(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
            if (!(this.getJavaElementDestination() instanceof IPackageFragmentRoot) && this.getDestinationAsPackageFragment() != null && this.getUpdateReferences()) {
                result.addAll(Arrays.asList(ResourceUtil.getFiles(this.getCus())));
            }
            return result.toArray(new IFile[result.size()]);
        }

        private Object getCommonParent() {
            return new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return createQueries.createNewPackageQuery();
        }

        @Override
        protected String getDescriptionPlural() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_folders;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_files;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_compilation_units;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_description_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_folder;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_file;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_compilation_unit;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_description_singular;
        }

        @Override
        public String getFilePatterns() {
            return this.fFilePatterns;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            int n;
            int n2;
            ICompilationUnit[] iCompilationUnitArray;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            IContainer container = this.getDestinationAsContainer();
            Object unitDestination = null;
            unitDestination = pack != null ? pack : container;
            boolean updateReferenes = this.getUpdateReferences();
            if (unitDestination != null) {
                iCompilationUnitArray = this.getCus();
                n2 = iCompilationUnitArray.length;
                n = 0;
                while (n < n2) {
                    ICompilationUnit unit = iCompilationUnitArray[n];
                    this.fModifications.move(unit, new MoveArguments(unitDestination, updateReferenes));
                    ++n;
                }
            }
            if (container != null) {
                iCompilationUnitArray = this.getFiles();
                n2 = iCompilationUnitArray.length;
                n = 0;
                while (n < n2) {
                    ICompilationUnit file = iCompilationUnitArray[n];
                    this.fModifications.move((IResource)file, new MoveArguments((Object)container, updateReferenes));
                    ++n;
                }
                iCompilationUnitArray = this.getFolders();
                n2 = iCompilationUnitArray.length;
                n = 0;
                while (n < n2) {
                    ICompilationUnit folder = iCompilationUnitArray[n];
                    this.fModifications.move((IResource)folder, new MoveArguments((Object)container, updateReferenes));
                    ++n;
                }
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_RESOURCES;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        protected Map<String, String> getRefactoringArguments(String project) {
            HashMap<String, String> arguments = new HashMap<String, String>(super.getRefactoringArguments(project));
            if (this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
                arguments.put(ReorgPolicyFactory.ATTRIBUTE_PATTERNS, this.fFilePatterns);
            }
            arguments.put("references", Boolean.toString(this.fUpdateReferences));
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_QUALIFIED, Boolean.toString(this.fUpdateQualifiedNames));
            return arguments;
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return this.fUpdateQualifiedNames;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        private void handleType(IType type, IPackageFragment destination, IProgressMonitor pm) {
            QualifiedNameFinder.process(this.fQualifiedNameSearchResult, type.getFullyQualifiedName(), destination.getElementName() + "." + type.getTypeQualifiedName(), this.fFilePatterns, type.getJavaProject().getProject(), pm);
        }

        @Override
        public boolean hasAllInputSet() {
            if (this.getResourceDestination() == null && this.getJavaElementDestination() == null) {
                return false;
            }
            return !this.canUpdateQualifiedNames();
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            String patterns = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_PATTERNS);
            this.fFilePatterns = patterns != null && !"".equals(patterns) ? patterns : "";
            String references = arguments.getAttribute("references");
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
            this.fUpdateReferences = Boolean.parseBoolean(references);
            String qualified = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_QUALIFIED);
            if (qualified == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_QUALIFIED));
            }
            this.fUpdateQualifiedNames = Boolean.parseBoolean(qualified);
            return super.initialize(arguments);
        }

        @Override
        public boolean isTextualMove() {
            return false;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            if (this.fQualifiedNameSearchResult != null) {
                return this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges));
            }
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        public void setFilePatterns(String patterns) {
            Assert.isNotNull((Object)patterns);
            this.fFilePatterns = patterns;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
            this.fUpdateQualifiedNames = update;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && (destinationAsContainer.equals(commonParent) || commonParent instanceof IPackageFragmentRoot && destinationAsContainer.equals((Object)((IPackageFragmentRoot)commonParent).getResource()))) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IPackageFragment destinationAsPackage = this.getDestinationAsPackageFragment();
            if (destinationAsPackage != null && destinationAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            if (this.cannotUpdateReferencesForDestination()) {
                superStatus.addInfo(RefactoringCoreMessages.ReorgPolicyFactory_noJavaUpdates);
            }
            return superStatus;
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = this.getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IJavaElement destinationContainerAsPackage = this.getDestinationContainerAsJavaElement();
            if (destinationContainerAsPackage != null && destinationContainerAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            if (this.cannotUpdateReferencesForDestination()) {
                superStatus.addInfo(RefactoringCoreMessages.ReorgPolicyFactory_noJavaUpdates);
            }
            return superStatus;
        }
    }

    private static final class MoveImportDeclarationsPolicy
    extends MoveSubCuElementsPolicy {
        private static final String POLICY_MOVE_IMPORT_DECLARATIONS = "org.eclipse.jdt.ui.moveImportDeclarations";

        MoveImportDeclarationsPolicy(IImportDeclaration[] importDeclarations) {
            super((IJavaElement[])importDeclarations);
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_IMPORT_DECLARATIONS;
        }
    }

    private static final class MoveMembersPolicy
    extends MoveSubCuElementsPolicy {
        private static final String POLICY_MOVE_MEMBERS = "org.eclipse.jdt.ui.moveMembers";

        MoveMembersPolicy(IMember[] members) {
            super((IJavaElement[])members);
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_MEMBERS;
        }
    }

    private static final class MovePackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_ROOTS = "org.eclipse.jdt.ui.moveRoots";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private MoveModifications fModifications;
        private boolean fUpdateReferences = true;

        private static boolean isParentOfAny(IJavaProject javaProject, IPackageFragmentRoot[] roots) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (ReorgUtilsCore.isParentInWorkspaceOrOnDisk(root, javaProject)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        MovePackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            IPackageFragmentRoot[] roots;
            if (!super.canEnable()) {
                return false;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceAttributes attributes;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.isReadOnly() && !root.isArchive() && !root.isExternal() && ((attributes = root.getResource().getResourceAttributes()) == null || attributes.isReadOnly())) {
                    return false;
                }
                ++n2;
            }
            return roots.length > 0;
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(IPackageFragmentRoot root, IJavaProject destination) {
            return new MovePackageFragmentRootChange(root, (IContainer)destination.getProject(), null);
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_source_folder);
            composite.markAsSynthetic();
            IJavaProject destination = this.getDestinationJavaProject();
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (destination == null) {
                    composite.add((Change)new MovePackageFragmentRootChange(root, (IContainer)this.getResourceDestination(), null));
                } else {
                    composite.add(this.createChange(root, destination));
                }
                pm.worked(1);
                ++n2;
            }
            pm.done();
            return composite;
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            CreateTargetExecutionLog log = this.getCreateTargetExecutionLog();
            ReorgPolicyFactory.storeCreateTargetExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createMoveDescriptor(project, description, comment.asString(), arguments, flags);
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        @Override
        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IJavaProject destination = this.getDestinationJavaProject();
            boolean updateReferences = this.getUpdateReferences();
            if (destination != null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    this.fModifications.move(root, new MoveArguments((Object)destination, updateReferences));
                    ++n2;
                }
            } else {
                IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n3];
                    this.fModifications.move(root, new MoveArguments((Object)this.getResourceDestination(), updateReferences));
                    ++n3;
                }
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_ROOTS;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        public boolean isTextualMove() {
            return false;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IJavaProject javaProject = this.getDestinationJavaProject();
            if (MovePackageFragmentRootsPolicy.isParentOfAny(javaProject, this.getPackageFragmentRoots())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
            }
            return superStatus;
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource destination) {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_move_source_to_parent);
            }
            return superStatus;
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return false;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            return false;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
        }

        @Override
        public void setFilePatterns(String patterns) {
        }

        @Override
        public String getFilePatterns() {
            return null;
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return false;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        @Override
        public boolean hasAllInputSet() {
            return this.getJavaElementDestination() != null || this.getResourceDestination() != null;
        }
    }

    private static final class MovePackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_PACKAGES = "org.eclipse.jdt.ui.movePackages";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private MoveModifications fModifications;
        private boolean fUpdateReferences = true;

        private static boolean isParentOfAny(IPackageFragmentRoot root, IPackageFragment[] fragments) {
            IPackageFragment[] iPackageFragmentArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment fragment = iPackageFragmentArray[n2];
                if (ReorgUtilsCore.isParentInWorkspaceOrOnDisk(fragment, root)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        MovePackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(IPackageFragment pack, IPackageFragmentRoot destination) {
            return new MovePackageChange(pack, destination);
        }

        private Change createChange(IPackageFragment pack, IContainer destination) {
            return new MoveResourceChange(pack.getResource(), destination);
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_package);
            result.markAsSynthetic();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            IPackageFragment[] iPackageFragmentArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment fragment = iPackageFragmentArray[n2];
                if (root == null) {
                    result.add(this.createChange(fragment, (IContainer)this.getResourceDestination()));
                } else {
                    result.add(this.createChange(fragment, root));
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++n2;
            }
            pm.done();
            return result;
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            CreateTargetExecutionLog log = this.getCreateTargetExecutionLog();
            ReorgPolicyFactory.storeCreateTargetExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createMoveDescriptor(project, description, comment.asString(), arguments, flags);
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        @Override
        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            boolean updateReferences = this.getUpdateReferences();
            IPackageFragmentRoot javaDestination = this.getDestinationAsPackageFragmentRoot();
            IPackageFragment[] iPackageFragmentArray = this.getPackages();
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment p = iPackageFragmentArray[n2];
                if (javaDestination == null) {
                    this.fModifications.move(p.getResource(), new MoveArguments((Object)this.getResourceDestination(), updateReferences));
                } else {
                    this.fModifications.move(p, new MoveArguments((Object)javaDestination, updateReferences));
                }
                ++n2;
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_PACKAGES;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        public boolean isTextualMove() {
            return false;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            if (MovePackagesPolicy.isParentOfAny(root, this.getPackages())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package2parent);
            }
            return superStatus;
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource destination) {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_move_package_to_parent);
            }
            return superStatus;
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return false;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            return false;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
        }

        @Override
        public void setFilePatterns(String patterns) {
        }

        @Override
        public String getFilePatterns() {
            return null;
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return false;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        @Override
        public boolean hasAllInputSet() {
            return this.getJavaElementDestination() != null || this.getResourceDestination() != null;
        }
    }

    private static abstract class MoveSubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private boolean fUpdateReferences = true;

        MoveSubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && this.getSourceCu() != null;
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            pm.beginTask("", 3);
            try {
                IJavaElement[] javaElements;
                CompilationUnitRewrite targetRewriter;
                ICompilationUnit sourceCu = this.getSourceCu();
                CompilationUnit sourceCuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)sourceCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                CompilationUnitRewrite sourceRewriter = new CompilationUnitRewrite(sourceCu, sourceCuNode);
                ICompilationUnit destinationCu = MoveSubCuElementsPolicy.getEnclosingCompilationUnit(this.getJavaElementDestination());
                if (sourceCu.equals(destinationCu)) {
                    targetRewriter = sourceRewriter;
                    pm.worked(1);
                } else {
                    CompilationUnit destinationCuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)destinationCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    targetRewriter = new CompilationUnitRewrite(destinationCu, destinationCuNode);
                }
                IJavaElement[] iJavaElementArray = javaElements = this.getJavaElements();
                int n = javaElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement javaElement = iJavaElementArray[n2];
                    this.copyToDestination(javaElement, targetRewriter, sourceRewriter.getRoot(), targetRewriter.getRoot());
                    ++n2;
                }
                ASTNodeDeleteUtil.markAsDeleted(javaElements, sourceRewriter, null);
                CompilationUnitChange targetCuChange = MoveSubCuElementsPolicy.createCompilationUnitChange(targetRewriter);
                if (sourceCu.equals(destinationCu)) {
                    CompilationUnitChange compilationUnitChange = targetCuChange;
                    return compilationUnitChange;
                }
                DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_members);
                result.markAsSynthetic();
                result.add((Change)targetCuChange);
                if (Arrays.asList(this.getJavaElements()).containsAll(Arrays.asList(sourceCu.getTypes()))) {
                    result.add(DeleteChangeCreator.createDeleteChange(null, new IResource[0], (IJavaElement[])new ICompilationUnit[]{sourceCu}, RefactoringCoreMessages.ReorgPolicy_move, Collections.emptyList()));
                } else {
                    result.add((Change)MoveSubCuElementsPolicy.createCompilationUnitChange(sourceRewriter));
                }
                DynamicValidationStateChange dynamicValidationStateChange = result;
                return dynamicValidationStateChange;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            finally {
                pm.done();
            }
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            CreateTargetExecutionLog log = this.getCreateTargetExecutionLog();
            ReorgPolicyFactory.storeCreateTargetExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createMoveDescriptor(project, description, comment.asString(), arguments, flags);
        }

        @Override
        public IFile[] getAllModifiedFiles() {
            return ReorgUtilsCore.getFiles(new IResource[]{ReorgUtilsCore.getResource((IJavaElement)this.getSourceCu()), ReorgUtilsCore.getResource((IJavaElement)MoveSubCuElementsPolicy.getEnclosingCompilationUnit(this.getJavaElementDestination()))});
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        @Override
        protected String getDescriptionPlural() {
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 7)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_types;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 8)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_fields;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 9)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_methods;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 10)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_initializers;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 11)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_package_declarations;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 12)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_import_containers;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 13)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_import_declarations;
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 7)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_type;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 8)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_field;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 9)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_method;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 10)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_initializer;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 11)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_package_declaration;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 12)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_import_section;
            }
            if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 13)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_import_declaration;
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_header_plural;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        public boolean isTextualMove() {
            return true;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement destination, int location) throws JavaModelException {
            IJavaElement[] elements;
            IJavaElement[] iJavaElementArray = elements = this.getJavaElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                IJavaElement parent = destination.getParent();
                while (parent != null) {
                    if (parent.equals(element)) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    parent = parent.getParent();
                }
                ++n2;
            }
            RefactoringStatus superStatus = super.verifyDestination(destination, location);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            if (location == 3) {
                Object commonParent = new ParentChecker(new IResource[0], this.getJavaElements()).getCommonParent();
                if (destination.equals(commonParent) || Arrays.asList(this.getJavaElements()).contains(destination)) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
                }
                return superStatus;
            }
            if (this.contains(elements, destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            IJavaElement parent = destination.getParent();
            if (!(parent instanceof IType)) {
                return superStatus;
            }
            if (!this.allInSameParent(elements, parent)) {
                return superStatus;
            }
            ArrayList<IJavaElement> sortedChildren = this.getSortedChildren((IType)parent);
            int destinationIndex = sortedChildren.indexOf(destination);
            IJavaElement[] iJavaElementArray2 = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IJavaElement element = iJavaElementArray2[n4];
                int elementIndex = sortedChildren.indexOf(element);
                if (location == 2 && elementIndex == destinationIndex + 1) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                if (location == 1 && elementIndex == destinationIndex - 1) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                ++n4;
            }
            return superStatus;
        }

        private ArrayList<IJavaElement> getSortedChildren(IType parent) throws JavaModelException {
            IJavaElement[] children = parent.getChildren();
            ArrayList<IJavaElement> sortedChildren = new ArrayList<IJavaElement>(Arrays.asList(children));
            Collections.sort(sortedChildren, (e1, e2) -> {
                ISourceRange sr2;
                ISourceRange sr1;
                block5: {
                    if (!(e1 instanceof ISourceReference)) {
                        return 0;
                    }
                    if (!(e2 instanceof ISourceReference)) {
                        return 0;
                    }
                    try {
                        sr1 = ((ISourceReference)e1).getSourceRange();
                        sr2 = ((ISourceReference)e2).getSourceRange();
                        if (sr1 != null && sr2 != null) break block5;
                        return 0;
                    }
                    catch (JavaModelException javaModelException) {
                        return 0;
                    }
                }
                return sr1.getOffset() - sr2.getOffset();
            });
            return sortedChildren;
        }

        private boolean contains(IJavaElement[] elements, IJavaElement element) {
            IJavaElement[] iJavaElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement e = iJavaElementArray[n2];
                if (element.equals(e)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean allInSameParent(IJavaElement[] elements, IJavaElement parent) {
            IJavaElement[] iJavaElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (!element.getParent().equals(parent)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return false;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            return false;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
        }

        @Override
        public void setFilePatterns(String patterns) {
        }

        @Override
        public String getFilePatterns() {
            return null;
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return false;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        @Override
        public boolean hasAllInputSet() {
            return this.getJavaElementDestination() != null || this.getResourceDestination() != null;
        }
    }

    private static final class NewNameProposer {
        private final Set<String> fAutoGeneratedNewNames = new HashSet<String>(2);

        private NewNameProposer() {
        }

        private static boolean isNewNameOk(IContainer container, String newName) {
            return container.findMember(newName) == null;
        }

        private static boolean isNewNameOk(IPackageFragment dest, String newName) {
            return !dest.getCompilationUnit(newName).exists();
        }

        private static boolean isNewNameOk(IPackageFragmentRoot root, String newName) {
            return !root.getPackageFragment(newName).exists();
        }

        private String computeNewName(String str, int resourceType) {
            Pattern p;
            Matcher m;
            int lastIndexOfDot = str.lastIndexOf(46);
            String fileExtension = "";
            String fileNameNoExtension = str;
            if (resourceType == 1 && lastIndexOfDot > 0) {
                fileExtension = str.substring(lastIndexOfDot);
                fileNameNoExtension = str.substring(0, lastIndexOfDot);
            }
            if ((m = (p = Pattern.compile("[0-9]+$")).matcher(fileNameNoExtension)).find()) {
                String numberStr;
                BigDecimal newNumber = null;
                try {
                    newNumber = new BigDecimal(m.group()).add(new BigDecimal(1));
                    numberStr = m.replaceFirst(newNumber.toPlainString());
                }
                catch (NumberFormatException numberFormatException) {
                    numberStr = m.replaceFirst("2");
                }
                return numberStr + fileExtension;
            }
            return fileNameNoExtension + "2" + fileExtension;
        }

        public String createNewName(ICompilationUnit cu, IPackageFragment destination) {
            if (NewNameProposer.isNewNameOk(destination, cu.getElementName())) {
                return null;
            }
            if (!ReorgUtilsCore.isParentInWorkspaceOrOnDisk(cu, destination)) {
                return null;
            }
            int resourceType = cu.getResource().getType();
            String newName = this.computeNewName(cu.getElementName(), resourceType);
            while (true) {
                if (NewNameProposer.isNewNameOk(destination, newName) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return JavaCore.removeJavaLikeExtension((String)newName);
                }
                newName = this.computeNewName(newName, resourceType);
            }
        }

        public String createNewName(IPackageFragment pack, IPackageFragmentRoot destination) {
            if (NewNameProposer.isNewNameOk(destination, pack.getElementName())) {
                return null;
            }
            if (!ReorgUtilsCore.isParentInWorkspaceOrOnDisk(pack, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOf1, pack.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOfMore, new String[]{String.valueOf(i), pack.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        public String createNewName(IResource res, IContainer destination) {
            if (NewNameProposer.isNewNameOk(destination, res.getName())) {
                return null;
            }
            if (!ReorgUtilsCore.isParentInWorkspaceOrOnDisk(res, (IResource)destination)) {
                return null;
            }
            int resourceType = res.getType();
            String newName = this.computeNewName(res.getName(), resourceType);
            while (true) {
                if (NewNameProposer.isNewNameOk(destination, newName) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                newName = this.computeNewName(newName, resourceType);
            }
        }
    }

    private static final class NoCopyPolicy
    extends ReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private NoCopyPolicy() {
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            return false;
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            return new NullChange();
        }

        @Override
        protected String getDescriptionPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        protected String getDescriptionSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        public ChangeDescriptor getDescriptor() {
            return null;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }

        @Override
        public String getPolicyId() {
            return ReorgPolicyFactory.NO_POLICY;
        }

        @Override
        protected String getProcessorId() {
            return ReorgPolicyFactory.NO_ID;
        }

        @Override
        protected String getRefactoringId() {
            return ReorgPolicyFactory.NO_ID;
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return null;
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            return new RefactoringStatus();
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }
    }

    private static final class NoMovePolicy
    extends ReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private NoMovePolicy() {
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            return false;
        }

        @Override
        public Change createChange(IProgressMonitor pm) {
            return new NullChange();
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return new CreateTargetExecutionLog();
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        @Override
        protected String getDescriptionPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        protected String getDescriptionSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        public ChangeDescriptor getDescriptor() {
            return null;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }

        @Override
        public String getPolicyId() {
            return ReorgPolicyFactory.NO_POLICY;
        }

        @Override
        protected String getProcessorId() {
            return ReorgPolicyFactory.NO_ID;
        }

        @Override
        protected String getRefactoringId() {
            return ReorgPolicyFactory.NO_ID;
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            return new RefactoringStatus();
        }

        @Override
        public boolean isTextualMove() {
            return true;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return false;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            return false;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
        }

        @Override
        public void setFilePatterns(String patterns) {
        }

        @Override
        public String getFilePatterns() {
            return null;
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return false;
        }

        @Override
        public boolean getUpdateReferences() {
            return false;
        }

        @Override
        public void setUpdateReferences(boolean update) {
        }

        @Override
        public boolean hasAllInputSet() {
            return this.getJavaElementDestination() != null || this.getResourceDestination() != null;
        }
    }

    private static abstract class PackageFragmentRootsReorgPolicy
    extends ReorgPolicy {
        private IPackageFragmentRoot[] fPackageFragmentRoots;

        public PackageFragmentRootsReorgPolicy(IPackageFragmentRoot[] roots) {
            this.fPackageFragmentRoots = roots;
        }

        @Override
        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canElementBeDestination(IJavaElement javaElement) {
            return javaElement.getElementType() == 2;
        }

        @Override
        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable() || this.fPackageFragmentRoots.length == 0) {
                return false;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.fPackageFragmentRoots;
            int n = this.fPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (!(ReorgUtilsCore.isSourceFolder((IJavaElement)root) || root.isArchive() && !root.isExternal())) {
                    return false;
                }
                ++n2;
            }
            return !ReorgUtilsCore.containsLinkedResources((IJavaElement[])this.fPackageFragmentRoots);
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            this.confirmOverwriting(reorgQueries);
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            return status;
        }

        private void confirmOverwriting(IReorgQueries reorgQueries) {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setPackageFragmentRoots(this.fPackageFragmentRoots);
            IJavaProject javaProject = this.getDestinationJavaProject();
            if (javaProject == null) {
                oh.confirmOverwriting(reorgQueries, this.getResourceDestination());
            } else {
                oh.confirmOverwriting(reorgQueries, javaProject);
            }
            this.fPackageFragmentRoots = oh.getPackageFragmentRootsWithoutUnconfirmedOnes();
        }

        protected abstract JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment var1, Map<String, String> var2, String var3, String var4, int var5);

        @Override
        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fPackageFragmentRoots.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = length == 1 ? Messages.format(this.getHeaderPatternSingular(), new String[]{this.fPackageFragmentRoots[0].getElementName(), this.getDestinationLabel()}) : Messages.format(this.getHeaderPatternPlural(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 6;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_ROOTS, Integer.toString(this.fPackageFragmentRoots.length));
            int offset = 0;
            while (offset < this.fPackageFragmentRoots.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fPackageFragmentRoots[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            JavaRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        private IJavaProject getDestinationAsJavaProject(IJavaElement javaElementDestination) {
            if (javaElementDestination == null) {
                return null;
            }
            return javaElementDestination.getJavaProject();
        }

        protected IJavaProject getDestinationJavaProject() {
            return this.getDestinationAsJavaProject(this.getJavaElementDestination());
        }

        @Override
        public IJavaElement[] getJavaElements() {
            return this.fPackageFragmentRoots;
        }

        protected IPackageFragmentRoot[] getPackageFragmentRoots() {
            return this.fPackageFragmentRoots;
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        public IPackageFragmentRoot[] getRoots() {
            return this.fPackageFragmentRoots;
        }

        private IProject getSingleProject() {
            IProject result = null;
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.fPackageFragmentRoots;
            int n = this.fPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (result == null) {
                    result = root.getJavaProject().getProject();
                } else if (!result.equals((Object)root.getJavaProject().getProject())) {
                    return null;
                }
                ++n2;
            }
            return result;
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            RefactoringStatus status = new RefactoringStatus();
            int rootCount = 0;
            String value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_ROOTS);
            if (value != null && !"".equals(value)) {
                try {
                    rootCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_ROOTS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_ROOTS));
            }
            String handle = null;
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            int index = 0;
            while (index < rootCount) {
                String attribute = "element" + (index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                    if (element == null || !element.exists() || element.getElementType() != 3) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fPackageFragmentRoots = elements.toArray(new IPackageFragmentRoot[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull((Object)javaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(javaElement instanceof IJavaProject)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2writable);
            }
            if (ReorgUtilsCore.isPackageFragmentRoot(javaElement.getJavaProject())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2nosrc);
            }
            return new RefactoringStatus();
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            if (!(resource instanceof IContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (resource.getType() == 8) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtilsCore.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.fPackageFragmentRoots;
            int n = this.fPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IResource fragmentRootResource = root.getResource();
                if (fragmentRootResource.equals((Object)resource) || ParentChecker.isDescendantOf(resource, fragmentRootResource)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        protected boolean containsLinkedResources() {
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.fPackageFragmentRoots;
            int n = this.fPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getResource().isLinked()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static abstract class PackagesReorgPolicy
    extends ReorgPolicy {
        private IPackageFragment[] fPackageFragments;

        public PackagesReorgPolicy(IPackageFragment[] packageFragments) {
            this.fPackageFragments = packageFragments;
        }

        @Override
        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canElementBeDestination(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 2: {
                    return true;
                }
                case 3: {
                    try {
                        return ((IPackageFragmentRoot)javaElement).getKind() != 2;
                    }
                    catch (JavaModelException javaModelException) {
                        return false;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            if (this.fPackageFragments.length == 0) {
                return false;
            }
            IPackageFragment[] iPackageFragmentArray = this.fPackageFragments;
            int n = this.fPackageFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pack = iPackageFragmentArray[n2];
                if (JavaElementUtil.isDefaultPackage(pack) || pack.isReadOnly()) {
                    return false;
                }
                ++n2;
            }
            return !ReorgUtilsCore.containsLinkedResources((IJavaElement[])this.fPackageFragments);
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            this.confirmOverwriting(reorgQueries);
            RefactoringStatus refactoringStatus = super.checkFinalConditions(pm, context, reorgQueries);
            return refactoringStatus;
        }

        private void confirmOverwriting(IReorgQueries reorgQueries) throws JavaModelException {
            OverwriteHelper helper = new OverwriteHelper();
            helper.setPackages(this.fPackageFragments);
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot();
            if (destRoot == null) {
                helper.confirmOverwriting(reorgQueries, this.getResourceDestination());
            } else {
                helper.confirmOverwriting(reorgQueries, destRoot);
            }
            this.fPackageFragments = helper.getPackagesWithoutUnconfirmedOnes();
        }

        protected abstract JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment var1, Map<String, String> var2, String var3, String var4, int var5);

        @Override
        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fPackageFragments.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = length == 1 ? Messages.format(this.getHeaderPatternSingular(), new String[]{this.fPackageFragments[0].getElementName(), this.getDestinationLabel()}) : Messages.format(this.getHeaderPatternPlural(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS, Integer.toString(this.fPackageFragments.length));
            int offset = 0;
            while (offset < this.fPackageFragments.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fPackageFragments[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            JavaRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        protected IPackageFragmentRoot getDestinationAsPackageFragmentRoot() throws JavaModelException {
            return this.getDestinationAsPackageFragmentRoot(this.getJavaElementDestination());
        }

        private IPackageFragmentRoot getDestinationAsPackageFragmentRoot(IJavaElement javaElement) throws JavaModelException {
            IPackageFragment pack;
            if (javaElement == null) {
                return null;
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)javaElement;
            }
            if (javaElement instanceof IPackageFragment && (pack = (IPackageFragment)javaElement).getParent() instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)pack.getParent();
            }
            if (javaElement instanceof IJavaProject) {
                return ReorgUtilsCore.getCorrespondingPackageFragmentRoot((IJavaProject)javaElement);
            }
            return null;
        }

        @Override
        public IJavaElement[] getJavaElements() {
            return this.fPackageFragments;
        }

        protected IPackageFragment[] getPackages() {
            return this.fPackageFragments;
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        private IProject getSingleProject() {
            IProject result = null;
            IPackageFragment[] iPackageFragmentArray = this.fPackageFragments;
            int n = this.fPackageFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pack = iPackageFragmentArray[n2];
                if (result == null) {
                    result = pack.getJavaProject().getProject();
                } else if (!result.equals((Object)pack.getJavaProject().getProject())) {
                    return null;
                }
                ++n2;
            }
            return result;
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            RefactoringStatus status = new RefactoringStatus();
            int fragmentCount = 0;
            String value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS);
            if (value != null && !"".equals(value)) {
                try {
                    fragmentCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS));
            }
            String handle = null;
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            int index = 0;
            while (index < fragmentCount) {
                String attribute = "element" + (index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                    if (element == null || !element.exists() || element.getElementType() != 4) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fPackageFragments = elements.toArray(new IPackageFragment[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull((Object)javaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot(javaElement);
            if (!ReorgUtilsCore.isSourceFolder((IJavaElement)destRoot)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
            }
            return new RefactoringStatus();
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            if (!(resource instanceof IContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (resource.getType() == 8) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtilsCore.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            IPackageFragment[] iPackageFragmentArray = this.fPackageFragments;
            int n = this.fPackageFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pack = iPackageFragmentArray[n2];
                IFolder folder = (IFolder)pack.getResource();
                if (folder.equals((Object)resource) || ParentChecker.isDescendantOf(resource, (IResource)folder)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        protected boolean containsLinkedResources() {
            IPackageFragment[] iPackageFragmentArray = this.fPackageFragments;
            int n = this.fPackageFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pack = iPackageFragmentArray[n2];
                if (pack.getResource().isLinked()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static abstract class ReorgPolicy
    implements IReorgPolicy {
        private static final String ATTRIBUTE_DESTINATION = "destination";
        private static final String ATTRIBUTE_TARGET = "target";
        protected boolean fCheckDestination = true;
        private IReorgDestination fDestination;

        private ReorgPolicy() {
        }

        @Override
        public boolean canChildrenBeDestinations(IReorgDestination destination) {
            if (destination instanceof ReorgDestinationFactory.JavaElementDestination) {
                return this.canChildrenBeDestinations(((ReorgDestinationFactory.JavaElementDestination)destination).getJavaElement());
            }
            if (destination instanceof ReorgDestinationFactory.ResourceDestination) {
                return this.canChildrenBeDestinations(((ReorgDestinationFactory.ResourceDestination)destination).getResource());
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return true;
        }

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            return true;
        }

        @Override
        public boolean canElementBeDestination(IReorgDestination destination) {
            if (destination instanceof ReorgDestinationFactory.JavaElementDestination) {
                return this.canElementBeDestination(((ReorgDestinationFactory.JavaElementDestination)destination).getJavaElement());
            }
            if (destination instanceof ReorgDestinationFactory.ResourceDestination) {
                return this.canElementBeDestination(((ReorgDestinationFactory.ResourceDestination)destination).getResource());
            }
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return true;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            return true;
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            IJavaElement[] javaElements;
            IResource[] resources;
            IResource[] iResourceArray = resources = this.getResources();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (!resource.exists() || resource.isPhantom() || !resource.isAccessible()) {
                    return false;
                }
                ++n2;
            }
            IJavaElement[] iJavaElementArray = javaElements = this.getJavaElements();
            int n3 = javaElements.length;
            n = 0;
            while (n < n3) {
                IJavaElement element = iJavaElementArray[n];
                if (!element.exists()) {
                    return false;
                }
                ++n;
            }
            return resources.length > 0 || javaElements.length > 0;
        }

        @Override
        public int getSaveMode() {
            return 2;
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            Assert.isNotNull((Object)reorgQueries);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            RefactoringModifications modifications = this.getModifications();
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            IFile[] iFileArray = this.getAllModifiedFiles();
            int n = iFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                deltaFactory.change(file);
                ++n2;
            }
            if (modifications != null) {
                modifications.buildDelta(deltaFactory);
                modifications.buildValidateEdits((ValidateEditChecker)context.getChecker(ValidateEditChecker.class));
            }
            return new RefactoringStatus();
        }

        protected IFile[] getAllModifiedFiles() {
            return new IFile[0];
        }

        protected abstract String getDescriptionPlural();

        protected abstract String getDescriptionSingular();

        protected String getDestinationLabel() {
            IJavaElement destination = this.getJavaElementDestination();
            if (destination == null) {
                destination = this.getResourceDestination();
            }
            return JavaElementLabelsCore.getTextLabel(destination, 2235681801344L);
        }

        protected abstract String getHeaderPatternSingular();

        protected abstract String getHeaderPatternPlural();

        @Override
        public final IJavaElement getJavaElementDestination() {
            if (!(this.fDestination instanceof ReorgDestinationFactory.JavaElementDestination)) {
                return null;
            }
            ReorgDestinationFactory.JavaElementDestination javaElementDestination = (ReorgDestinationFactory.JavaElementDestination)this.fDestination;
            return javaElementDestination.getJavaElement();
        }

        public final int getLocation() {
            return this.fDestination.getLocation();
        }

        protected RefactoringModifications getModifications() throws CoreException {
            return null;
        }

        protected abstract String getProcessorId();

        protected Map<String, String> getRefactoringArguments(String project) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            IJavaElement element = this.getJavaElementDestination();
            if (element != null) {
                arguments.put(ATTRIBUTE_DESTINATION, JavaRefactoringDescriptorUtil.elementToHandle(project, element));
            } else {
                IResource resource = this.getResourceDestination();
                if (resource != null) {
                    arguments.put(ATTRIBUTE_TARGET, JavaRefactoringDescriptorUtil.resourceToHandle(null, resource));
                }
            }
            return arguments;
        }

        protected abstract String getRefactoringId();

        @Override
        public final IResource getResourceDestination() {
            if (!(this.fDestination instanceof ReorgDestinationFactory.ResourceDestination)) {
                return null;
            }
            ReorgDestinationFactory.ResourceDestination resourceDestination = (ReorgDestinationFactory.ResourceDestination)this.fDestination;
            return resourceDestination.getResource();
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            String handle = arguments.getAttribute(ATTRIBUTE_DESTINATION);
            if (handle != null) {
                IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                if (element != null) {
                    if (this.fCheckDestination && !element.exists()) {
                        return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorId(), this.getRefactoringId());
                    }
                    try {
                        IReorgDestination destination = ReorgDestinationFactory.createDestination(element);
                        this.setDestination(destination);
                        return this.verifyDestination(destination);
                    }
                    catch (JavaModelException exception) {
                        JavaManipulationPlugin.log(exception);
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{handle, "input"}));
                    }
                }
                IResource resource = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), handle);
                if (resource == null || this.fCheckDestination && !resource.exists()) {
                    return JavaRefactoringDescriptorUtil.createInputFatalStatus(resource, this.getProcessorId(), this.getRefactoringId());
                }
                try {
                    IReorgDestination destination = ReorgDestinationFactory.createDestination(resource);
                    this.setDestination(destination);
                    return this.verifyDestination(destination);
                }
                catch (JavaModelException exception) {
                    JavaManipulationPlugin.log(exception);
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{handle, "input"}));
                }
            }
            handle = arguments.getAttribute(ATTRIBUTE_TARGET);
            if (handle != null) {
                IResource resource = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), handle);
                if (resource == null || this.fCheckDestination && !resource.exists()) {
                    return JavaRefactoringDescriptorUtil.createInputFatalStatus(resource, this.getProcessorId(), this.getRefactoringId());
                }
                try {
                    IReorgDestination destination = ReorgDestinationFactory.createDestination(resource);
                    this.setDestination(destination);
                    return this.verifyDestination(destination);
                }
                catch (JavaModelException exception) {
                    JavaManipulationPlugin.log(exception);
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{handle, "input"}));
                }
            }
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }

        @Override
        public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor processor, String[] natures, SharableParticipants shared) throws CoreException {
            RefactoringModifications modifications = this.getModifications();
            if (modifications != null) {
                return modifications.loadParticipants(status, processor, natures, shared);
            }
            return new RefactoringParticipant[0];
        }

        @Override
        public final void setDestination(IReorgDestination destination) {
            this.fDestination = destination;
        }

        @Override
        public RefactoringStatus verifyDestination(IReorgDestination destination) throws JavaModelException {
            if (destination instanceof ReorgDestinationFactory.JavaElementDestination) {
                return this.verifyDestination(((ReorgDestinationFactory.JavaElementDestination)destination).getJavaElement());
            }
            if (destination instanceof ReorgDestinationFactory.ResourceDestination) {
                return this.verifyDestination(((ReorgDestinationFactory.ResourceDestination)destination).getResource());
            }
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_invalidDestinationKind);
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_no_java_element);
        }

        protected RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_no_resource);
        }
    }

    private static abstract class SubCuElementReorgPolicy
    extends ReorgPolicy {
        private IJavaElement[] fJavaElements;

        protected static CompilationUnitChange createCompilationUnitChange(CompilationUnitRewrite rewrite) throws CoreException {
            CompilationUnitChange change = rewrite.createChange(true);
            if (change != null) {
                change.setSaveMode(1);
            }
            return change;
        }

        protected static final ICompilationUnit getEnclosingCompilationUnit(IJavaElement element) {
            if (element instanceof ICompilationUnit) {
                return (ICompilationUnit)element;
            }
            return (ICompilationUnit)element.getAncestor(5);
        }

        private static IType getEnclosingType(IJavaElement element) {
            if (element instanceof IType) {
                return (IType)element;
            }
            return (IType)element.getAncestor(7);
        }

        private static String getUnindentedSource(ISourceReference sourceReference) throws JavaModelException {
            String[] lines = Strings.convertIntoLines(sourceReference.getSource());
            IJavaProject project = ((IJavaElement)sourceReference).getJavaProject();
            Strings.trimIndentation(lines, project, false);
            return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)sourceReference));
        }

        SubCuElementReorgPolicy(IJavaElement[] javaElements) {
            this.fJavaElements = javaElements;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        @Override
        public boolean canElementBeDestination(IJavaElement javaElement) {
            return true;
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable() || this.fJavaElements.length == 0) {
                return false;
            }
            IJavaElement[] iJavaElementArray = this.fJavaElements;
            int n = this.fJavaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IMember member;
                IJavaElement javaElement = iJavaElementArray[n2];
                if (javaElement instanceof IMember && (member = (IMember)javaElement).isBinary() && member.getSourceRange() == null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public int getSaveMode() {
            return 4;
        }

        private void copyImportsToDestination(IImportContainer container, ASTRewrite rewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)destinationCuNode, CompilationUnit.IMPORTS_PROPERTY);
            IJavaElement[] iJavaElementArray = container.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement importDeclaration = iJavaElementArray[n2];
                IImportDeclaration declaration = (IImportDeclaration)importDeclaration;
                ImportDeclaration sourceNode = ASTNodeSearchUtil.getImportDeclarationNode(declaration, sourceCuNode);
                ImportDeclaration copiedNode = (ImportDeclaration)ASTNode.copySubtree((AST)rewrite.getAST(), (ASTNode)sourceNode);
                if (this.getLocation() == 1) {
                    listRewrite.insertFirst((ASTNode)copiedNode, null);
                } else {
                    listRewrite.insertLast((ASTNode)copiedNode, null);
                }
                ++n2;
            }
        }

        private void copyImportToDestination(IImportDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            ImportDeclaration sourceNode = ASTNodeSearchUtil.getImportDeclarationNode(declaration, sourceCuNode);
            ImportDeclaration copiedNode = (ImportDeclaration)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)sourceNode);
            ListRewrite listRewrite = targetRewrite.getListRewrite((ASTNode)destinationCuNode, CompilationUnit.IMPORTS_PROPERTY);
            if (this.getJavaElementDestination() instanceof IImportDeclaration) {
                ImportDeclaration destinationNode = ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)this.getJavaElementDestination(), destinationCuNode);
                this.insertRelative((ASTNode)copiedNode, (ASTNode)destinationNode, listRewrite);
            } else {
                listRewrite.insertLast((ASTNode)copiedNode, null);
            }
        }

        private void copyInitializerToDestination(IInitializer initializer, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            BodyDeclaration newInitializer = (BodyDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)initializer), 28);
            this.copyMemberToDestination((IMember)initializer, targetRewriter, sourceCuNode, targetCuNode, newInitializer);
        }

        private void copyMemberToDestination(IMember member, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode, BodyDeclaration newMember) throws JavaModelException {
            ListRewrite listRewrite;
            IJavaElement javaElementDestination = this.getJavaElementDestination();
            ASTNode nodeDestination = this.getDestinationNode(javaElementDestination, targetCuNode);
            ASTNode destinationContainer = this.getLocation() == 3 && (javaElementDestination instanceof IType || javaElementDestination instanceof ICompilationUnit) ? nodeDestination : nodeDestination.getParent();
            if (destinationContainer instanceof AbstractTypeDeclaration) {
                listRewrite = newMember instanceof EnumConstantDeclaration && destinationContainer instanceof EnumDeclaration ? targetRewriter.getASTRewrite().getListRewrite(destinationContainer, EnumDeclaration.ENUM_CONSTANTS_PROPERTY) : targetRewriter.getASTRewrite().getListRewrite(destinationContainer, ((AbstractTypeDeclaration)destinationContainer).getBodyDeclarationsProperty());
            } else if (destinationContainer instanceof CompilationUnit) {
                listRewrite = targetRewriter.getASTRewrite().getListRewrite(destinationContainer, CompilationUnit.TYPES_PROPERTY);
            } else if (destinationContainer instanceof Block) {
                listRewrite = targetRewriter.getASTRewrite().getListRewrite(destinationContainer, Block.STATEMENTS_PROPERTY);
            } else if (destinationContainer instanceof SwitchStatement) {
                listRewrite = targetRewriter.getASTRewrite().getListRewrite(destinationContainer, SwitchStatement.STATEMENTS_PROPERTY);
            } else if (destinationContainer instanceof AnonymousClassDeclaration) {
                listRewrite = targetRewriter.getASTRewrite().getListRewrite(destinationContainer, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            } else {
                listRewrite = null;
                Assert.isLegal((boolean)false);
            }
            if (this.getLocation() == 3) {
                listRewrite.insertAt((ASTNode)newMember, BodyDeclarationRewrite.getInsertionIndex(newMember, listRewrite.getRewrittenList()), null);
            } else {
                this.insertRelative((ASTNode)newMember, nodeDestination, listRewrite);
            }
            Object decl = null;
            decl = member instanceof IInitializer ? ASTNodeSearchUtil.getInitializerNode((IInitializer)member, sourceCuNode) : ASTNodeSearchUtil.getBodyDeclarationNode(member, sourceCuNode);
            if (decl != null) {
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(destinationContainer, targetRewriter.getImportRewrite());
                ImportRewriteUtil.addImports(targetRewriter, context, (ASTNode)decl, new HashMap<Name, String>(), new HashMap<Name, String>(), false);
            }
        }

        private ASTNode getDestinationNode(IJavaElement destination, CompilationUnit target) throws JavaModelException {
            switch (destination.getElementType()) {
                case 10: {
                    return ASTNodeSearchUtil.getInitializerNode((IInitializer)destination, target);
                }
                case 8: {
                    return ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration((IField)destination, target);
                }
                case 9: {
                    return ASTNodeSearchUtil.getMethodOrAnnotationTypeMemberDeclarationNode((IMethod)destination, target);
                }
                case 7: {
                    IType typeDestination = (IType)destination;
                    if (typeDestination.isAnonymous()) {
                        return ASTNodeSearchUtil.getClassInstanceCreationNode(typeDestination, target).getAnonymousClassDeclaration();
                    }
                    return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(typeDestination, target);
                }
                case 5: {
                    IType mainType = JavaElementUtil.getMainType((ICompilationUnit)destination);
                    if (mainType == null) break;
                    return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(mainType, target);
                }
            }
            return null;
        }

        private void insertRelative(ASTNode newNode, ASTNode relativeNode, ListRewrite listRewrite) {
            List list = listRewrite.getOriginalList();
            int index = list.indexOf(relativeNode);
            if (this.getLocation() == 1) {
                listRewrite.insertBefore(newNode, (ASTNode)list.get(index), null);
            } else if (index + 1 < list.size()) {
                listRewrite.insertBefore(newNode, (ASTNode)list.get(index + 1), null);
            } else {
                listRewrite.insertLast(newNode, null);
            }
        }

        private void copyMethodToDestination(IMethod method, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            MethodDeclaration newMethod = (MethodDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)method), 31);
            newMethod.setConstructor(method.isConstructor());
            this.copyMemberToDestination((IMember)method, targetRewriter, sourceCuNode, targetCuNode, (BodyDeclaration)newMethod);
        }

        private void copyPackageDeclarationToDestination(IPackageDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            if (destinationCuNode.getPackage() != null) {
                return;
            }
            PackageDeclaration sourceNode = ASTNodeSearchUtil.getPackageDeclarationNode(declaration, sourceCuNode);
            PackageDeclaration copiedNode = (PackageDeclaration)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)sourceNode);
            targetRewrite.set((ASTNode)destinationCuNode, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)copiedNode, null);
        }

        protected void copyToDestination(IJavaElement element, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws CoreException {
            ASTRewrite rewrite = targetRewriter.getASTRewrite();
            switch (element.getElementType()) {
                case 8: {
                    this.copyMemberToDestination((IMember)element, targetRewriter, sourceCuNode, targetCuNode, this.createNewFieldDeclarationNode((IField)element, rewrite, sourceCuNode));
                    break;
                }
                case 12: {
                    this.copyImportsToDestination((IImportContainer)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 13: {
                    this.copyImportToDestination((IImportDeclaration)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 10: {
                    this.copyInitializerToDestination((IInitializer)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                case 9: {
                    this.copyMethodToDestination((IMethod)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                case 11: {
                    this.copyPackageDeclarationToDestination((IPackageDeclaration)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 7: {
                    this.copyTypeToDestination((IType)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                }
            }
        }

        private void copyTypeToDestination(IType type, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            AbstractTypeDeclaration newType = (AbstractTypeDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)type), 55);
            IType enclosingType = SubCuElementReorgPolicy.getEnclosingType(this.getJavaElementDestination());
            if (enclosingType != null) {
                this.copyMemberToDestination((IMember)type, targetRewriter, sourceCuNode, targetCuNode, (BodyDeclaration)newType);
            } else {
                targetRewriter.getASTRewrite().getListRewrite((ASTNode)targetCuNode, CompilationUnit.TYPES_PROPERTY).insertLast((ASTNode)newType, null);
            }
        }

        private BodyDeclaration createNewFieldDeclarationNode(IField field, ASTRewrite rewrite, CompilationUnit sourceCuNode) throws CoreException {
            AST targetAst = rewrite.getAST();
            FieldDeclaration newDeclaration = null;
            BodyDeclaration bodyDeclaration = ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration(field, sourceCuNode);
            if (bodyDeclaration instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                if (fieldDeclaration.fragments().size() == 1) {
                    return (FieldDeclaration)rewrite.createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)field), 23);
                }
                VariableDeclarationFragment originalFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, sourceCuNode);
                VariableDeclarationFragment copiedFragment = (VariableDeclarationFragment)ASTNode.copySubtree((AST)targetAst, (ASTNode)originalFragment);
                newDeclaration = targetAst.newFieldDeclaration(copiedFragment);
                newDeclaration.setType((Type)ASTNode.copySubtree((AST)targetAst, (ASTNode)fieldDeclaration.getType()));
            } else if (bodyDeclaration instanceof EnumConstantDeclaration) {
                String content;
                EnumConstantDeclaration constantDeclaration = (EnumConstantDeclaration)bodyDeclaration;
                EnumConstantDeclaration newConstDeclaration = targetAst.newEnumConstantDeclaration();
                newConstDeclaration.setName((SimpleName)ASTNode.copySubtree((AST)targetAst, (ASTNode)constantDeclaration.getName()));
                AnonymousClassDeclaration anonymousDeclaration = constantDeclaration.getAnonymousClassDeclaration();
                if (anonymousDeclaration != null && (content = ASTNodes.getNodeSource((ASTNode)anonymousDeclaration, false, true)) != null) {
                    newConstDeclaration.setAnonymousClassDeclaration((AnonymousClassDeclaration)rewrite.createStringPlaceholder(content, 1));
                }
                newDeclaration = newConstDeclaration;
            } else {
                Assert.isTrue((boolean)false);
            }
            if (newDeclaration != null) {
                String content;
                newDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(targetAst, bodyDeclaration.getModifiers()));
                Javadoc javadoc = bodyDeclaration.getJavadoc();
                if (javadoc != null && (content = ASTNodes.getNodeSource((ASTNode)javadoc, false, true)) != null) {
                    newDeclaration.setJavadoc((Javadoc)rewrite.createStringPlaceholder(content, 29));
                }
            }
            return newDeclaration;
        }

        protected abstract JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment var1, Map<String, String> var2, String var3, String var4, int var5);

        @Override
        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fJavaElements.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = length == 1 ? Messages.format(this.getHeaderPatternSingular(), new String[]{JavaElementLabelsCore.getTextLabel(this.fJavaElements[0].getElementName(), 2235681801344L), this.getDestinationLabel()}) : Messages.format(this.getHeaderPatternPlural(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_MEMBERS, Integer.toString(this.fJavaElements.length));
            int offset = 0;
            while (offset < this.fJavaElements.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, this.fJavaElements[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            JavaRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        @Override
        public final IJavaElement[] getJavaElements() {
            return this.fJavaElements;
        }

        @Override
        public final IResource[] getResources() {
            return new IResource[0];
        }

        private IProject getSingleProject() {
            IProject result = null;
            IJavaElement[] iJavaElementArray = this.fJavaElements;
            int n = this.fJavaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement javaElement = iJavaElementArray[n2];
                if (result == null) {
                    result = javaElement.getJavaProject().getProject();
                } else if (!result.equals((Object)javaElement.getJavaProject().getProject())) {
                    return null;
                }
                ++n2;
            }
            return result;
        }

        protected final ICompilationUnit getSourceCu() {
            return SubCuElementReorgPolicy.getEnclosingCompilationUnit(this.fJavaElements[0]);
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            RefactoringStatus status = new RefactoringStatus();
            int memberCount = 0;
            String value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_MEMBERS);
            if (value != null && !"".equals(value)) {
                try {
                    memberCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_MEMBERS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_MEMBERS));
            }
            String handle = null;
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            int index = 0;
            while (index < memberCount) {
                String attribute = "element" + (index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fJavaElements = elements.toArray(new IJavaElement[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination, int location) throws JavaModelException {
            Assert.isNotNull((Object)destination);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!destination.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist1);
            }
            if (destination instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(destination instanceof ICompilationUnit) && !ReorgUtilsCore.isInsideCompilationUnit(destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            ICompilationUnit destinationCu = SubCuElementReorgPolicy.getEnclosingCompilationUnit(destination);
            Assert.isNotNull((Object)destinationCu);
            if (destinationCu.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_modify);
            }
            switch (destination.getElementType()) {
                case 5: {
                    if (location != 3) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    int[] types0 = new int[]{7, 11, 12, 13};
                    if (ReorgUtilsCore.hasOnlyElementsOfType(this.getJavaElements(), types0) || JavaElementUtil.getMainType(destinationCu) != null && ReorgUtilsCore.hasOnlyElementsOfType(this.getJavaElements(), new int[]{8, 10, 9, 7})) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 11: {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package_decl);
                }
                case 12: {
                    if (!(location == 3 ? ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 13) : ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 12))) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 13: {
                    if (location == 3) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    if (!ReorgUtilsCore.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 8: 
                case 9: 
                case 10: {
                    if (location == 3) {
                        if (this.getJavaElements().length != 1) {
                            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                        }
                        if (destination.equals(this.getJavaElements()[0])) break;
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    int[] types = new int[]{8, 10, 9, 7};
                    if (ReorgUtilsCore.hasOnlyElementsOfType(this.getJavaElements(), types)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 7: {
                    if (location == 3) {
                        int[] types1 = new int[]{8, 10, 9, 7};
                        if (ReorgUtilsCore.hasOnlyElementsOfType(this.getJavaElements(), types1)) break;
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    if (destination.getParent() instanceof IMethod) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    int[] types = new int[]{8, 10, 9, 7};
                    if (ReorgUtilsCore.hasOnlyElementsOfType(this.getJavaElements(), types)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
            }
            return new RefactoringStatus();
        }

        @Override
        public RefactoringStatus verifyDestination(IReorgDestination destination) throws JavaModelException {
            if (!(destination instanceof ReorgDestinationFactory.JavaElementDestination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_invalidDestinationKind);
            }
            ReorgDestinationFactory.JavaElementDestination javaElementDestination = (ReorgDestinationFactory.JavaElementDestination)destination;
            return this.verifyDestination(javaElementDestination.getJavaElement(), javaElementDestination.getLocation());
        }
    }
}

