/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.VarDefinitionsUsesVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class TryWithResourceFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public TryWithResourceFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static ICleanUpFixCore createCleanUp(CompilationUnit unit) {
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(Block visited) {
                DeclarationAndTryVisitor declarationAndTryVisitor = new DeclarationAndTryVisitor(visited, rewriteOperations);
                visited.accept((ASTVisitor)declarationAndTryVisitor);
                return declarationAndTryVisitor.result;
            }

            final class DeclarationAndTryVisitor
            extends ASTVisitor {
                private final Block startNode;
                private boolean result = true;
                private final /* synthetic */ List val$rewriteOperations;

                public DeclarationAndTryVisitor(Block startNode, List list) {
                    this.val$rewriteOperations = list;
                    this.startNode = startNode;
                }

                public boolean visit(Block visited) {
                    return this.startNode == visited;
                }

                public boolean visit(TryStatement visited) {
                    if (!this.result) {
                        return true;
                    }
                    VariableDeclarationStatement previousDeclarationStatement = ASTNodes.as(ASTNodes.getPreviousSibling((Statement)visited), VariableDeclarationStatement.class);
                    List<Statement> finallyStatements = ASTNodes.asList((Statement)visited.getFinally());
                    if (previousDeclarationStatement == null || finallyStatements.isEmpty()) {
                        return true;
                    }
                    VariableDeclarationFragment previousDeclarationFragment = ASTNodes.getUniqueFragment((Statement)previousDeclarationStatement);
                    if (previousDeclarationFragment == null || previousDeclarationFragment.resolveBinding() == null) {
                        return true;
                    }
                    Statement finallyFirstFStatement = finallyStatements.get(0);
                    ArrayList<ASTNode> nodesToRemove = new ArrayList<ASTNode>();
                    nodesToRemove.add((ASTNode)(finallyStatements.size() == 1 ? visited.getFinally() : finallyFirstFStatement));
                    boolean isCloseableUsedAfter = this.isCloseableUsedAfter(previousDeclarationFragment, visited);
                    Expression closedVariable = this.getClosedVariable(previousDeclarationFragment, finallyFirstFStatement);
                    if (isCloseableUsedAfter && !JavaModelUtil.is9OrHigher(((CompilationUnit)visited.getRoot()).getJavaElement().getJavaProject()) || closedVariable == null || !ASTNodes.areSameVariables((ASTNode)previousDeclarationFragment, new ASTNode[]{closedVariable})) {
                        return true;
                    }
                    return this.maybeUseTryWithResource(visited, previousDeclarationStatement, previousDeclarationFragment, isCloseableUsedAfter, nodesToRemove);
                }

                private boolean maybeUseTryWithResource(TryStatement visited, VariableDeclarationStatement previousDeclarationStatement, VariableDeclarationFragment previousDeclarationFragment, boolean isCloseableUsedAfter, List<ASTNode> nodesToRemove) {
                    Statement tryFirstStatement;
                    Assignment assignResource;
                    VarDefinitionsUsesVisitor visitor = new VarDefinitionsUsesVisitor((VariableDeclaration)previousDeclarationFragment);
                    List<SimpleName> closeableAssignments = visitor.getWrites();
                    List<Statement> tryStatements = ASTNodes.asList((Statement)visited.getBody());
                    if (!isCloseableUsedAfter && !tryStatements.isEmpty() && (assignResource = ASTNodes.asExpression(tryFirstStatement = tryStatements.get(0), Assignment.class)) != null && ASTNodes.isSameVariable((ASTNode)previousDeclarationFragment, (ASTNode)assignResource.getLeftHandSide())) {
                        if (!this.containsExactly(closeableAssignments, new Expression[]{previousDeclarationFragment.getName(), assignResource.getLeftHandSide()})) {
                            return true;
                        }
                        nodesToRemove.add((ASTNode)tryFirstStatement);
                        this.val$rewriteOperations.add(new TryWithResourceOperation(visited, previousDeclarationStatement, previousDeclarationFragment, assignResource, nodesToRemove));
                        this.result = false;
                        return false;
                    }
                    if (this.containsExactly(closeableAssignments, new Expression[]{previousDeclarationFragment.getName()})) {
                        this.val$rewriteOperations.add(new TryWithResourceOperation(visited, previousDeclarationStatement, previousDeclarationFragment, null, nodesToRemove));
                        this.result = false;
                        return false;
                    }
                    return true;
                }

                private boolean containsExactly(List<SimpleName> closeableOccurrences, Expression ... simpleNames) {
                    return closeableOccurrences.size() == simpleNames.length && closeableOccurrences.containsAll(Arrays.asList(simpleNames));
                }

                private boolean isCloseableUsedAfter(VariableDeclarationFragment previousDeclarationFragment, TryStatement visited) {
                    IVariableBinding varBinding = previousDeclarationFragment.resolveBinding();
                    List<Statement> nextStatements = ASTNodes.getNextSiblings((Statement)visited);
                    for (Statement nextStatement : nextStatements) {
                        VarDefinitionsUsesVisitor visitor = new VarDefinitionsUsesVisitor(varBinding, (ASTNode)nextStatement, true);
                        if (visitor.getReads().isEmpty() && visitor.getWrites().isEmpty()) continue;
                        return true;
                    }
                    return false;
                }

                private Expression getClosedVariable(VariableDeclarationFragment previousDeclarationFragment, Statement finallyStatement) {
                    MethodInvocation closeMethod;
                    Expression closedVariable;
                    Statement firstStatement = finallyStatement;
                    IfStatement finallyIfStatement = ASTNodes.as(finallyStatement, IfStatement.class);
                    if (finallyIfStatement != null && ASTNodes.asList(finallyIfStatement.getThenStatement()).size() == 1 && ASTNodes.asList(finallyIfStatement.getElseStatement()).isEmpty() && ASTNodes.areSameVariables((ASTNode)previousDeclarationFragment, new ASTNode[]{closedVariable = ASTNodes.getNullCheckedExpression(finallyIfStatement.getExpression())})) {
                        firstStatement = ASTNodes.asList(finallyIfStatement.getThenStatement()).get(0);
                    }
                    if ((closeMethod = ASTNodes.asExpression(firstStatement, MethodInvocation.class)) != null && ASTNodes.usesGivenSignature(closeMethod, Closeable.class.getCanonicalName(), "close", new String[0])) {
                        return closeMethod.getExpression();
                    }
                    return null;
                }
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.TryWithResourceCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    private static class TryWithResourceOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final TryStatement visited;
        private final VariableDeclarationStatement previousDeclStatement;
        private final VariableDeclarationFragment previousDeclFragment;
        private final Assignment assignResource;
        private final List<ASTNode> nodesToRemove;

        public TryWithResourceOperation(TryStatement visited, VariableDeclarationStatement previousDeclStatement, VariableDeclarationFragment previousDeclFragment, Assignment assignResource, List<ASTNode> nodesToRemove) {
            this.visited = visited;
            this.previousDeclStatement = previousDeclStatement;
            this.previousDeclFragment = previousDeclFragment;
            this.assignResource = assignResource;
            this.nodesToRemove = nodesToRemove;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            Expression newResource;
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.TryWithResourceCleanup_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
                    if (Boolean.TRUE.equals(node.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(node.getStartPosition(), node.getLength());
                    }
                    return super.computeSourceRange(node);
                }
            });
            if (JavaModelUtil.is9OrHigher(((CompilationUnit)this.visited.getRoot()).getJavaElement().getJavaProject()) && this.assignResource == null) {
                newResource = (Expression)rewrite.createCopyTarget((ASTNode)this.previousDeclFragment.getName());
            } else {
                VariableDeclarationFragment newFragment;
                if (this.assignResource != null) {
                    newFragment = ast.newVariableDeclarationFragment();
                    newFragment.setName(ASTNodes.createMoveTarget(rewrite, this.previousDeclFragment.getName()));
                    newFragment.setInitializer(ASTNodes.createMoveTarget(rewrite, this.assignResource.getRightHandSide()));
                } else {
                    newFragment = ASTNodes.createMoveTarget(rewrite, this.previousDeclFragment);
                }
                VariableDeclarationExpression newResourceDeclaration = ast.newVariableDeclarationExpression(newFragment);
                newResourceDeclaration.setType(ASTNodes.createMoveTarget(rewrite, this.previousDeclStatement.getType()));
                newResource = newResourceDeclaration;
                ASTNodes.removeButKeepComment(rewrite, (ASTNode)this.previousDeclStatement, group);
            }
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)this.visited, TryStatement.RESOURCES2_PROPERTY);
            listRewrite.insertFirst((ASTNode)newResource, group);
            for (ASTNode nodeToRemove : this.nodesToRemove) {
                ASTNodes.removeButKeepComment(rewrite, nodeToRemove, group);
            }
        }
    }
}

