/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.el.resolver;

import ee.jakarta.tck.pages.common.el.resolver.BarELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import java.util.Objects;

public class ResolverTest {
    private static final String NL = System.getProperty("line.separator", "\n");

    private ResolverTest() {
    }

    public static boolean testCompositeELResolver(ELContext elContext, CompositeELResolver compResolver, StringBuffer buf) {
        boolean pass = true;
        BarELResolver barResolver = new BarELResolver();
        try {
            compResolver.add((ELResolver)barResolver);
            buf.append("add() tested successfully" + NL);
        }
        catch (Exception e) {
            buf.append("add() method Test Failed");
            pass = false;
        }
        elContext.setPropertyResolved(false);
        compResolver.setValue(elContext, null, (Object)"Nothing", (Object)"rien");
        if (!elContext.isPropertyResolved()) {
            buf.append("setValue() tested successfully on non-existent property" + NL);
        } else {
            buf.append("setValue() set property resolved on non-existent property" + NL);
            pass = false;
        }
        elContext.setPropertyResolved(false);
        try {
            compResolver.setValue(elContext, null, (Object)"Bar", (Object)"rien");
            pass = false;
        }
        catch (PropertyNotWritableException pnwe) {
            buf.append("setValue() tested successfully on non-writable property" + NL);
            buf.append("PropertyNotWritableException caught as expected" + NL);
        }
        elContext.setPropertyResolved(false);
        String result = (String)compResolver.getValue(elContext, null, (Object)"Bar");
        if (!elContext.isPropertyResolved()) {
            buf.append("getValue() did not resolve" + NL);
            pass = false;
        } else if (!result.equals("Foo")) {
            buf.append("Invalid value from BarELResolver: " + result + NL);
            pass = false;
        } else {
            buf.append("getValue() tested successfully" + NL);
        }
        elContext.setPropertyResolved(false);
        Class type = compResolver.getType(elContext, null, (Object)"Bar");
        if (!elContext.isPropertyResolved()) {
            buf.append("getType() did not resolve" + NL);
            pass = false;
        } else if (type != null) {
            buf.append("getType() returns " + type.getName() + NL);
            buf.append("not expected result for non-writable property" + NL);
            pass = false;
        } else {
            buf.append("getType() returns null as expected for non-writable property" + NL);
        }
        elContext.setPropertyResolved(false);
        boolean nonWritable = compResolver.isReadOnly(elContext, null, (Object)"Bar");
        if (!elContext.isPropertyResolved()) {
            buf.append("isReadOnly() did not resolve" + NL);
            pass = false;
        } else if (!nonWritable) {
            buf.append("isReadOnly() did not return true" + NL);
            pass = false;
        } else {
            buf.append("isReadOnly() returns true as expected" + NL);
        }
        elContext.setPropertyResolved(false);
        Class commonPropertyType = compResolver.getCommonPropertyType(elContext, null);
        buf.append("getCommonPropertyType() returns ");
        buf.append(commonPropertyType.getName() + NL);
        return pass;
    }

    public static boolean testELResolver(ELContext elContext, ELResolver resolver, Object base, Object property, Object value, StringBuffer buf, boolean readOnly) {
        boolean pass = true;
        elContext.setPropertyResolved(false);
        try {
            resolver.setValue(elContext, base, property, value);
            if (readOnly) {
                buf.append("setValue() failed on non-writable property");
                pass = false;
            } else {
                buf.append("setValue() tested successfully on writable property" + NL);
            }
        }
        catch (PropertyNotWritableException pnwe) {
            if (readOnly) {
                buf.append("setValue() tested successfully on non-writable property" + NL);
                buf.append("PropertyNotWritableException caught as expected" + NL);
            }
            buf.append("setValue() failed on non-writable property" + NL);
            buf.append("Unexpected PropertyNotWritableException caught" + NL);
            pass = false;
        }
        elContext.setPropertyResolved(false);
        Object valueRetrieved = resolver.getValue(elContext, base, property);
        if (!elContext.isPropertyResolved()) {
            buf.append("getValue() did not resolve" + NL);
            pass = false;
        }
        if (!readOnly && !Objects.equals(valueRetrieved, value)) {
            if (valueRetrieved == null) {
                buf.append("null value returned from getValue() method call!" + NL);
                pass = false;
            } else {
                buf.append("Invalid value from getValue():" + NL);
                buf.append("Value expected: " + value.toString() + NL);
                buf.append("Value retrieved: " + valueRetrieved.toString() + NL);
                pass = false;
            }
        } else {
            buf.append("getValue() tested successfully" + NL);
            if (!readOnly) {
                buf.append("Value expected: " + value.toString() + NL);
                buf.append("Value retrieved: " + valueRetrieved.toString() + NL);
            }
        }
        elContext.setPropertyResolved(false);
        Class type = resolver.getType(elContext, base, property);
        if (!elContext.isPropertyResolved()) {
            buf.append("getType() did not resolve" + NL);
            pass = false;
        } else if (type != null) {
            buf.append("getType() returns " + type.getName() + NL);
            if (readOnly) {
                buf.append("result not expected!" + NL);
                pass = false;
            } else {
                buf.append("non-null as expected" + NL);
            }
        } else {
            buf.append("getType() returns null " + NL);
            if (!readOnly) {
                buf.append("result not expected!" + NL);
                pass = false;
            } else {
                buf.append("as expected" + NL);
            }
        }
        elContext.setPropertyResolved(false);
        boolean nonWritable = resolver.isReadOnly(elContext, base, property);
        if (!elContext.isPropertyResolved()) {
            buf.append("isReadOnly() did not resolve" + NL);
            pass = false;
        } else if (nonWritable != readOnly) {
            buf.append("isReadOnly() returned unexpected value: " + nonWritable + NL);
            pass = false;
        } else {
            buf.append("isReadOnly() returns " + readOnly + " as expected" + NL);
        }
        elContext.setPropertyResolved(false);
        Class commonPropertyType = resolver.getCommonPropertyType(elContext, base);
        buf.append("getCommonPropertyType() returns ");
        buf.append(commonPropertyType.getName() + NL);
        return pass;
    }

    public static boolean testELResolverInvoke(ELContext elContext, ELResolver resolver, Object beanName, Object methodName, Class<?>[] types, Object[] values, Boolean negTest, StringBuffer buf) {
        boolean pass = true;
        elContext.setPropertyResolved(false);
        try {
            Boolean nameMatch = (Boolean)resolver.invoke(elContext, beanName, methodName, (Class[])types, values);
            if (!nameMatch.booleanValue()) {
                buf.append("invoke() did not Run properly." + NL);
                pass = false;
            }
        }
        catch (MethodNotFoundException mnfe) {
            if (negTest.booleanValue()) {
                buf.append("Test Passed  invoke() threw MethodNotFoundException");
            } else {
                pass = false;
                mnfe.printStackTrace();
            }
        }
        catch (Exception e) {
            pass = false;
            e.printStackTrace();
        }
        return pass;
    }

    public static boolean testELResolverNPE(ELResolver resolver, Object base, Object property, Object value, StringBuffer buf) {
        boolean pass = true;
        try {
            resolver.getType(null, base, property);
            pass = false;
            buf.append("getType test failed with: " + NL + "EXPECTED: NullPointerException to be thrown " + NL + "RECEIVED: NO EXCEPTION THROWN AT ALL! " + NL);
        }
        catch (Exception e) {
            if (!(e instanceof NullPointerException)) {
                buf.append("getType test failed with: " + NL + "EXPECTED: NullPointerException to be thrown " + NL + "RECEIVED: " + e.toString() + NL);
                pass = false;
            }
            buf.append("getType() test Passed: throws NullPointerException as expected " + NL);
        }
        try {
            resolver.getValue(null, base, property);
            buf.append("Test Failed  getValue() did not throw any exception." + NL + "Expected: NullPointerException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof NullPointerException)) {
                buf.append("Test Failed  getValue() threw the wrong exception " + NL + "Expected: NullPointerException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  getValue() threw NullPointerException " + NL);
        }
        try {
            resolver.setValue(null, base, property, value);
            buf.append("Test Failed  setValue() did not throw any exception." + NL + "Expected: NullPointerException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof NullPointerException)) {
                buf.append("Test Failed  setValue() threw the wrong exception " + NL + "Expected: NullPointerException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  setValue() threw NullPointerException " + NL);
        }
        try {
            resolver.isReadOnly(null, base, property);
            buf.append("Test Failed  isReadOnly() did not throw any exception." + NL + "Expected: NullPointerException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof NullPointerException)) {
                buf.append("Test Failed  isReadOnly() threw the wrong exception " + NL + "Expected: NullPointerException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  isReadOnly() NullPointerException thrown " + NL);
        }
        return pass;
    }

    public static boolean testELResolverPNFE(ELContext elcontext, ELResolver resolver, Object base, Object property, StringBuffer buf) {
        boolean pass = true;
        try {
            resolver.getType(elcontext, base, property);
            buf.append("Test Failed  getType() did not throw any exception." + NL + "Expected: PropertyNotFoundException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof PropertyNotFoundException)) {
                buf.append("Test Failed  getType() threw the wrong exception " + NL + "Expected: PropertyNotFoundException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  getType() threw PropertyNotFoundException " + NL);
        }
        try {
            resolver.isReadOnly(elcontext, base, property);
            buf.append("Test Failed  isReadOnly() did not throw any exception." + NL + "Expected: PropertyNotFoundException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof PropertyNotFoundException)) {
                buf.append("Test Failed  isReadOnly() threw the wrong exception " + NL + "Expected: PropertyNotFoundException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  isReadOnly() threw PropertyNotFoundException " + NL);
        }
        try {
            resolver.setValue(elcontext, base, property, (Object)"arbitrary value");
            buf.append("Test Failed  setValue() did not throw any exception." + NL + "Expected: PropertyNotFoundException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof PropertyNotFoundException)) {
                buf.append("Test Failed  setValue() threw the wrong exception " + NL + "Expected: PropertyNotFoundException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  setValue() threw PropertyNotFoundException " + NL);
        }
        if (!(resolver instanceof BeanELResolver)) {
            return pass;
        }
        try {
            resolver.getValue(elcontext, base, property);
            buf.append("Test Failed  getValue() did not throw any exception." + NL + "Expected: PropertyNotFoundException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof PropertyNotFoundException)) {
                buf.append("Test Failed  getValue() threw the wrong exception " + NL + "Expected: PropertyNotFoundException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  getValue() threw PropertyNotFoundException " + NL);
        }
        return pass;
    }

    public static boolean testELResolverIAE(ELContext elcontext, ELResolver resolver, Object base, Object property, Object value, StringBuffer buf) {
        boolean pass = true;
        try {
            resolver.getValue(elcontext, base, value);
            buf.append("Test Failed  getValue() did not throw any exception." + NL + "Expected: IllegalArgumentException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                buf.append("Test Failed  getValue() threw the wrong exception " + NL + "Expected: IllegalArgumentException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  getValue() threw IllegalArgumentException " + NL);
        }
        try {
            resolver.setValue(elcontext, base, property, value);
            buf.append("Test Failed  setValue() did not throw any exception." + NL + "Expected: IllegalArgumentException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                buf.append("Test Failed  setValue() threw the wrong exception Expected: IllegalArgumentException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  setValue() threw IllegalArgumentException " + NL);
        }
        return pass;
    }

    public static boolean testELResolverPNWE(ELContext elcontext, ELResolver resolver, Object base, Object property, Object value, StringBuffer buf) {
        boolean pass = true;
        try {
            resolver.setValue(elcontext, base, property, value);
            buf.append("Test Failed  setValue() did not throw any exception." + NL + "Expected: PropertyNotWritableException " + NL);
            pass = false;
        }
        catch (Exception e) {
            if (!(e instanceof PropertyNotWritableException)) {
                buf.append("Test Failed  setValue() threw the wrong exception " + NL + "Expected: PropertyNotWritableException " + NL + "Received: " + e.toString());
                pass = false;
            }
            buf.append("Test Passed  setValue() threw PropertyNotWritableException " + NL);
        }
        return pass;
    }
}

