/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.scripting.el;

import ee.jakarta.tck.pages.common.util.JspTestUtil;
import ee.jakarta.tck.pages.spec.core_syntax.scripting.el.BaseCheckTag;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CheckObjectTag
extends BaseCheckTag {
    @Override
    protected void performCheck() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            if (this._object instanceof PageContext) {
                if (this._object == this._control) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  The PageContext implicit object,is not the same PageContext as that of the current Page.");
                }
            } else if (this._object instanceof Map) {
                Map control = CheckObjectTag.getMapFromString((String)this._control);
                out.println(CheckObjectTag.compareMaps(this._name, control, (Map)this._object));
            } else {
                out.println("The implicit object, '" + this._name + "' is not an instance of Map as required by the specification");
            }
        }
        catch (IOException ioe) {
            throw new JspException("Unexpected IOException!", (Throwable)ioe);
        }
    }

    private static Map getMapFromString(String s) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            String value = st.nextToken();
            int length = value.length();
            if (value.charAt(0) == '[' && value.charAt(length - 1) == ']') {
                CheckObjectTag.debug("Creating String array for values: " + value);
                value = value.substring(1, length - 1);
                ArrayList<String> list = new ArrayList<String>();
                StringTokenizer st1 = new StringTokenizer(value, ":");
                while (st1.hasMoreTokens()) {
                    list.add(st1.nextToken());
                }
                map.put(key, list.toArray(new String[list.size()]));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    private static String compareMaps(String name, Map control, Map testMap) {
        for (Map.Entry controlEntry : control.entrySet()) {
            String controlKey = (String)controlEntry.getKey();
            Object controlValue = controlEntry.getValue();
            boolean found = false;
            for (Map.Entry testEntry : testMap.entrySet()) {
                String testKey = (String)testEntry.getKey();
                Object testValue = testEntry.getValue();
                boolean keyFound = false;
                if (name.equals("header") || name.equals("headerValues")) {
                    if (controlKey.equalsIgnoreCase(testKey)) {
                        keyFound = true;
                    }
                } else if (controlKey.equals(testKey)) {
                    keyFound = true;
                }
                if (!keyFound) continue;
                if (controlValue instanceof String[]) {
                    Object[] cValueArray = (String[])controlValue;
                    Object[] tValueArray = (String[])testValue;
                    Arrays.sort(tValueArray);
                    Arrays.sort(cValueArray);
                    if (!Arrays.equals(cValueArray, tValueArray)) {
                        return "Test FAILED.  Unexpected Value returned for key '" + controlKey + "' in the " + name + "implicit object.\nExpected value to be " + JspTestUtil.getAsString((String[])cValueArray) + " but received " + JspTestUtil.getAsString((String[])tValueArray);
                    }
                    found = true;
                    continue;
                }
                if (testValue instanceof Cookie) {
                    Cookie cookie = (Cookie)testValue;
                    if (!controlValue.equals(cookie.getValue())) {
                        return "Test FAILED. Unable to find Cookie in Map returned by implementation with value of '" + controlValue + "'.  Name/Values contained in Map returned by container: " + JspTestUtil.getAsString(testMap);
                    }
                    found = true;
                    continue;
                }
                if (!controlValue.equals(testValue)) {
                    return "Test FAILED.  Unexpected Value returned for key '" + controlKey + "' in the " + name + "implicit object.\nExpected value to be " + controlValue + " but received " + testValue;
                }
                found = true;
            }
            if (found) continue;
            return "Test FAILED.  Unable to find matching entry.\nKey: " + controlKey + ", Value: " + controlValue + "\nMap received from container: " + JspTestUtil.getAsString(testMap);
        }
        return "Test PASSED";
    }

    private static void debug(String message) {
        JspTestUtil.debug("[CheckObjectTag] " + message);
    }
}

