/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.ejbweb;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.jms.ee20.cditests.ejbweb.EjbClientIF;
import jakarta.ejb.EJB;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    private String SERVLET = "/cditestsejbweb_web/ServletTest";
    @EJB(name="ejb/CDITestsEjbWebClntBean")
    static EjbClientIF ejbclient;
    private static final long serialVersionUID = 1L;
    long timeout;
    String user;
    String password;
    String mode;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        boolean pass = true;
        try {
            this.timeout = Integer.parseInt(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.hostname = p.getProperty("webServerHost");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            if (this.hostname == null) {
                throw new Exception("'webServerHost' in ts.jte must not be null");
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            }
            catch (Exception e) {
                throw new Exception("'webServerPort' in ts.jte must be a number");
            }
            TestUtil.logMsg((String)("AppClient DEBUG: ejbclient=" + String.valueOf(ejbclient)));
            if (ejbclient == null) {
                throw new Exception("setup failed: ejbclient injection failure");
            }
            ejbclient.init(p);
        }
        catch (Exception e) {
            throw new Exception("setup failed:", e);
        }
        ejbclient.init(p);
        TestUtil.logMsg((String)"setup ok");
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"cleanup ok");
    }

    public void sendRecvQueueTestUsingCDIFromServlet() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"------------------------------------");
            TestUtil.logMsg((String)"sendRecvQueueTestUsingCDIFromServlet");
            TestUtil.logMsg((String)"------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + String.valueOf(this.url)));
            this.props.setProperty("TEST", "sendRecvQueueTestUsingCDIFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Servlet");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvQueueTestUsingCDIFromServlet failed");
        }
    }

    public void sendRecvTopicTestUsingCDIFromServlet() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"------------------------------------");
            TestUtil.logMsg((String)"sendRecvTopicTestUsingCDIFromServlet");
            TestUtil.logMsg((String)"------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + String.valueOf(this.url)));
            this.props.setProperty("TEST", "sendRecvTopicTestUsingCDIFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Servlet");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvTopicTestUsingCDIFromServlet failed");
        }
    }

    public void sendRecvUsingCDIDefaultFactoryFromServlet() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"-----------------------------------------");
            TestUtil.logMsg((String)"sendRecvUsingCDIDefaultFactoryFromServlet");
            TestUtil.logMsg((String)"-----------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + String.valueOf(this.url)));
            this.props.setProperty("TEST", "sendRecvUsingCDIDefaultFactoryFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Servlet");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvUsingCDIDefaultFactoryFromServlet failed");
        }
    }

    public void verifySessionModeOnCDIJMSContextFromServlet() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"-------------------------------------------");
            TestUtil.logMsg((String)"verifySessionModeOnCDIJMSContextFromServlet");
            TestUtil.logMsg((String)"-------------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + String.valueOf(this.url)));
            this.props.setProperty("TEST", "verifySessionModeOnCDIJMSContextFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Servlet");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("verifySessionModeOnCDIJMSContextFromServlet failed");
        }
    }

    public void testRestrictionsOnCDIJMSContextFromServlet() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"------------------------------------------");
            TestUtil.logMsg((String)"testRestrictionsOnCDIJMSContextFromServlet");
            TestUtil.logMsg((String)"------------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + String.valueOf(this.url)));
            this.props.setProperty("TEST", "testRestrictionsOnCDIJMSContextFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Servlet");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testRestrictionsOnCDIJMSContextFromServlet failed");
        }
    }

    public void sendRecvQueueTestUsingCDIFromEjb() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"--------------------------------");
            TestUtil.logMsg((String)"sendRecvQueueTestUsingCDIFromEjb");
            TestUtil.logMsg((String)"--------------------------------");
            boolean passEjb = ejbclient.echo("sendRecvQueueTestUsingCDIFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvQueueTestUsingCDIFromEjb failed");
        }
    }

    public void sendRecvTopicTestUsingCDIFromEjb() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"--------------------------------");
            TestUtil.logMsg((String)"sendRecvTopicTestUsingCDIFromEjb");
            TestUtil.logMsg((String)"--------------------------------");
            boolean passEjb = ejbclient.echo("sendRecvTopicTestUsingCDIFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvTopicTestUsingCDIFromEjb failed");
        }
    }

    public void sendRecvUsingCDIDefaultFactoryFromEjb() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"-------------------------------------");
            TestUtil.logMsg((String)"sendRecvUsingCDIDefaultFactoryFromEjb");
            TestUtil.logMsg((String)"-------------------------------------");
            boolean passEjb = ejbclient.echo("sendRecvUsingCDIDefaultFactoryFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvUsingCDIDefaultFactoryFromEjb failed");
        }
    }

    public void verifySessionModeOnCDIJMSContextFromEjb() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"---------------------------------------");
            TestUtil.logMsg((String)"verifySessionModeOnCDIJMSContextFromEjb");
            TestUtil.logMsg((String)"---------------------------------------");
            boolean passEjb = ejbclient.echo("verifySessionModeOnCDIJMSContextFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("verifySessionModeOnCDIJMSContextFromEjb failed");
        }
    }

    public void testRestrictionsOnCDIJMSContextFromEjb() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"--------------------------------------");
            TestUtil.logMsg((String)"testRestrictionsOnCDIJMSContextFromEjb");
            TestUtil.logMsg((String)"--------------------------------------");
            boolean passEjb = ejbclient.echo("testRestrictionsOnCDIJMSContextFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testRestrictionsOnCDIJMSContextFromEjb failed");
        }
    }

    public void testActiveJTAUsingCDIAcross2MethodsFromEjb() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"------------------------------------------");
            TestUtil.logMsg((String)"testActiveJTAUsingCDIAcross2MethodsFromEjb");
            TestUtil.logMsg((String)"------------------------------------------");
            boolean passEjb = ejbclient.echo("testActiveJTAUsingCDICallMethod1FromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
            passEjb = ejbclient.echo("testActiveJTAUsingCDICallMethod2FromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testActiveJTAUsingCDIAcross2MethodsFromEjb failed");
        }
    }

    public void sendRecvQueueTestUsingCDIFromManagedBean() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"----------------------------------------");
            TestUtil.logMsg((String)"sendRecvQueueTestUsingCDIFromManagedBean");
            TestUtil.logMsg((String)"----------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + String.valueOf(this.url)));
            this.props.setProperty("TEST", "sendRecvQueueTestUsingCDIFromManagedBean");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from ManagedBean");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from ManagedBean");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from ManagedBean");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvQueueTestUsingCDIFromManagedBean failed");
        }
    }

    public void sendRecvTopicTestUsingCDIFromManagedBean() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"----------------------------------------");
            TestUtil.logMsg((String)"sendRecvTopicTestUsingCDIFromManagedBean");
            TestUtil.logMsg((String)"----------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + String.valueOf(this.url)));
            this.props.setProperty("TEST", "sendRecvTopicTestUsingCDIFromManagedBean");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from ManagedBean");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from ManagedBean");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from ManagedBean");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvTopicTestUsingCDIFromManagedBean failed");
        }
    }
}

