/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndToQueue;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Properties;

public class MsgBean
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;

    public MsgBean() {
        TestUtil.logTrace((String)"@MsgBean()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"@MsgBean-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                TestUtil.logErr((String)"qFactory error");
            }
            TestUtil.logTrace((String)"got a qFactory !!");
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queue == null) {
                TestUtil.logErr((String)"queue error");
            }
            TestUtil.logTrace((String)"got a queue ");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        TestUtil.logTrace((String)("@onMessage! " + String.valueOf(msg)));
        try {
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                TestUtil.logErr((String)"connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            TestUtil.logTrace((String)"started the connection !!");
            if (msg.getObjectProperty("properties") != null) {
                this.initLogging((Properties)msg.getObjectProperty("properties"));
            }
            if (msg.getStringProperty("MessageType").equals("TextMessage")) {
                this.sendATextMessage();
            } else if (msg.getStringProperty("MessageType").equals("BytesMessage")) {
                this.sendABytesMessage();
            } else if (msg.getStringProperty("MessageType").equals("MapMessage")) {
                this.sendAMapMessage();
            } else if (msg.getStringProperty("MessageType").equals("StreamMessage")) {
                this.sendAStreamMessage();
            } else if (msg.getStringProperty("MessageType").equals("ObjectMessage")) {
                this.sendAnObjectMessage();
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught in onMessage!", (Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public void initLogging(Properties p) {
        try {
            TestUtil.init((Properties)p);
            TestUtil.logTrace((String)"MsgBean initLogging OK.");
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"MsgBean initLogging failed.");
            throw new EJBException(e.getMessage());
        }
    }

    private void sendATextMessage() {
        TestUtil.logTrace((String)"@sendATextMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mSender = this.qSession.createSender(this.queue);
            TextMessage msg = this.qSession.createTextMessage();
            msg.setText(myMsg);
            msg.setStringProperty("MessageType", "TextMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending a TextMessage!", (Throwable)e);
        }
    }

    private void sendABytesMessage() {
        TestUtil.logTrace((String)"@sendABytesMessage");
        try {
            byte aByte = 10;
            this.mSender = this.qSession.createSender(this.queue);
            BytesMessage msg = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.writeByte(aByte);
            msg.setStringProperty("MessageType", "BytesMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending a BytesMessage!", (Throwable)e);
        }
    }

    private void sendAMapMessage() {
        TestUtil.logTrace((String)"@sendAMapMessage");
        try {
            String myMsg = "I am sending a map message as requested";
            this.mSender = this.qSession.createSender(this.queue);
            MapMessage msg = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setString("MapMessage", myMsg);
            msg.setStringProperty("MessageType", "MapMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending a MapMessage!", (Throwable)e);
        }
    }

    private void sendAStreamMessage() {
        TestUtil.logTrace((String)"@sendAStreamMessage");
        try {
            String myMsg = "I am sending a stream message as requested";
            this.mSender = this.qSession.createSender(this.queue);
            StreamMessage msg = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.writeString(myMsg);
            msg.setStringProperty("MessageType", "StreamMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending a StreamMessage!", (Throwable)e);
        }
    }

    private void sendAnObjectMessage() {
        TestUtil.logTrace((String)"@sendAnObjectMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mSender = this.qSession.createSender(this.queue);
            ObjectMessage msg = this.qSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setObject((Serializable)((Object)myMsg));
            msg.setStringProperty("MessageType", "ObjectMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending an ObjectMessage!", (Throwable)e);
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"In MsgBean::remove()!!");
    }
}

