/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.strquery;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.CreditCard;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.LineItem;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.Arrays;
import java.util.List;

public class Client2
extends Util {
    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Orders for Customer: Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Expression)cbuilder.parameter(String.class, "name"))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("name", (Object)"Robert E. Bissett");
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest5() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all Customers with AXP Credit Cards");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("creditCards");
            cquery.where((Expression)cbuilder.equal((Expression)a.get("type"), (Expression)cbuilder.parameter(String.class, "ccard")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("ccard", (Object)"AXP");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "4", "5", "8", "9", "12", "15"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 7 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest5 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest8() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where the total price is NOT less than $4500");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.lt((Expression)order.get("totalPrice"), (Number)4500).not());
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "11", "16"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest8 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest9() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where the customer name is Karen R. Tegan OR the total price is less than $100");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.lt((Expression)order.get("totalPrice"), (Number)100)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "9", "10", "12", "13"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 5 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest9 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest10() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where line item quantity is 1 AND the order total less than 100 or customer name is Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join l = order.join("lineItemsCollection");
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.and((Expression)cbuilder.lt((Expression)l.get("quantity"), (Number)2), (Expression)cbuilder.lt((Expression)order.get("totalPrice"), cbuilder.sum(cbuilder.sum(cbuilder.literal((Object)3), cbuilder.prod(cbuilder.literal((Object)54), (Number)2)), (Number)-8))), (Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Robert E. Bissett")));
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "9", "12", "13"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 4 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest10 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest11() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders with line item quantity < 2 for customer Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join l = order.join("lineItemsCollection");
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.lt((Expression)l.get("quantity"), (Number)2), (Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Robert E. Bissett")));
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest11 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest12() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders with a total price BETWEEN $1000 and $1200");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.between((Expression)order.get("totalPrice"), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "14"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 5 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest12 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest13() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders with a total price NOT BETWEEN $1000 and $1200");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.between((Expression)order.get("totalPrice"), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0)).not()).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest13 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest14() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders that do not have approved Credit Cards");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isFalse((Expression)order.get("creditCard").get("approved")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "7", "11", "13", "18", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 6 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest14 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest27() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all Orders with a total price greater than 1180");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.lt((Expression)cbuilder.parameter(Double.class, "dbl"), cbuilder.abs((Expression)order.get("totalPrice"))));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("dbl", (Object)1180.0);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "4", "5", "6", "11", "16", "17", "18"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 9 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest27 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest32() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where line items are members of the orders");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root l = cquery.from(LineItem.class);
            cquery.where((Expression)cbuilder.isMember((Expression)l, (Expression)order.get("lineItemsCollection")));
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[this.orderRef.length];
            for (int i = 0; i < this.orderRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + this.orderRef.length + "references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest32 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest33() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find orders whose orders are do NOT contain the specified line items");
            LineItem liDvc = (LineItem)this.getEntityManager().find(LineItem.class, (Object)"30");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isNotMember((Expression)cbuilder.parameter(LineItem.class, "liDvc"), (Expression)order.get("lineItemsCollection")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("liDvc", (Object)liDvc);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 19 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest33 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest34() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find orders who have Samples in their orders");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isMember((Expression)order.get("sampleLineItem"), (Expression)order.get("lineItemsCollection")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "6"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest34 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest35() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders which contain lineitems not of quantities 1 or 5");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join l = order.join("lineItemsCollection");
            cquery.where((Expression)l.get("quantity").in(new Object[]{1, 5}).not());
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 9 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest35 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest39() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        double dbl = 50.0;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find customers with specific credit card balance");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join b = customer.join("creditCards");
            cquery.where((Expression)cbuilder.equal(cbuilder.sqrt((Expression)b.get("balance")), (Expression)cbuilder.parameter(Double.class, "dbl")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("dbl", (Object)50.0);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest39 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest42() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where related customer name is not null");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)order.get("customer").get("name")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 19 references, got: " + olist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest42 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest48() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Object[] expectedBalances = new Double[]{400.0, 500.0, 750.0, 1000.0, 1400.0, 1500.0, 2000.0, 2500.0, 4400.0, 5000.0, 5500.0, 7000.0, 7400.0, 8000.0, 9500.0, 13000.0, 15000.0, 23000.0};
        try {
            Object[] result;
            this.getEntityTransaction().begin();
            this.logTrace("find all credit card balances");
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order.get("creditCard").get("balance")).distinct(true);
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)order.get("creditCard").get("balance"))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List olist = tquery.getResultList();
            for (Double d : result = olist.toArray(new Double[olist.size()])) {
                this.logTrace("query results returned:  " + d);
            }
            this.logTrace("Compare expected results to query results");
            pass = Arrays.equals(expectedBalances, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest48 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest60() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find Customers with an Order");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.join("orders");
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 18 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest60 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest62() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.ge(cbuilder.size((Expression)customer.get("orders")), (Number)2));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "14"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest62 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest63() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.size((Expression)customer.get("orders")), (Number)100));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest63 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest65() throws Exception {
        boolean pass = false;
        String s1 = "4";
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.logTrace("find MINIMUM order id for Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Robert E. Bissett")).select((Selection)cbuilder.least((Expression)order.get("id")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            String s2 = (String)tquery.getSingleResult();
            if (s2.equals("4")) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logTrace("queryTest65 returned " + s2 + "expected: 4");
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest65 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest66() throws Exception {
        boolean pass = false;
        Integer i1 = 8;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.logTrace("find MAXIMUM number of lineItem quantities available an order may have");
            CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
            Root l = cquery.from(LineItem.class);
            cquery.select((Selection)cbuilder.max((Expression)l.get("quantity")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Integer i2 = (Integer)tquery.getSingleResult();
            if (i2.equals(i1)) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logTrace("queryTest66 returned:" + i2 + "expected: " + i1);
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest66 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest67() throws Exception {
        boolean pass = false;
        Double d1 = 1487.29;
        Double d2 = 1487.3;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.logTrace("find AVERAGE price of all orders");
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)cbuilder.avg((Expression)order.get("totalPrice")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Double d3 = (Double)tquery.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                this.logTrace("queryTest67 returned expected results: " + d1);
                pass = true;
            } else {
                this.logTrace("queryTest67 returned " + d3 + "expected: " + d1);
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest67 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_leftouterjoin_1xM() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.join("creditCards", JoinType.LEFT);
            cquery.where((Expression)cbuilder.like((Expression)customer.get("name"), "%Caruso")).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_leftouterjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_leftouterjoin_Mx1() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        Object[][] expectedResultSet = new Object[][]{{"15", "14"}, {"16", "14"}};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join c = order.join("customer", JoinType.LEFT);
            cquery.where((Expression)cbuilder.equal((Expression)c.get("name"), (Expression)cbuilder.parameter(String.class, "one")));
            cquery.multiselect(new Selection[]{order.get("id"), c.get("id")});
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)order.get("id"))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("one", (Object)"Kellie A. Sanborn");
            List q = tquery.getResultList();
            if (q.size() != 2) {
                this.logTrace("test_leftouterjoin_Mx1:  Did not get expected results. Expected 2,  got: " + q.size());
            } else {
                pass1 = true;
                this.logTrace("Expected size received, verify contents . . . ");
                for (int i = 0; i < q.size(); ++i) {
                    Object obj = q.get(i);
                    Object[] orderAndCustomerExpected = expectedResultSet[i];
                    Tuple orderAndCustomerTuple = null;
                    Object[] orderAndCustomer = null;
                    if (obj instanceof Tuple) {
                        this.logTrace("The element in the result list is of type Object[], continue . . .");
                        orderAndCustomerTuple = (Tuple)obj;
                        orderAndCustomer = orderAndCustomerTuple.toArray();
                        if (Arrays.equals(orderAndCustomerExpected, orderAndCustomer)) continue;
                        this.logErr("Expecting element value: " + String.valueOf(Arrays.asList(orderAndCustomerExpected)) + ", actual element value: " + String.valueOf(Arrays.asList(orderAndCustomer)));
                        pass2 = false;
                        break;
                    }
                    this.logErr("The element in the result list is not of type Object[]:" + String.valueOf(obj));
                    break;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("test_leftouterjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_groupBy_1() throws Exception {
        boolean pass = false;
        Object[] expectedTypes = new String[]{"AXP", "MCARD", "VISA"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root cc = cquery.from(CreditCard.class);
            cquery.select((Selection)cc.get("type")).groupBy(new Expression[]{cc.get("type")});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedTypes, output);
            if (!pass) {
                this.logErr("Did not get expected results.  Expected 3 Credit Card Types: AXP, MCARD, VISA. Received: " + result.size());
                for (String s : result) {
                    this.logErr(" Credit Card Type: " + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_groupBy_1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_innerjoin_1xM() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join cc = customer.join("creditCards");
            cquery.where((Expression)cbuilder.equal((Expression)cc.get("type"), (Object)"VISA")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "6", "7", "10", "14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 8 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_innerjoin_Mx1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join c = order.join("customer");
            cquery.where((Expression)cbuilder.equal((Expression)c.get("name"), (Expression)cbuilder.parameter(String.class, "one")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("one", (Object)"Kellie A. Sanborn");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_Mx1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("customer").get("home").get("city"), (Object)"Lawrence")).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 8 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_Mx1_1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.like((Expression)order.get("customer").get("name"), "%Caruso")).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_Mx1_1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_notBetweenArithmetic() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.between((Expression)order.get("totalPrice"), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0))));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_notBetweenArithmetic failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionTT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)500)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionTF() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)10000)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionFT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where(new Predicate[]{cbuilder.equal((Expression)order.get("customer").get("id"), (Object)"1001"), cbuilder.lt((Expression)order.get("totalPrice"), (Number)1000)}).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionFF() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get("customer").get("id"), (Object)"1001"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)10000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionTT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)5000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionTF() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("name"), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)10000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionFT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("id"), (Object)"1001"), (Expression)cbuilder.lt((Expression)order.get("totalPrice"), (Number)1000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"9", "10", "12", "13", "15", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 7 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionFF() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get("customer").get("id"), (Object)"1001"), (Expression)cbuilder.gt((Expression)order.get("totalPrice"), (Number)10000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_groupByWhereClause() throws Exception {
        boolean pass = false;
        Object[] expectedCusts = new String[]{"Jonathan K. Smith", "Kellie A. Sanborn", "Robert E. Bissett"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            cquery.where((Expression)cbuilder.between((Expression)o.get("totalPrice"), (Comparable)Double.valueOf(90.0), (Comparable)Double.valueOf(160.0))).groupBy(new Expression[]{customer.get("name")}).select((Selection)customer.get("name"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCusts, output);
            if (!pass) {
                this.logErr("Did not get expected results.  Expected 3 Customers : Jonathan K. Smith, Kellie A. Sanborn and Robert E. Bissett. Received: " + result.size());
                for (String s : result) {
                    this.logTrace(" Customer: " + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_groupByWhereClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ABSHavingClause() throws Exception {
        boolean pass = false;
        Double expectedPrice = 10191.9;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)cbuilder.sum((Expression)order.get("totalPrice"))).groupBy(new Expression[]{order.get("totalPrice")}).having((Expression)cbuilder.equal(cbuilder.abs((Expression)order.get("totalPrice")), (Expression)cbuilder.parameter(Double.class, "doubleValue")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("doubleValue", (Object)5095.95);
            Double result = (Double)tquery.getSingleResult();
            if (expectedPrice.equals(result)) {
                pass = true;
                this.logTrace("Expected results received");
            } else {
                this.logErr("test_ABSHavingClause:  Did not get expected results.Expected:" + expectedPrice + ", got: " + String.valueOf(result));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_ABSHavingClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_SQRTWhereClause() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("SQRT: Executing Query");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.sqrt((Expression)order.get("totalPrice")), (Expression)cbuilder.parameter(Double.class, "doubleValue"))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("doubleValue", (Object)70.0);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_SQRTWhereClause:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_SQRTWhereClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_exists_01() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("orders");
            sq.select((Expression)sqo);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.exists(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_exists_01:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_exists_01 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_exists_02() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("orders");
            sq.where((Expression)cbuilder.gt((Expression)sqo.get("totalPrice"), (Number)1500.0));
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_exists_02:  Did not get expected results.  Expected 4 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_exists_02 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_like() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(Customer.class);
            Root sqo = sq.correlate(order);
            Join sqc = sqo.join("customer");
            sq.where((Expression)cbuilder.like((Expression)sqc.get("name"), "%Caruso")).select((Expression)sqc);
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_like:  Did not get expected  results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_like failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_between() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Execute query for test_subquery_between");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("orders");
            sq.where((Expression)cbuilder.between((Expression)sqo.get("totalPrice"), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0)));
            cquery.where((Expression)cbuilder.exists(sq));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_between:  Did not get expected  results.  Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_between failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_join() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sqo = sq.correlate(o);
            Join sql = sqo.join("lineItemsCollection");
            sq.where((Expression)cbuilder.gt((Expression)sql.get("quantity"), (Number)3)).select((Expression)sqo);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "9", "11", "13", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_join:  Did not get expected results.  Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_join failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_GT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join l = sqo.join("lineItemsCollection");
            sq.where((Expression)cbuilder.gt((Expression)l.get("quantity"), (Number)3));
            sq.select((Expression)sqo.get("totalPrice"));
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.gt((Expression)o.get("totalPrice"), cbuilder.all(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_GT:  Did not get expected results.  Expected 4 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_ALL_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_LT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.where((Expression)cbuilder.gt((Expression)sql.get("quantity"), (Number)3));
            sq.select((Expression)sqo.get("totalPrice"));
            cquery.where((Expression)cbuilder.lt((Expression)o.get("totalPrice"), cbuilder.all(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_LT:  Did not get expected results.  Expected 1 reference, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_EQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select(cbuilder.min((Expression)sqo.get("totalPrice")));
            cquery.where((Expression)cbuilder.equal((Expression)o.get("totalPrice"), cbuilder.all(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_EQ:  Did not get expected results.  Expected 1 reference, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_LTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.gt((Expression)sql.get("quantity"), (Number)3));
            cquery.where((Expression)cbuilder.le((Expression)o.get("totalPrice"), cbuilder.all(sq))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"9", "12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_LTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_GTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.ge((Expression)sql.get("quantity"), (Number)3));
            cquery.where((Expression)cbuilder.ge((Expression)o.get("totalPrice"), cbuilder.all(sq))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_GTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_GTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_NOTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select(cbuilder.min((Expression)sqo.get("totalPrice")));
            cquery.where((Expression)cbuilder.notEqual((Expression)o.get("totalPrice"), cbuilder.all(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_NOTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_NOTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_GT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.equal((Expression)sql.get("quantity"), (Object)3));
            cquery.where((Expression)cbuilder.gt((Expression)o.get("totalPrice"), cbuilder.any(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ANY_GT:  Did not get expected results.   Expected 16 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ANY_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_LT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.equal((Expression)sql.get("quantity"), (Object)3));
            cquery.where((Expression)cbuilder.lt((Expression)o.get("totalPrice"), cbuilder.any(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ANY_LT:  Did not get expected results.  Expected 17 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ANY_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_EQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select(cbuilder.max((Expression)sqo.get("totalPrice")));
            cquery.where((Expression)cbuilder.equal((Expression)o.get("totalPrice"), cbuilder.any(sq))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ANY_EQ:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ANY_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_SOME_LTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.equal((Expression)sql.get("quantity"), (Object)3));
            cquery.where((Expression)cbuilder.le((Expression)o.get("totalPrice"), cbuilder.some(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_SOME_LTEQ:  Did not get expected results.  Expected 18 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_SOME_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_SOME_GTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join o = customer.join("orders");
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sql = sqo.join("lineItemsCollection");
            sq.select((Expression)sqo.get("totalPrice"));
            sq.where((Expression)cbuilder.equal((Expression)sql.get("quantity"), (Object)3));
            cquery.where((Expression)cbuilder.ge((Expression)o.get("totalPrice"), cbuilder.some(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_SOME_GTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_SOME_GTEQ failed");
        }
    }
}

