/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.cache.basicTests;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.cache.basicTests.Order;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getcacheTest() throws Exception {
        boolean pass = false;
        int count = 5;
        if (this.cachingSupported) {
            try {
                EntityManager em2 = this.getEntityManager();
                EntityTransaction et = this.getEntityTransaction();
                Order[] orders = new Order[5];
                et.begin();
                for (int i = 1; i < 5; ++i) {
                    orders[i] = new Order(i, 100 * i);
                    em2.persist((Object)orders[i]);
                    this.logTrace("persisted order " + String.valueOf(orders[i]));
                }
                em2.flush();
                EntityManagerFactory emf = this.getEntityManagerFactory();
                Cache cache = emf.getCache();
                if (cache != null) {
                    pass = true;
                } else {
                    this.logErr("Cache returned was null");
                }
                for (int i = 1; i < 5; ++i) {
                    em2.remove((Object)orders[i]);
                    this.logTrace("Removed order " + String.valueOf(orders[i]));
                }
                et.commit();
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
        } else {
            this.logMsg("Cache not supported, bypassing test");
            pass = true;
        }
        if (!pass) {
            throw new Exception("getcacheTest failed");
        }
    }

    public void evictTest1() throws Exception {
        boolean pass2;
        boolean pass1;
        block10: {
            int count = 5;
            pass1 = false;
            pass2 = false;
            if (this.cachingSupported) {
                try {
                    this.getEntityTransaction().begin();
                    this.logTrace("Transaction status after begin:" + this.getEntityTransaction().isActive());
                    Order[] orders = new Order[5];
                    for (int i = 1; i < 5; ++i) {
                        orders[i] = new Order(i, 100 * i);
                        this.getEntityManager().persist((Object)orders[i]);
                        this.logTrace("persisted order " + String.valueOf(orders[i]));
                    }
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    this.logTrace("Transaction status after commit:" + this.getEntityTransaction().isActive());
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        pass1 = true;
                        this.logTrace("cache was successfully obtained");
                        boolean cacheContains = cache.contains(Order.class, (Object)1);
                        if (cacheContains) {
                            this.logTrace("Order 1 found, evicting it from cache");
                            cache.evict(Order.class, (Object)1);
                            cacheContains = cache.contains(Order.class, (Object)1);
                            if (!cacheContains) {
                                pass2 = true;
                                this.logTrace("Order 1 was successfully evicted");
                            }
                        } else {
                            this.logErr("cache did not contain Order 1");
                        }
                        break block10;
                    }
                    this.logErr("Cache returned was null, eventhough Cache is supported.");
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception occurred", e);
                }
            } else {
                this.logMsg("Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("evictTest1 failed");
        }
    }

    public void evictTest2() throws Exception {
        boolean pass1;
        boolean pass2;
        block10: {
            int count = 5;
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    Order[] orders = new Order[5];
                    this.getEntityTransaction().begin();
                    for (int i = 1; i < 5; ++i) {
                        orders[i] = new Order(i, 100 * i);
                        this.getEntityManager().persist((Object)orders[i]);
                        this.logTrace("persisted order " + String.valueOf(orders[i]));
                    }
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        pass1 = true;
                        this.logTrace("cache was successfully obtained");
                        boolean cacheContains = cache.contains(Order.class, (Object)1);
                        if (cacheContains) {
                            this.logTrace("evicting Order 1 from cache");
                            cache.evict(Order.class);
                            cacheContains = cache.contains(Order.class, (Object)1);
                            if (!cacheContains) {
                                pass2 = true;
                                this.logTrace("Order 1 was successfully evicted");
                            }
                        } else {
                            this.logErr("Cache did not contain Order 1");
                        }
                        break block10;
                    }
                    this.logErr("Cache returned was null, eventhough Cache is supported.");
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception occurred", e);
                }
            } else {
                this.logMsg("Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("evictTest2 failed");
        }
    }

    public void evictallTest() throws Exception {
        boolean pass2;
        boolean pass1;
        block10: {
            int count = 5;
            pass1 = false;
            pass2 = false;
            int pass2Count = 0;
            Order[] orders = new Order[5];
            int[] ids = new int[5];
            if (this.cachingSupported) {
                try {
                    this.getEntityTransaction().begin();
                    for (int i = 1; i < 5; ++i) {
                        orders[i] = new Order(i, 100 * i);
                        ids[i] = orders[i].getId();
                        this.getEntityManager().persist((Object)orders[i]);
                        this.logTrace("persisted order " + String.valueOf(orders[i]));
                    }
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        pass1 = true;
                        this.logTrace("cache was successfully obtained, evicting all Orders from cache");
                        cache.evictAll();
                        for (int i : ids) {
                            this.logTrace("Testing order:" + i);
                            boolean cacheContains = cache.contains(Order.class, (Object)i);
                            if (cacheContains) continue;
                            ++pass2Count;
                            this.logTrace("Order:" + i + " was successfully evicted");
                        }
                        if (pass2Count == orders.length) {
                            pass2 = true;
                        } else {
                            this.logErr("Not all orders were evicted.");
                        }
                        break block10;
                    }
                    this.logErr("Cache returned was null, eventhough Cache is supported.");
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception occurred", e);
                }
            } else {
                this.logMsg("Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("evictallTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

