/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.usertransaction.setrollbackonly;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jta.ee.common.Transact;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Properties;

public class UserSetRollbackOnlyClient
extends ServiceEETest
implements Serializable {
    private static final int SLEEPTIME = 2000;
    private static final String testName = "jta.ee.usertransaction.setrollbackonly";
    private UserTransaction userTransaction = null;

    public void setup(String[] args, Properties p) throws Exception {
        try {
            Transact.init();
            this.logTrace("Test environment initialized");
            this.userTransaction = (UserTransaction)Transact.nctx.lookup("java:comp/UserTransaction");
            this.logMsg("User Transaction object is Obtained");
            if (this.userTransaction == null) {
                this.logErr("Unable to get User Transaction Instance : Could not proceed with tests");
                throw new Exception("couldnt proceed further");
            }
            if (this.userTransaction.getStatus() == 0) {
                this.userTransaction.rollback();
            }
        }
        catch (Exception exception) {
            this.logErr("Setup Failed!");
            this.logTrace("Unable to get User Transaction Instance : Could not proceed with tests");
            throw new Exception("Setup Failed", exception);
        }
    }

    public static void main(String[] args) {
        UserSetRollbackOnlyClient userSetRollbackOnlyClientInst = new UserSetRollbackOnlyClient();
        Status s = userSetRollbackOnlyClientInst.run(args, System.out, System.err);
        s.exit();
    }

    public void testUserSetRollbackOnly001() throws Exception {
        try {
            this.logMsg("Getting the status of transaction");
            if (this.userTransaction.getStatus() == 6) {
                this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
                this.logMsg("Trying to set the transaction for Rollback operation");
                this.userTransaction.setRollbackOnly();
                throw new Exception("IllegalStateException not thrown as Expected");
            }
            throw new Exception("Failed to return the status STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegalState) {
            this.logMsg("IllegalStateException was caught as expected!!");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new Exception("IllegalStateException not thrown as Expected", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new Exception("IllegalStateException not thrown as Expected", exception);
        }
    }

    public void testUserSetRollbackOnly002() throws Exception {
        block11: {
            try {
                int status;
                this.userTransaction.begin();
                this.logMsg("UserTransaction Started");
                if (this.userTransaction.getStatus() == 0) {
                    this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                    this.userTransaction.setRollbackOnly();
                }
                if ((status = this.userTransaction.getStatus()) == 5) {
                    int count = 0;
                    do {
                        this.logTrace("Received STATUS_UNKNOWN. Checking status again.");
                        ++count;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception e) {
                            throw new Exception(e.getCause());
                        }
                    } while ((status = this.userTransaction.getStatus()) == 5 && count < 5);
                }
                if (status == 1) {
                    this.logMsg("UserTransaction set for Rollback operation");
                    this.logMsg("UserTransaction Status is STATUS_MARKED_ROLLBACK");
                    break block11;
                }
                if (status == 9 || status == 4 || status == 6) {
                    this.logMsg("UserTransaction marked for Rollback");
                    this.logMsg("UserTransaction is rolling/rolled back");
                    break block11;
                }
                throw new Exception("Failed to return the status STATUS_MARKED_ROLLBACK");
            }
            catch (IllegalStateException illegalState) {
                this.logErr("Exception " + illegalState.toString() + " was caught");
                throw new Exception("UnExpected Exception was caught: Failed", illegalState);
            }
            catch (SystemException system) {
                this.logErr("Exception " + system.toString() + " was caught");
                throw new Exception("UnExpected Exception was caught: Failed", system);
            }
            catch (Exception exception) {
                this.logErr("Exception " + exception.toString() + " was caught");
                throw new Exception("UnExpected Exception was caught: Failed", exception);
            }
        }
    }

    public void testUserSetRollbackOnly003() throws Exception {
        try {
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() == 0) {
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                this.userTransaction.commit();
            }
            if (this.userTransaction.getStatus() == 6) {
                this.logMsg("UserTransaction Committed");
                this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
                this.logMsg("Trying to set the transaction for Rollback operation");
                this.userTransaction.setRollbackOnly();
                throw new Exception("IllegalStateException not thrown as Expected");
            }
            throw new Exception("Failed to return the status STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegalState) {
            this.logMsg("IllegalStateException was caught as expected!!");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new Exception("IllegalStateException not thrown as Expected", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new Exception("IllegalStateException not thrown as Expected", exception);
        }
    }

    public void testUserSetRollbackOnly004() throws Exception {
        try {
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() == 0) {
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                this.userTransaction.rollback();
            }
            if (this.userTransaction.getStatus() == 6) {
                this.logMsg("UserTransaction Rolled back");
                this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
                this.logMsg("Trying to set the transaction forRollback operation");
                this.userTransaction.setRollbackOnly();
                throw new Exception("IllegalStateException not thrown as Expected");
            }
            throw new Exception("Failed to return the status STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegalState) {
            this.logMsg("IllegalStateException was caught as expected!!");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new Exception("IllegalStateException not thrown as Expected", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new Exception("IllegalStateException not thrown as Expected", exception);
        }
    }

    public void cleanup() throws Exception {
        block8: {
            try {
                if (this.userTransaction.getStatus() == 0) {
                    Transact.free();
                    try {
                        this.userTransaction.rollback();
                    }
                    catch (Exception exception) {
                        throw new Exception(exception.getCause());
                    }
                    for (int retries = 1; this.userTransaction.getStatus() != 6 && retries <= 5; ++retries) {
                        this.logMsg("cleanup(): retry # " + retries);
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception e) {
                            throw new Exception(e.getCause());
                        }
                    }
                    this.logMsg("Cleanup ok;");
                    break block8;
                }
                this.logMsg("CleanUp not required as Transaction is not in Active state.");
            }
            catch (Exception exception) {
                this.logErr("Cleanup Failed", exception);
                this.logTrace("Could not clean the environment");
            }
        }
    }
}

