/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa.ee.packaging.jar;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa.ee.packaging.jar.A;
import ee.jakarta.tck.persistence.jpa.ee.packaging.jar.B;
import ee.jakarta.tck.persistence.jpa.ee.packaging.jar.C;
import java.util.Properties;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void JarFileElementsTest() throws Exception {
        B b;
        C c;
        A a;
        int i;
        boolean pass = true;
        int count = 2;
        this.getEntityTransaction().begin();
        for (i = 1; i <= 2; ++i) {
            a = new A(Integer.toString(i), "name_" + Integer.toString(i), i);
            this.getEntityManager().persist((Object)a);
            this.logTrace("persisted order " + a.toString());
        }
        for (i = 3; i <= 4; ++i) {
            c = new C(Integer.toString(i), "name_" + Integer.toString(i), i);
            this.getEntityManager().persist((Object)c);
            this.logTrace("persisted order " + c.toString());
        }
        for (i = 1; i <= 2; ++i) {
            b = new B(Integer.toString(i), "name_" + Integer.toString(i), i);
            this.getEntityManager().persist((Object)b);
            this.logTrace("persisted order " + b.toString());
        }
        this.getEntityTransaction().commit();
        this.logTrace("find the previously persisted entities");
        for (i = 1; i <= 2; ++i) {
            a = (A)this.getEntityManager().find(A.class, (Object)Integer.toString(i));
            if (a != null) {
                this.logTrace("Find returned non-null A entity:" + a.toString());
                continue;
            }
            this.logErr("persisted A[" + i + "] DOES NOT EXIST");
            pass = false;
        }
        for (i = 3; i <= 4; ++i) {
            c = (C)this.getEntityManager().find(C.class, (Object)Integer.toString(i));
            if (c != null) {
                this.logTrace("Find returned non-null C entity:" + c.toString());
                continue;
            }
            this.logErr("persisted C[" + i + "] DOES NOT EXIST");
            pass = false;
        }
        for (i = 1; i <= 2; ++i) {
            b = (B)this.getEntityManager().find(B.class, (Object)Integer.toString(i));
            if (b != null) {
                this.logTrace("Find returned non-null B entity:" + b.toString());
                continue;
            }
            this.logErr("persisted B[" + i + "] DOES NOT EXIST");
            pass = false;
        }
        if (!pass) {
            throw new Exception("JarFileElementsTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

