/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Set;

@ConversationScoped
@Named(value="builtin")
public class BuiltInConversation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private BeanManager manager;
    @Inject
    private Conversation conversation;

    public boolean isScopeCorrect() {
        return this.getConversationBean().getScope().equals(RequestScoped.class);
    }

    public boolean isQualifierCorrect() {
        for (Annotation qualifier : this.getConversationBean().getQualifiers()) {
            if (!qualifier.annotationType().equals(Default.class)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameCorrect() {
        return this.getConversationBean().getName().equals("jakarta.enterprise.context.conversation");
    }

    public boolean isDefaultConversationHasNullId() {
        return this.conversation.isTransient() && this.conversation.getId() == null;
    }

    private Bean<?> getConversationBean() {
        Set beans = this.manager.getBeans(Conversation.class, new Annotation[0]);
        if (beans.size() != 1) {
            throw new RuntimeException("Multiple beans found for Conversation class.");
        }
        return (Bean)beans.iterator().next();
    }
}

