/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.mapkey;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.mapkey.Consumer;
import ee.jakarta.tck.persistence.core.override.mapkey.Customers;
import ee.jakarta.tck.persistence.core.override.mapkey.Department;
import ee.jakarta.tck.persistence.core.override.mapkey.Employee;
import ee.jakarta.tck.persistence.core.override.mapkey.EmployeeComparator;
import ee.jakarta.tck.persistence.core.override.mapkey.RetailOrder;
import ee.jakarta.tck.persistence.core.override.mapkey.RetailOrderCostComparatorDESC;
import ee.jakarta.tck.persistence.core.override.mapkey.Store;
import ee.jakarta.tck.persistence.core.override.mapkey.TheatreCompany;
import ee.jakarta.tck.persistence.core.override.mapkey.TheatreLocation;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long DEPT1_ID = 777L;
    private static final String DEPT1_NAME = "Software";
    private static final long EMP1_ID = 220L;
    private static final String EMP1_CODE = "SW";
    private static final long EMP2_ID = 35L;
    private static final String EMP2_CODE = "ME";
    private static final long EMP3_ID = 36L;
    private static final String EMP3_CODE = "HW";
    private Employee employee1;
    private Employee employee2;
    private Employee employee3;
    private List<Employee> employeeList;
    private static final long COMPANY_ID = 676L;
    private static final String COMPANY_NAME = "Regal";
    private static final long LOCATION_ID = 42L;
    private static final String LOCATION_CODE = "KXTN";
    private static final long CITY_ID = 47L;
    private static final String CITY_CODE = "ICIO";
    private static final int CUSTOMER1_ID = 420;
    private static final String CUSTOMER1_NAME = "Craig";
    private static final int CUSTOMER2_ID = 640;
    private static final String CUSTOMER2_NAME = "Russell";
    private static final int STORE_ID = 78600;
    private static final String STORE_NAME = "Sun";
    private static final long ORDER1_ID = 786L;
    private static final long ORDER2_ID = 787L;
    private static final long ORDER3_ID = 788L;
    private static final long ORDER4_ID = 789L;
    private static final double COST1 = 100.0;
    private static final double COST2 = 105.0;
    private static final double COST3 = 110.0;
    private static final double COST4 = 115.0;
    private static final long CUST1_ID = 2L;
    private List<RetailOrder> consumer1Orders;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception:test failed ", e);
        }
    }

    public void testNoOrderByAnnotation() throws Exception {
        Department dept = this.createDepartment(777L, DEPT1_NAME);
        this.employee1 = this.createEmployee(220L, EMP1_CODE);
        this.employee2 = this.createEmployee(35L, EMP2_CODE);
        this.employee3 = this.createEmployee(36L, EMP3_CODE);
        this.employeeList = new ArrayList<Employee>();
        this.employeeList.add(this.employee3);
        this.employeeList.add(this.employee2);
        this.employeeList.add(this.employee1);
        dept.setEmployees(this.employeeList);
        this.employee1.setDepartment(dept);
        this.employee2.setDepartment(dept);
        this.employee3.setDepartment(dept);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)dept);
        this.getEntityManager().flush();
        this.clearCache();
        this.getEntityTransaction().commit();
        this.clearCache();
        this.getEntityTransaction().begin();
        Collections.sort(this.employeeList, new EmployeeComparator());
        try {
            Query q = this.getEntityManager().createQuery("select d from Department d where d.id= :dept");
            q.setParameter("dept", (Object)777L);
            Department dept1 = (Department)q.getSingleResult();
            List<Employee> actualList = dept1.getEmployees();
            if (!this.employeeList.equals(actualList)) {
                throw new Exception("The expected Employee List is not equal to the actual List read from the DB");
            }
            this.logTrace("Test Passed");
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing testOrderByAnnotation" + e);
        }
    }

    public void testOverrideMapKey() throws Exception {
        TheatreCompany regal = this.createTheatreCompany(676L, COMPANY_NAME);
        TheatreLocation knoxville = this.createTheatreLocation(42L, LOCATION_CODE);
        TheatreLocation iowacity = this.createTheatreLocation(47L, CITY_CODE);
        HashMap<String, TheatreLocation> regalLocations = new HashMap<String, TheatreLocation>();
        regalLocations.put(LOCATION_CODE, knoxville);
        regalLocations.put(CITY_CODE, iowacity);
        regal.setLocations(regalLocations);
        knoxville.addCompany(regal);
        iowacity.addCompany(regal);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)regal);
        this.getEntityManager().flush();
        this.clearCache();
        this.getEntityTransaction().commit();
        this.clearCache();
        this.getEntityTransaction().begin();
        try {
            Query q = this.getEntityManager().createQuery("select t from TheatreCompany t where t.id= :id");
            q.setParameter("id", (Object)676L);
            TheatreCompany retrieveCompany = (TheatreCompany)q.getSingleResult();
            Map<String, TheatreLocation> retrieveLocations = retrieveCompany.getLocations();
            if (retrieveLocations.get(LOCATION_CODE).getId() != 42L || retrieveLocations.get(CITY_CODE).getId() != 47L) {
                throw new Exception("Expected to read the relationship as a Map with keys - KXTN and ICIO; Actual Locations Found - " + retrieveLocations.get(LOCATION_CODE).getId() + " and " + retrieveLocations.get(CITY_CODE).getId());
            }
            this.logTrace("Test Passed");
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing testOverrideMapKey" + e);
        }
    }

    public void testNoMapKeyAnnotation() throws Exception {
        this.getEntityTransaction().begin();
        Store store = this.createStore(78600, STORE_NAME);
        Customers customer1 = this.createCustomers(420, CUSTOMER1_NAME, store);
        Customers customer2 = this.createCustomers(640, CUSTOMER2_NAME, store);
        HashMap<String, Customers> customersOfStore = new HashMap<String, Customers>();
        customersOfStore.put((String)((Object)Integer.valueOf(420)), customer1);
        customersOfStore.put((String)((Object)Integer.valueOf(640)), customer2);
        store.setCustomers(customersOfStore);
        this.getEntityManager().persist((Object)store);
        this.getEntityManager().persist((Object)customer1);
        this.getEntityManager().persist((Object)customer2);
        this.getEntityManager().flush();
        this.clearCache();
        this.getEntityTransaction().commit();
        this.clearCache();
        this.getEntityTransaction().begin();
        try {
            Query q = this.getEntityManager().createQuery("select s from Store s where s.id= :id");
            q.setParameter("id", (Object)78600);
            Store retrieveStore = (Store)q.getSingleResult();
            this.getEntityManager().refresh((Object)retrieveStore);
            Map<String, Customers> retrieveCustomers = retrieveStore.getCustomers();
            if (retrieveCustomers.get(CUSTOMER1_NAME).getId() != 420 || retrieveCustomers.get(CUSTOMER2_NAME).getId() != 640) {
                throw new Exception("Expected to read relationship as a Map with customers - 420 and 640Actual Customers in the Map - " + retrieveCustomers.get(CUSTOMER1_NAME).getId() + " and " + retrieveCustomers.get(CUSTOMER2_NAME).getId());
            }
            this.logTrace("Test Passed");
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing testNoMapKeyAnnotation" + e);
        }
    }

    public void testOverrideOrderBy() throws Exception {
        Consumer consumer1 = new Consumer();
        consumer1.setId(2L);
        RetailOrder order1 = this.createOrder(786L, consumer1, 115.0);
        RetailOrder order2 = this.createOrder(787L, consumer1, 100.0);
        RetailOrder order3 = this.createOrder(788L, consumer1, 110.0);
        RetailOrder order4 = this.createOrder(789L, consumer1, 105.0);
        this.consumer1Orders = new ArrayList<RetailOrder>();
        this.consumer1Orders.add(order1);
        this.consumer1Orders.add(order2);
        this.consumer1Orders.add(order3);
        this.consumer1Orders.add(order4);
        consumer1.setOrders(this.consumer1Orders);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)consumer1);
        this.getEntityManager().persist((Object)order1);
        this.getEntityManager().persist((Object)order2);
        this.getEntityManager().persist((Object)order3);
        this.getEntityManager().persist((Object)order4);
        this.getEntityManager().flush();
        this.clearCache();
        this.getEntityTransaction().commit();
        this.clearCache();
        this.getEntityTransaction().begin();
        Collections.sort(this.consumer1Orders, new RetailOrderCostComparatorDESC());
        try {
            Query q = this.getEntityManager().createQuery("select c from Consumer c where c.id= :id");
            q.setParameter("id", (Object)2L);
            Consumer consumer = (Consumer)q.getSingleResult();
            List<RetailOrder> actualRetailOrders = consumer.getOrders();
            if (!this.consumer1Orders.equals(actualRetailOrders)) {
                throw new Exception("The expected Orders List is not equal to the actual List read from the DB");
            }
            this.logTrace("Test Passed");
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing testOverrideOrderBy" + e);
        }
    }

    private Employee createEmployee(long id, String code) {
        Employee emp = new Employee();
        emp.setId(id);
        emp.setCode(code);
        return emp;
    }

    private Department createDepartment(long id, String name) {
        Department dept = new Department();
        dept.setId(id);
        dept.setName(name);
        return dept;
    }

    private TheatreLocation createTheatreLocation(long id, String code) {
        TheatreLocation loc = new TheatreLocation();
        loc.setId(id);
        loc.setCode(code);
        return loc;
    }

    private TheatreCompany createTheatreCompany(long id, String name) {
        TheatreCompany company = new TheatreCompany();
        company.setId(id);
        company.setName(name);
        return company;
    }

    private Customers createCustomers(int id, String name, Store store) {
        Customers customer = new Customers();
        customer.setId(id);
        customer.setCustName(name);
        customer.setStore(store);
        return customer;
    }

    private Store createStore(int id, String storeName) {
        Store store = new Store();
        store.setId(id);
        store.setName(storeName);
        return store;
    }

    private RetailOrder createOrder(long id, Consumer consumer, double cost) {
        RetailOrder order = new RetailOrder();
        order.setId(id);
        order.addConsumer(consumer);
        order.setCost(cost);
        return order;
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from  DEPARTMENT_2").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE_2").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from  STORE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from  CUSTOMERS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from  THEATRELOCATION_THEATRECOMPANY").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from  RETAILORDER_CONSUMER").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from  RETAILORDER").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from  CONSUMER").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from  THEATRELOCATION").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from  THEATRECOMPANY").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

